/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui;

import com.bwanms.gui.I18nException;
import com.bwanms.gui.Internationalizer;
import java.io.Serializable;

public abstract class AbstractI18nException
extends Exception
implements I18nException {
    private String i18nName;
    private String i18nKey;
    private Serializable[] i18nParams;
    private boolean useI18N = false;

    public AbstractI18nException() {
    }

    public AbstractI18nException(String message, Throwable cause) {
        super(message, cause);
    }

    public AbstractI18nException(String message) {
        super(message);
    }

    public AbstractI18nException(Throwable cause) {
        super(cause);
    }

    public AbstractI18nException(String i18nName, String i18nKey) {
        this.setI18nMessage(i18nName, i18nKey, null);
    }

    public AbstractI18nException(String i18nName, String i18nKey, Serializable[] i18nParams) {
        this.setI18nMessage(i18nName, i18nKey, i18nParams);
    }

    public boolean isI18NException() {
        return this.useI18N;
    }

    public String getI18nMessage() {
        Internationalizer i18n = Internationalizer.getInternationalizer(this.i18nName);
        if (i18n == null) {
            return this.toString();
        }
        return this.i18nParams == null ? i18n.translateString(this.i18nKey) : i18n.translateString(this.i18nKey, this.i18nParams);
    }

    public void setI18nMessage(String i18nName, String i18nKey, Serializable[] i18nParams) {
        this.i18nName = i18nName;
        this.i18nKey = i18nKey;
        this.i18nParams = i18nParams;
        this.useI18N = true;
    }

    public String getMessage() {
        if (this.useI18N) {
            return this.getI18nMessage();
        }
        return super.getMessage();
    }

    public String toString() {
        if (this.useI18N) {
            return this.toI18nString();
        }
        return super.toString();
    }

    protected String toI18nString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName()).append(" : ");
        buf.append("*").append(this.i18nKey).append("*").append(" : ");
        buf.append("[");
        if (this.i18nParams != null) {
            int i;
            for (i = 0; i < this.i18nParams.length - 1; ++i) {
                buf.append(this.i18nParams[i]).append(",");
            }
            buf.append(this.i18nParams[i]);
        }
        buf.append("]");
        return buf.toString();
    }
}

