/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui;

import com.bwanms.gui.EditorView;
import com.bwanms.gui.EditorViewContext;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.BindingCallback;
import com.bwanms.gui.binding.BindingManager;
import com.bwanms.util.UserInterfaceUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBindedEditorView<T extends Serializable>
implements EditorView<T> {
    protected T entity;
    protected BindingManager bindingManager;
    protected EditorViewContext ctx;

    @Override
    public void setEntity(T entity) {
        this.entity = entity;
        this.bindingManager = new BindingManager(this.getBinders(), this.getCallback());
        this.bindingManager.fillUI();
        this.fillUI(entity);
    }

    public BindingCallback getCallback() {
        return null;
    }

    public List<Binder> getBinders() {
        return new ArrayList<Binder>();
    }

    public void fillUI(T entity) {
    }

    @Override
    public List<InvalidValue> configureEntity(T entity) {
        this.bindingManager.configAndValidate();
        return AbstractBindedEditorView.getEscapedInvalidValues(this.bindingManager.getInvalidValues());
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void processExternalInvalidValues(List<InvalidValue> invalidValues) {
    }

    @Override
    public void setEntityContext(EditorViewContext ctx) {
        this.ctx = ctx;
    }

    public static List<InvalidValue> getEscapedInvalidValues(List<InvalidValue> invalidValues) {
        ArrayList<InvalidValue> escapedInvalidValues = new ArrayList<InvalidValue>(invalidValues.size());
        for (InvalidValue iv : invalidValues) {
            escapedInvalidValues.add(new EscapedInvalidValue(iv.getMessage(), iv.getBeanClass(), iv.getPropertyName(), iv.getValue(), iv.getBean()));
        }
        return escapedInvalidValues;
    }

    @Override
    public void setClientData(Object data) {
    }

    public EditorViewContext<T> getEditorViewContext() {
        return this.ctx;
    }

    static class EscapedInvalidValue
    extends InvalidValue {
        private static final long serialVersionUID = 5267010476734849949L;

        EscapedInvalidValue(String message, Class beanClass, String propertyName, Object value, Object bean) {
            super(message, beanClass, propertyName, value, bean);
        }

        public Object getValue() {
            if (super.getValue() == null) {
                return null;
            }
            return UserInterfaceUtil.escapeHTML(super.getValue().toString());
        }
    }
}

