/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.frontend.nbi.snmp;

import com.bwanms.mediation.snmp.SNMPTrapAgentEvent;
import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.nbi.Nbi;
import com.bwanms.model.fault.nbi.NbiSNMPParams;
import com.bwanms.protocols.snmp.VarBind;
import com.bwanms.protocols.snmp.VarBindList;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Opaque;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrapSender {
    private static Snmp snmp;

    public static void send(Event event, List<Nbi> nbiList) throws IOException {
        PDU pdu = TrapSender.createPDU(event.getEventCause());
        Target target = TrapSender.createTarget(null);
        for (Nbi nbi : nbiList) {
            target.setAddress((Address)new UdpAddress(String.format("%s/%d", nbi.getIpAddress(), ((NbiSNMPParams)nbi.getProtocolParams()).getTrapPort())));
            TrapSender.sendTrap(pdu, target);
        }
    }

    public static void send(Event event, String ipAddress, int port) throws IOException {
        TrapSender.sendTrap(TrapSender.createPDU(event.getEventCause()), TrapSender.createTarget((Address)new UdpAddress(String.format("%s/%d", ipAddress, port))));
    }

    private static void sendTrap(PDU trap, Target target) throws IOException {
        switch (trap.getType()) {
            case -92: {
                if (!(trap instanceof PDUv1)) break;
                target.setVersion(0);
                snmp.trap((PDUv1)trap, target);
                break;
            }
            case -89: {
                target.setVersion(1);
                snmp.send(trap, target);
                break;
            }
        }
    }

    private static PDU createPDU(Serializable trap) {
        PDU pdu = null;
        if (trap instanceof SNMPTrapV1AgentEvent) {
            SNMPTrapV1AgentEvent trapV1 = (SNMPTrapV1AgentEvent)trap;
            PDUv1 pduV1 = new PDUv1();
            pduV1.setType(-92);
            pduV1.setAgentAddress(new IpAddress(trapV1.getAgentIPAddress()));
            long timestamp = trapV1.getTimestamp();
            pduV1.setTimestamp(timestamp > 0xFFFFFFFFL ? 0L : timestamp);
            pduV1.setEnterprise(new OID(trapV1.getEnterpriseOID()));
            pduV1.setGenericTrap(trapV1.getGeneric());
            pduV1.setSpecificTrap(trapV1.getSpecific());
            TrapSender.addVarBindings((PDU)pduV1, trapV1.getVarBindList());
            pdu = pduV1;
        } else if (trap instanceof SNMPTrapAgentEvent) {
            pdu = new PDU();
            pdu.setType(-89);
            SNMPTrapAgentEvent trapV2c = (SNMPTrapAgentEvent)trap;
            TrapSender.addVarBindings(pdu, trapV2c.getVarBindList());
        }
        return pdu;
    }

    private static Target createTarget(Address address) {
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString("public"));
        target.setAddress(address);
        target.setRetries(2);
        target.setTimeout(1000L);
        return target;
    }

    private static void addVarBindings(PDU pdu, VarBindList varBindList) {
        for (VarBind varBind : varBindList) {
            OID oid = new OID(varBind.getOID());
            Variable var = TrapSender.createVariable(varBind.getType(), varBind.getVariable());
            pdu.add(new VariableBinding(oid, var));
        }
    }

    private static Variable createVariable(int type, Object value) {
        Null result = null;
        if (value == null) {
            result = new Null();
        } else {
            switch (type) {
                case 2: {
                    result = new Integer32(((Integer)value).intValue());
                    break;
                }
                case 4: {
                    result = OctetString.fromHexString((String)value.toString());
                    break;
                }
                case 5: {
                    result = new Null();
                    break;
                }
                case 6: {
                    result = new OID(value.toString());
                    break;
                }
                case 48: {
                    throw new RuntimeException("Not yet implemented.");
                }
                case 64: {
                    result = new IpAddress((String)value);
                    break;
                }
                case 65: {
                    result = new Counter32(((Long)value).longValue());
                    break;
                }
                case 66: {
                    result = new Gauge32(((Long)value).longValue());
                    break;
                }
                case 67: {
                    result = new TimeTicks(((Long)value).longValue());
                    break;
                }
                case 68: {
                    result = new Opaque((byte[])value);
                    break;
                }
                case 70: {
                    result = new Counter64(((Long)value).longValue());
                    break;
                }
                case 112: {
                    result = OctetString.fromHexString((String)value.toString());
                    break;
                }
                case -128: {
                    result = OctetString.fromHexString((String)value.toString());
                    break;
                }
                default: {
                    throw new RuntimeException("Not yet implemented.");
                }
            }
        }
        return result;
    }

    static {
        try {
            snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
            snmp.listen();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

