/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.frontend.nbi;

import com.bwanms.be.QueueHelper;
import com.bwanms.be.QueueIListener;
import com.bwanms.frontend.nbi.snmp.TrapSender;
import com.bwanms.mediation.snmp.SNMPTrapAgentEvent;
import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.nbi.Nbi;
import com.bwanms.model.fault.nbi.NbiPolicy;
import com.bwanms.model.fault.nbi.NbiPolicyFilterEquipment;
import com.bwanms.model.fault.nbi.NbiPolicyFilterEventCategory;
import com.bwanms.model.fault.nbi.NbiPolicyFilterEventType;
import com.bwanms.model.fault.nbi.NbiPolicyFilterEvtOID;
import com.bwanms.model.fault.nbi.NbiPolicyFilterLocation;
import com.bwanms.model.fault.nbi.NbiPolicyFilterMOAlias;
import com.bwanms.model.fault.nbi.NbiPolicyFilterMOInst;
import com.bwanms.model.fault.nbi.NbiPolicyFilterMOType;
import com.bwanms.model.fault.nbi.NbiPolicyFilterNEType;
import com.bwanms.model.fault.nbi.NbiPolicyFilterSeverity;
import com.bwanms.model.fault.nbi.NbiProtocolParams;
import com.bwanms.model.fault.nbi.NbiSNMPParams;
import com.bwanms.util.fault.NBIUtil;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NbiListenerWorker
implements QueueIListener,
Runnable {
    private static final Logger log = Logger.getLogger(NbiListenerWorker.class);
    private static Calendar cal = Calendar.getInstance();
    private AtomicBoolean stop = new AtomicBoolean(false);
    private Map<Long, Nbi> nbiMap;

    public NbiListenerWorker(Map<Long, Nbi> nbiMap) {
        this.nbiMap = nbiMap;
    }

    @Override
    public void run() {
        while (!this.stop.get()) {
            try {
                List processingEvents = (List)QueueHelper.pullMsg("queue/NbiEvent");
                Map<Event, List<Nbi>> map = this.match(processingEvents, this.nbiMap);
                this.forward(map);
            }
            catch (Exception ex) {
                log.debug((Object)ex.getMessage(), (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    private void forward(Map<Event, List<Nbi>> map) throws Exception {
        for (Map.Entry<Event, List<Nbi>> elem : map.entrySet()) {
            TrapSender.send(elem.getKey(), elem.getValue());
        }
    }

    @Override
    public void notifyGetBatch() {
    }

    public void prepareToStop() {
        this.stop.set(true);
    }

    private Map<Event, List<Nbi>> match(List<Event> events, Map<Long, Nbi> nbis) {
        LinkedHashMap<Event, List<Nbi>> map = new LinkedHashMap<Event, List<Nbi>>();
        for (Event event : events) {
            List<Nbi> matchedNbis = this.match(event, nbis);
            if (matchedNbis.size() <= 0) continue;
            map.put(event, matchedNbis);
        }
        return map;
    }

    private List<Nbi> match(Event event, Map<Long, Nbi> nbis) {
        LinkedList<Nbi> ret = new LinkedList<Nbi>();
        block0: for (Nbi nbi : nbis.values()) {
            if (nbi.getEnabled() == 0 || !this.checkProtocol(nbi, event)) continue;
            List<NbiPolicy> policies = nbi.getPolicies();
            for (NbiPolicy nbiPolicy : policies) {
                if (!this.checkPolicy(nbiPolicy, event)) continue;
                ret.add(nbi);
                continue block0;
            }
        }
        return ret;
    }

    private boolean checkProtocol(Nbi nbi, Event event) {
        NbiProtocolParams protocol = nbi.getProtocolParams();
        if (protocol instanceof NbiSNMPParams) {
            NbiSNMPParams snmpParams = (NbiSNMPParams)protocol;
            Serializable eventCause = event.getEventCause();
            if (eventCause instanceof SNMPTrapV1AgentEvent) {
                return true;
            }
            if (eventCause instanceof SNMPTrapAgentEvent) {
                if (snmpParams.getVersion() > 0) {
                    return true;
                }
                log.warn((Object)String.format("Cannot forward event to %s (%s) : unsupported SNMP version", nbi.getName(), nbi.getIpAddress()));
            }
        } else {
            log.warn((Object)String.format("Cannot forward event to %s (%s) : unsupported protocol", nbi.getName(), nbi.getIpAddress()));
        }
        return false;
    }

    private boolean checkPolicy(NbiPolicy nbiPolicy, Event event) {
        if (nbiPolicy.getEnabled() == 0) {
            return false;
        }
        return this.checkPolicyTime(nbiPolicy.getPolicyTime(), event) && this.checkPolicyFilter(nbiPolicy.getPolicyFilter(), event);
    }

    private boolean checkPolicyTime(NbiPolicy.NbiPolicyTime policyTime, Event event) {
        if (policyTime == null) {
            return false;
        }
        long eventTime = System.currentTimeMillis();
        cal.setTimeInMillis(eventTime);
        int day = cal.get(7);
        cal.setTimeInMillis(policyTime.getStartTime());
        int startHour = cal.get(11);
        int startMin = cal.get(12);
        cal.setTimeInMillis(eventTime);
        cal.set(11, startHour);
        cal.set(12, startMin);
        long startTime = cal.getTimeInMillis();
        cal.setTimeInMillis(policyTime.getEndTime());
        int endHour = cal.get(11);
        int endMin = cal.get(12);
        cal.setTimeInMillis(eventTime);
        cal.set(11, endHour);
        cal.set(12, endMin);
        long endTime = cal.getTimeInMillis();
        Collection<Integer> days = NBIUtil.getDays(policyTime.getDays());
        return days.contains(day) && eventTime >= startTime && eventTime <= endTime;
    }

    private boolean checkPolicyFilter(NbiPolicy.NbiPolicyFilter filter, Event event) {
        if (filter == null) {
            return false;
        }
        Set<NbiPolicyFilterEventCategory> eventCategories = filter.getEventCategories();
        if (!eventCategories.isEmpty() && !NBIUtil.getEventCategories(eventCategories).contains(event.getEventCategory())) {
            return false;
        }
        Set<NbiPolicyFilterEventType> eventTypes = filter.getEventTypes();
        if (!eventTypes.isEmpty() && !NBIUtil.getEventTypes(eventTypes).contains(event.getEventType())) {
            return false;
        }
        Set<NbiPolicyFilterSeverity> severities = filter.getSeverities();
        if (!severities.isEmpty() && !NBIUtil.getSeverities(severities).contains(event.getEventSeverity())) {
            return false;
        }
        Set<NbiPolicyFilterNEType> neTypes = filter.getNeTypes();
        if (!neTypes.isEmpty() && !NBIUtil.getNeTypes(neTypes).contains(event.getEquipmentType())) {
            return false;
        }
        Set<NbiPolicyFilterMOType> moTypes = filter.getMoTypes();
        if (!moTypes.isEmpty() && !NBIUtil.getMoTypes(moTypes).contains(event.getMoType())) {
            return false;
        }
        Set<NbiPolicyFilterMOInst> moInstances = filter.getMoInstances();
        if (!moInstances.isEmpty() && !NBIUtil.getMoInstances(moInstances).contains(event.getMoInstance())) {
            return false;
        }
        Set<NbiPolicyFilterMOAlias> moAliases = filter.getMoAliases();
        if (!moAliases.isEmpty() && !NBIUtil.getMoAliases(moAliases).contains(event.getMoAlias())) {
            return false;
        }
        Set<NbiPolicyFilterEvtOID> eventOIDs = filter.getEventOIDs();
        if (!eventOIDs.isEmpty() && !NBIUtil.getEventOIDs(eventOIDs).contains(event.getEventOID())) {
            return false;
        }
        Set<NbiPolicyFilterEquipment> equipmentIds = filter.getEquipments();
        if (!equipmentIds.isEmpty() && !NBIUtil.getEquipmentIds(equipmentIds).contains(event.getEquipmentId())) {
            return false;
        }
        Set<NbiPolicyFilterLocation> locationIds = filter.getLocations();
        return locationIds.isEmpty() || NBIUtil.getLocationIds(locationIds).contains(event.getLocationId());
    }

    static {
        cal.setLenient(false);
    }
}

