/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.frontend.nbi;

import com.bwanms.frontend.nbi.NbiEventForwardingServiceIntf;
import com.bwanms.frontend.nbi.NbiListenerWorker;
import com.bwanms.model.fault.nbi.Nbi;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.ExecutorUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class NbiEventForwardingServiceImpl
implements NbiEventForwardingServiceIntf {
    private static final int POLLING_INTERVAL = 60000;
    Map<Long, Nbi> nbiMap = Collections.synchronizedMap(new HashMap());
    private ScheduledExecutorService refreshDaemon = Executors.newSingleThreadScheduledExecutor();
    private NbiListenerWorker listenerWorker = new NbiListenerWorker(this.nbiMap);

    public NbiEventForwardingServiceImpl() {
        try {
            this.refresh();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    public void start() {
        this.refreshDaemon.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                try {
                    NbiEventForwardingServiceImpl.this.refresh();
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
            }
        }, 0L, 60000L, TimeUnit.MILLISECONDS);
        new Thread((Runnable)this.listenerWorker, "NBI LISTENER THREAD").start();
    }

    public void stop() {
        ExecutorUtils.shutdownAndWait("NBI-REFRESH", this.refreshDaemon, 5);
    }

    private void refresh() throws ServiceException {
        List<Nbi> list = ServiceRegistry.getEntityManagerService().retrieveAll(Nbi.class);
        this.nbiMap.clear();
        for (Nbi nbi : list) {
            this.nbiMap.put(nbi.getId(), nbi);
        }
    }
}

