/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.entitymanager;

import com.bwanms.model.entity.Assembly;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityManagerRow
implements Assembly {
    private static final long serialVersionUID = -1868458973890948955L;
    protected Serializable entity;
    protected List<String> attributes;
    protected List<Serializable> values;
    protected Serializable clientData;
    protected String id;
    private transient List<String> displayValues;

    public EntityManagerRow(Serializable entity, String id, List<String> attributes, List<Serializable> values, Serializable clientData) {
        this.entity = entity;
        this.id = id;
        this.attributes = attributes;
        this.values = values;
        this.clientData = clientData;
    }

    public Serializable getAttributeValue(String attributeName) {
        int idx = 0;
        for (String attrName : this.attributes) {
            if (attrName.equals(attributeName)) {
                return this.getAttributeValue(idx);
            }
            ++idx;
        }
        return null;
    }

    public Serializable getAttributeValue(int attributeIdx) {
        return this.values.get(attributeIdx);
    }

    public void setAttributeValue(String attributeName, Serializable value) {
        int idx = 0;
        for (String attrName : this.attributes) {
            if (attrName.equals(attributeName)) {
                this.setAttributeValue(idx, value);
                return;
            }
            ++idx;
        }
    }

    public void setAttributeValue(int attributeIdx, Serializable value) {
        this.values.set(attributeIdx, value);
    }

    public String getClassName() {
        return this.entity.getClass().getName();
    }

    public String getId() {
        return this.id;
    }

    public Serializable getEntity() {
        return this.entity;
    }

    public Serializable getClientData() {
        return this.clientData;
    }

    public List<String> getDisplayValues() {
        return this.displayValues;
    }

    public void setDisplayValues(List<String> displayValues) {
        this.displayValues = displayValues;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityManagerRow other = (EntityManagerRow)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

