/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.domain.logic.ejb;

import com.bwanms.ddi.ConfigurationChangedEvent;
import com.bwanms.ddi.ConfigurationNotSynchronizedException;
import com.bwanms.ddi.DDInterface;
import com.bwanms.ddi.DDRegistry;
import com.bwanms.domain.logic.ConfigurationHelper;
import com.bwanms.domain.logic.Helpers;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.mo.AbstractTableMO;
import com.bwanms.mo.EquipmentConfiguration;
import com.bwanms.mo.MOUtils;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.TableRowMO;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.model.Equipment;
import com.bwanms.persistence.Datastore;
import com.bwanms.protocols.Protocol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationHelperEJB
extends ConfigurationHelper {
    private static final Logger logger = Logger.getLogger(ConfigurationHelperEJB.class);

    @Override
    @Deprecated
    public List<ManagedObject> retrieveCurrentConfiguration(long equipmentId, String networkResourceConfigurationName, Class<? extends ManagedObject> moClass, boolean forceRefresh) throws MediationException {
        ArrayList<Class<? extends ManagedObject>> moClasses = new ArrayList<Class<? extends ManagedObject>>();
        moClasses.add(moClass);
        return this.retrieveCurrentConfiguration(equipmentId, networkResourceConfigurationName, moClasses, forceRefresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ManagedObject> List<T> retrieveCurrentConfiguration(long equipmentId, String networkResource, Class<T> moClass, String instanceQuery, boolean forceRefresh) throws MediationException {
        List<T> list;
        MOAccessSession access = null;
        try {
            Equipment e = this.findEquipment(equipmentId);
            EquipmentConfiguration configuration = e.findCurrentConfiguration();
            NetworkResourceConfiguration nrConfig = configuration.findNetworkResourceConfiguration(networkResource);
            access = this.getMOAccessSession(e, configuration);
            list = this.retrieveCurrentConfiguration(access, nrConfig, moClass, instanceQuery, forceRefresh);
        }
        catch (Throwable throwable) {
            this.disposeMOAccessSession(access);
            throw throwable;
        }
        this.disposeMOAccessSession(access);
        return list;
    }

    @Override
    public <T extends ManagedObject> List<T> retrieveCurrentConfiguration(MOAccessSession access, NetworkResourceConfiguration nrConfig, Class<T> moClass, String instanceQuery, boolean forceRefresh) throws MediationException {
        List<ManagedObject> persistent = nrConfig.retrieveManagedObjects(moClass, instanceQuery);
        if (forceRefresh || persistent.isEmpty() || ConfigurationHelperEJB.hasNullStateAttributes(nrConfig.getConfiguration().getEquipment(), persistent)) {
            ManagedObjectAccessHandler<T> handler = ManagedObjectAccessHandlerRegistry.findHandler(moClass, access.getProtocol());
            List<T> values = handler.fetch(nrConfig.getConfiguration().getEquipment(), access, nrConfig.getName(), instanceQuery);
            ArrayList<String> changedInstances = new ArrayList<String>();
            nrConfig.persistManagedObjects(moClass, instanceQuery, values, 7, changedInstances);
            this.processConfigurationChanges(nrConfig, moClass, changedInstances);
            Datastore.session().saveOrUpdate((Object)nrConfig);
            return new ArrayList<T>(nrConfig.retrieveManagedObjects(moClass, instanceQuery));
        }
        return new ArrayList<ManagedObject>(persistent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public List<ManagedObject> retrieveCurrentConfiguration(long equipmentId, String networkResourceConfigurationName, List<Class<? extends ManagedObject>> moClasses, boolean forceRefresh) throws MediationException {
        List<ManagedObject> list;
        MOAccessSession access = null;
        try {
            Equipment e = this.findEquipment(equipmentId);
            EquipmentConfiguration configuration = e.findCurrentConfiguration();
            access = this.getMOAccessSession(e, configuration);
            list = this.retrieveCurrentConfiguration(e, access, networkResourceConfigurationName, moClasses, forceRefresh);
        }
        catch (Throwable throwable) {
            this.disposeMOAccessSession(access);
            throw throwable;
        }
        this.disposeMOAccessSession(access);
        return list;
    }

    @Override
    public List<ManagedObject> retrieveCurrentConfiguration(Equipment eq, MOAccessSession access, String networkResourceConfigurationName, List<Class<? extends ManagedObject>> moClasses, boolean forceRefresh) throws MediationException {
        EquipmentConfiguration configuration = eq.findCurrentConfiguration();
        NetworkResourceConfiguration nrConfig = configuration.findNetworkResourceConfiguration(networkResourceConfigurationName);
        Class<? extends Protocol> protocol = access.getProtocol();
        List<ManagedObject> ret = null;
        ret = this.fetchMOs(access, protocol, nrConfig, moClasses, forceRefresh);
        Datastore.session().saveOrUpdate((Object)configuration);
        logger.debug((Object)("Return size: " + ret.size()));
        return ret;
    }

    @Override
    @Deprecated
    public void updateCurrentConfiguration(long equipmentId, ManagedObject mo) throws MediationException {
        ArrayList<ManagedObject> mos = new ArrayList<ManagedObject>();
        mos.add(mo);
        this.updateCurrentConfiguration(equipmentId, mos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <M extends ManagedObject> List<M> updateCurrentConfiguration(Equipment equipment, String nrConfigName, Class<M> moClass, String instanceQuery, List<M> values) throws MediationException {
        List<M> list;
        MOAccessSession access = null;
        try {
            EquipmentConfiguration configuration = equipment.findCurrentConfiguration();
            access = this.getMOAccessSession(equipment, configuration);
            list = this.updateCurrentConfiguration(access, configuration.findNetworkResourceConfiguration(nrConfigName), moClass, instanceQuery, values);
        }
        catch (Throwable throwable) {
            this.disposeMOAccessSession(access);
            throw throwable;
        }
        this.disposeMOAccessSession(access);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public <M extends ManagedObject> List<M> updateCurrentConfiguration(long equipmentId, String nrConfigName, Class<M> moClass, String instanceQuery, List<M> values) throws MediationException {
        List<M> list;
        MOAccessSession access = null;
        try {
            Equipment eq = this.findEquipment(equipmentId);
            EquipmentConfiguration configuration = eq.findCurrentConfiguration();
            access = this.getMOAccessSession(eq, configuration);
            list = this.updateCurrentConfiguration(access, configuration.findNetworkResourceConfiguration(nrConfigName), moClass, instanceQuery, values);
        }
        catch (Throwable throwable) {
            this.disposeMOAccessSession(access);
            throw throwable;
        }
        this.disposeMOAccessSession(access);
        return list;
    }

    @Override
    public <M extends ManagedObject> List<M> updateCurrentConfiguration(MOAccessSession access, NetworkResourceConfiguration nrConfig, Class<M> moClass, String instanceQuery, List<M> values) throws MediationException {
        boolean found;
        Equipment eq = nrConfig.getConfiguration().getEquipment();
        List<M> persistentEntries = nrConfig.retrieveManagedObjects(moClass, instanceQuery);
        ManagedObjectAccessHandler<ManagedObject> moHandler = ManagedObjectAccessHandlerRegistry.findHandler(moClass, access.getProtocol());
        for (ManagedObject entry : values) {
            found = false;
            for (ManagedObject persistent : persistentEntries) {
                if (!entry.getRowKey().equals(persistent.getRowKey())) continue;
                if (MOUtils.changedMO(persistent, entry)) {
                    moHandler.update(eq, access, nrConfig.getName(), entry);
                }
                found = true;
                break;
            }
            if (found) continue;
            moHandler.add(eq, access, nrConfig.getName(), entry);
        }
        for (ManagedObject persistent : persistentEntries) {
            found = false;
            for (ManagedObject entry : values) {
                if (!persistent.getRowKey().equals(entry.getRowKey())) continue;
                found = true;
                break;
            }
            if (found) continue;
            moHandler.delete(eq, access, nrConfig.getName(), persistent);
        }
        ArrayList<String> changedInstances = new ArrayList<String>();
        List<M> ret = nrConfig.persistManagedObjects(moClass, "*", values, 1, changedInstances);
        this.processConfigurationChanges(nrConfig, moClass, changedInstances);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCurrentConfiguration(long equipmentId, List<ManagedObject> mos) throws MediationException {
        MOAccessSession access = null;
        try {
            Equipment eq = this.findEquipment(equipmentId);
            EquipmentConfiguration configuration = eq.findCurrentConfiguration();
            access = this.getMOAccessSession(eq, configuration);
            Class<? extends Protocol> protocol = access.getProtocol();
            for (ManagedObject mo : mos) {
                ManagedObjectAccessHandler<Object> moHandler;
                Class<?> moClass = mo.getClass();
                ArrayList<String> changedInstances = new ArrayList<String>();
                NetworkResourceConfiguration nrConfig = null;
                if (UnifiedMOSupport.class.isAssignableFrom(moClass)) {
                    UnifiedMOSupport moSupport = (UnifiedMOSupport)mo;
                    nrConfig = configuration.findNetworkResourceConfiguration(moSupport.getNRConfigName());
                    moHandler = ManagedObjectAccessHandlerRegistry.findHandler(moSupport.getParameterClass(), protocol);
                    for (ManagedObject moInst : moSupport.getRemovedInstances()) {
                        moHandler.delete(eq, access, nrConfig.getName(), moInst);
                    }
                    ArrayList<String> instances = new ArrayList<String>();
                    for (ManagedObject moInst : moSupport.getChangedInstances()) {
                        instances.add(moInst.getRowKey());
                    }
                    Map persistentMap = nrConfig.retrieveManagedObjects(moSupport.getParameterClass(), instances);
                    for (ManagedObject moInst : moSupport.getChangedInstances()) {
                        ManagedObject persistentInst = (ManagedObject)persistentMap.get(moInst.getRowKey());
                        if (persistentInst == null || !MOUtils.changedMO(persistentInst, moInst)) continue;
                        moHandler.update(eq, access, nrConfig.getName(), moInst);
                    }
                    for (ManagedObject moInst : moSupport.getNewInstances()) {
                        moInst.setNRConfiguration(nrConfig);
                        moHandler.add(eq, access, nrConfig.getName(), moInst);
                    }
                    ArrayList<ManagedObject> valueMOs = new ArrayList<ManagedObject>();
                    valueMOs.add(mo);
                    nrConfig.persistManagedObjects(moSupport, 1, changedInstances);
                    this.processConfigurationChanges(nrConfig, moSupport.getParameterClass(), changedInstances);
                    continue;
                }
                if (AbstractTableMO.class.isAssignableFrom(moClass)) {
                    nrConfig = configuration.findNetworkResourceConfiguration(mo.getNRConfiguration().getName());
                    AbstractTableMO persistentTable = (AbstractTableMO)nrConfig.retrieveManagedObjects(moClass, "*").get(0);
                    AbstractTableMO moTable = (AbstractTableMO)mo;
                    ManagedObjectAccessHandler moHandler2 = ManagedObjectAccessHandlerRegistry.findHandler(moTable.getParameterClass(), protocol);
                    for (TableRowMO entry : moTable.getEntries()) {
                        boolean found = false;
                        for (TableRowMO persistent : persistentTable.getEntries()) {
                            if (!entry.getRowKey().equals(persistent.getRowKey())) continue;
                            if (MOUtils.changedMO(persistent, entry)) {
                                moHandler2.update(eq, access, nrConfig.getName(), entry);
                            }
                            found = true;
                            break;
                        }
                        if (found) continue;
                        moHandler2.add(eq, access, nrConfig.getName(), entry);
                    }
                    for (TableRowMO persistent : persistentTable.getEntries()) {
                        boolean found = false;
                        for (TableRowMO entry : moTable.getEntries()) {
                            if (!persistent.getRowKey().equals(entry.getRowKey())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        moHandler2.delete(eq, access, nrConfig.getName(), persistent);
                    }
                    ArrayList<ManagedObject> valueMOs = new ArrayList<ManagedObject>();
                    valueMOs.add(mo);
                    nrConfig.persistManagedObjects(moTable.getParameterClass(), "*", moTable.getEntries(), 1, changedInstances);
                    this.processConfigurationChanges(nrConfig, moTable.getParameterClass(), changedInstances);
                    continue;
                }
                nrConfig = configuration.findNetworkResourceConfiguration(mo.getNRConfiguration().getName());
                ManagedObject persistent = (ManagedObject)nrConfig.retrieveManagedObjects(moClass, "*").get(0);
                moHandler = ManagedObjectAccessHandlerRegistry.findHandler(moClass, protocol);
                if (MOUtils.changedMO(persistent, mo)) {
                    moHandler.update(eq, access, nrConfig.getName(), mo);
                }
                ArrayList<ManagedObject> valueMOs = new ArrayList<ManagedObject>();
                valueMOs.add(mo);
                nrConfig.persistManagedObjects(moClass, "*", valueMOs, 1, changedInstances);
                this.processConfigurationChanges(nrConfig, moClass, changedInstances);
            }
        }
        catch (Throwable throwable) {
            this.disposeMOAccessSession(access);
            throw throwable;
        }
        this.disposeMOAccessSession(access);
    }

    @Override
    public void removeFromCurrentConfiguration(NetworkResourceConfiguration nrConfig, Class<? extends ManagedObject> moClass, String instanceQuery) {
        ArrayList<String> changedInstances = new ArrayList<String>();
        nrConfig.persistManagedObjects(moClass, instanceQuery, new ArrayList(), 7, changedInstances);
        this.processConfigurationChanges(nrConfig, moClass, changedInstances);
    }

    private List<ManagedObject> getChangedMOs(List<ManagedObject> mos) {
        ArrayList<ManagedObject> changedMOs = new ArrayList<ManagedObject>();
        for (ManagedObject mo : mos) {
            if (!mo.getChangeStrategy().isChanged()) continue;
            changedMOs.add(mo);
        }
        return changedMOs;
    }

    private List<ManagedObject> fetchMOs(MOAccessSession access, Class<? extends Protocol> protocol, NetworkResourceConfiguration nrConfig, List<Class<? extends ManagedObject>> moClasses, boolean forceRefresh) throws MediationException {
        ArrayList<ManagedObject> ret = new ArrayList<ManagedObject>();
        for (Class<? extends ManagedObject> moClass : moClasses) {
            ArrayList<String> changedInstances = new ArrayList<String>();
            logger.debug((Object)("Fetching: " + moClass.getName()));
            List<? extends ManagedObject> persistentMOs = nrConfig.retrieveManagedObjects(moClass, "*");
            if (AbstractTableMO.class.isAssignableFrom(moClass)) {
                AbstractTableMO moTable = (AbstractTableMO)persistentMOs.get(0);
                if (!ConfigurationHelperEJB.hasNullStateAttributes(nrConfig.getConfiguration().getEquipment(), moTable) && !forceRefresh) {
                    ret.addAll(persistentMOs);
                    continue;
                }
                ManagedObjectAccessHandler handler = ManagedObjectAccessHandlerRegistry.findHandler(moTable.getParameterClass(), protocol);
                List entryValues = handler.fetch(nrConfig.getConfiguration().getEquipment(), access, nrConfig.getName(), "*");
                nrConfig.persistManagedObjects(moTable.getParameterClass(), "*", entryValues, 7, changedInstances);
                ret.addAll(nrConfig.retrieveManagedObjects(moClass, "*"));
                this.processConfigurationChanges(nrConfig, moTable.getParameterClass(), changedInstances);
                continue;
            }
            if (!(persistentMOs.isEmpty() || ConfigurationHelperEJB.hasNullStateAttributes(nrConfig.getConfiguration().getEquipment(), persistentMOs.get(0)) || forceRefresh)) {
                ret.addAll(persistentMOs);
                continue;
            }
            ManagedObjectAccessHandler<? extends ManagedObject> moHandler = ManagedObjectAccessHandlerRegistry.findHandler(moClass, protocol);
            List<? extends ManagedObject> values = moHandler.fetch(nrConfig.getConfiguration().getEquipment(), access, nrConfig.getName(), "*");
            nrConfig.persistManagedObjects(moClass, "*", values, 7, changedInstances);
            ret.addAll(nrConfig.retrieveManagedObjects(moClass, "*"));
            this.processConfigurationChanges(nrConfig, moClass, changedInstances);
        }
        Datastore.session().saveOrUpdate((Object)nrConfig);
        return ret;
    }

    @Override
    public void processConfigurationChanges(NetworkResourceConfiguration nrConfig, Class<? extends ManagedObject> moClass, Collection<String> changedInstances) {
        if (changedInstances.isEmpty()) {
            return;
        }
        Equipment eq = nrConfig.getConfiguration().getEquipment();
        String nrConfigName = nrConfig.getName();
        DDInterface ddi = DDRegistry.getInstance().getDDInterfaceByEquipmentClass(eq.getClass().getName());
        ConfigurationChangedEvent event = new ConfigurationChangedEvent(eq.getId(), nrConfigName, moClass, changedInstances);
        try {
            List<ConfigurationChangedEvent> events = ddi.getSynchronizationStrategy(nrConfig.getConfiguration().getEquipment(), Helpers.getDDCallback()).configurationChanged(event);
            if (events != null) {
                for (ConfigurationChangedEvent evt : events) {
                    Helpers.getDDCallback().configurationChanged(evt);
                }
            }
        }
        catch (ConfigurationNotSynchronizedException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private static boolean hasNullStateAttributes(Equipment eq, List<ManagedObject> mos) {
        Class[] stateAnnotations = new Class[]{StateAttribute.class, InventoryAttribute.class, ConfigAttribute.class};
        for (ManagedObject mo : mos) {
            if (!MOUtils.hasNullAnnotatedAttributes(eq, mo, stateAnnotations)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNullStateAttributes(Equipment eq, ManagedObject mo) {
        Class[] stateAnnotations = new Class[]{StateAttribute.class, InventoryAttribute.class, ConfigAttribute.class};
        if (mo instanceof AbstractTableMO) {
            if (((AbstractTableMO)mo).getSize() == 0) {
                return true;
            }
            List entries = ((AbstractTableMO)mo).getEntries();
            for (ManagedObject entry : entries) {
                if (!MOUtils.hasNullAnnotatedAttributes(eq, entry, stateAnnotations)) continue;
                return true;
            }
            return false;
        }
        return MOUtils.hasNullAnnotatedAttributes(eq, mo, stateAnnotations);
    }
}

