/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.domain.logic;

import com.bwanms.domain.logic.NmsSystemLocator;
import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.model.Equipment;
import com.bwanms.model.ManagedEntity;
import com.bwanms.model.ManagedEntityBase;
import com.bwanms.model.NmsSystem;
import com.bwanms.model.Service;
import com.bwanms.model.ServiceProfile;
import com.bwanms.model.Task;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.constants.AlarmType;
import com.bwanms.model.fault.constants.ConfigChangeType;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.model.fault.constants.EventProtocol;
import com.bwanms.model.fault.constants.MOType;
import com.bwanms.model.fault.constants.NEType;
import com.bwanms.model.fault.constants.NMSTrap;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.model.fault.constants.SysEventType;
import com.bwanms.model.task.DatabaseAgingGenericTask;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.protocols.snmp.SNMPTrapV1;
import com.bwanms.protocols.snmp.VarBind;
import com.bwanms.protocols.snmp.VarBindList;
import com.bwanms.services.impl.ManagedEntityStateManager;
import com.bwanms.util.OctetString;
import com.bwanms.util.fault.EventUtil;
import com.bwanms.util.fault.TrapInternationalizer;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class SystemEntityEvents {
    private static final Logger log = Logger.getLogger(SystemEntityEvents.class);
    private static final long startupTime = System.currentTimeMillis();
    public static final int MANAGEDENTITY_CREATED = 1;
    public static final int MANAGEDENTITY_REMOVED = 2;
    public static final int EQUIPMENT_UNREACHABLE = 10;
    public static final int EQUIPMENT_UP = 11;
    public static final int EQUIPMENT_DOWN = 12;
    public static final int EQUIPMENT_RESET_DETECTED = 13;
    public static final int EQUIPMENT_COMM_ERROR = 14;
    public static final int EQUIPMENT_COMM_OK = 15;
    public static final int DATABASE_AGING_REPORT = 20;
    public static final int SYSTEM_EVENTS = 0x100000;
    private static final int SYSTEM_SPECIFIC_MASK = 1048575;
    public static final String OID_BWANMS = "1.3.6.1.4.1.12394.1.260.3";
    public static final String OID_MANAGEDENTITY_ID = "1.3.6.1.4.1.12394.1.260.3.1.1";
    public static final String OID_MANAGEDENTITY_NAME = "1.3.6.1.4.1.12394.1.260.3.1.2";
    public static final String OID_MANAGEDENTITY_TYPE = "1.3.6.1.4.1.12394.1.260.3.1.3";
    public static final String OID_INTERNAL_SEQ_NO = "1.3.6.1.4.1.12394.1.260.3.1.4";
    public static final String OID_DAP_TABLE_NAME = "1.3.6.1.4.1.12394.1.260.3.1.5";
    public static final String OID_DAP_THRESHOLD = "1.3.6.1.4.1.12394.1.260.3.1.6";
    public static final String OID_DAP_REMOVED_ROWS = "1.3.6.1.4.1.12394.1.260.3.1.7";
    public static final String OID_DAP_DURATION = "1.3.6.1.4.1.12394.1.260.3.1.8";
    public static final int SNMP_MANAGEDENTITY_TYPE_NMS = 0;
    public static final int SNMP_MANAGEDENTITY_TYPE_EQUIPMENT = 1;
    public static final int SNMP_MANAGEDENTITY_TYPE_SERVICE = 2;
    public static final int SNMP_MANAGEDENTITY_TYPE_SERVICEPROFILE = 3;
    public static final int SNMP_MANAGEDENTITY_TYPE_TASK = 4;
    private static String systemIPAddress = null;

    public static Event databaseAgingReport(DatabaseAgingGenericTask task, int threshold) {
        NmsSystem system = NmsSystemLocator.findNmsSystem();
        Event ret = new Event();
        ret.setEventCategory(EventCategory.SysEvent.byteValue());
        ret.setEventType(SysEventType.sysEvent.byteValue());
        ret.setEventSeverity(Severity.Other.byteValue());
        ret.setObjectSeverity((byte)127);
        ret.setProbableCause(Integer.MAX_VALUE);
        long timestamp = System.currentTimeMillis();
        ret.setReceiveTime(timestamp);
        ret.setEventTime(timestamp);
        ret.setLastUpdateTime(timestamp);
        ret.setProtocol(EventProtocol.snmp.byteValue());
        ret.setMoType(MOType.TASK.byteValue());
        ret.setMoInstance("DAP." + task.getTargetTable().name());
        ret.setManagedObject(MOType.TASK.name() + "." + ret.getMoInstance());
        ret.setMoAlias(ret.getManagedObject());
        ret.setEquipmentId(system.getId());
        ret.setEquipmentName(system.getName());
        ret.setEquipmentType(NEType.NMS.value());
        ret.setAckRequired(false);
        SNMPTrapV1AgentEvent snmpTrap = SystemEntityEvents.systemAgentEvent(20, task);
        snmpTrap.getVarBindList().add(new VarBind("dapTableName", OID_DAP_TABLE_NAME, -128, OctetString.fromDisplayString(task.getTargetTable().name())));
        snmpTrap.getVarBindList().add(new VarBind("dapThreshold", OID_DAP_THRESHOLD, 2, threshold));
        ret.setSourceIPAddress(snmpTrap.getAgentKey());
        ret.setEventOID(snmpTrap.getSnmpTrapOID());
        ret.setEventCause(snmpTrap);
        String trapName = NMSTrap.nmsDatabaseAgingReport.name();
        VarBindList vbList = snmpTrap.getVarBindList();
        String temp = TrapInternationalizer.translateEventTitle(trapName, vbList);
        ret.setEventName(EventUtil.truncateString(temp));
        temp = TrapInternationalizer.translateEventDescription(trapName, vbList);
        ret.setEventDescription(EventUtil.truncateString(temp));
        temp = TrapInternationalizer.translateEventAdvisor(trapName, vbList);
        ret.setEventAdvisor(EventUtil.truncateString(temp));
        return ret;
    }

    public static Event managedEntityCreated(ManagedEntity entity) {
        NmsSystem system = NmsSystemLocator.findNmsSystem();
        Event ret = new Event();
        ret.setEventCategory(EventCategory.ConfigChange.byteValue());
        ret.setEventType(ConfigChangeType.entityAdded.byteValue());
        ret.setEventSeverity(Severity.Other.byteValue());
        ret.setObjectSeverity((byte)127);
        ret.setProbableCause(Integer.MAX_VALUE);
        long timestamp = System.currentTimeMillis();
        ret.setReceiveTime(timestamp);
        ret.setEventTime(timestamp);
        ret.setLastUpdateTime(timestamp);
        ret.setProtocol(EventProtocol.snmp.byteValue());
        if (entity instanceof ManagedEntityBase) {
            ret.setManagedObject(((ManagedEntityBase)entity).getManagedObjectId());
            if (entity instanceof Equipment) {
                Equipment eq = (Equipment)entity;
                ret.setMoType((byte)eq.getMOType());
                ret.setMoInstance(eq.getMOInstance());
                ret.setMoAlias(eq.getName());
            }
        } else {
            ret.setManagedObject(entity.getName());
        }
        ret.setEquipmentId(system != null ? system.getId() : entity.getId());
        ret.setEquipmentName(system != null ? system.getName() : entity.getName());
        ret.setEquipmentType(NEType.NMS.value());
        ret.setAckRequired(false);
        SNMPTrapV1AgentEvent snmpTrap = SystemEntityEvents.systemAgentEvent(1, entity);
        ret.setSourceIPAddress(snmpTrap.getAgentKey());
        ret.setEventOID(snmpTrap.getSnmpTrapOID());
        ret.setEventCause(snmpTrap);
        String trapName = NMSTrap.nmsManagedEntityCreated.name();
        VarBindList vbList = snmpTrap.getVarBindList();
        String temp = TrapInternationalizer.translateEventTitle(trapName, vbList);
        ret.setEventName(EventUtil.truncateString(temp));
        temp = TrapInternationalizer.translateEventDescription(trapName, vbList);
        ret.setEventDescription(EventUtil.truncateString(temp));
        temp = TrapInternationalizer.translateEventAdvisor(trapName, vbList);
        ret.setEventAdvisor(EventUtil.truncateString(temp));
        ManagedEntityStateManager processor = (ManagedEntityStateManager)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms/EquipmentStateManager");
        processor.syncNow((Equipment)entity);
        return ret;
    }

    public static Event managedEntityRemoved(ManagedEntity entity) {
        NmsSystem system = NmsSystemLocator.findNmsSystem();
        Event ret = new Event();
        ret.setEventCategory(EventCategory.ConfigChange.byteValue());
        ret.setEventType(ConfigChangeType.entityRemoved.byteValue());
        ret.setEventSeverity(Severity.Other.byteValue());
        ret.setObjectSeverity((byte)127);
        ret.setProbableCause(Integer.MAX_VALUE);
        long timestamp = System.currentTimeMillis();
        ret.setReceiveTime(timestamp);
        ret.setEventTime(timestamp);
        ret.setLastUpdateTime(timestamp);
        ret.setProtocol(EventProtocol.snmp.byteValue());
        if (entity instanceof ManagedEntityBase) {
            ret.setManagedObject(((ManagedEntityBase)entity).getManagedObjectId());
            if (entity instanceof Equipment) {
                Equipment eq = (Equipment)entity;
                ret.setMoType((byte)eq.getMOType());
                ret.setMoInstance(eq.getMOInstance());
                ret.setMoAlias(eq.getName());
            }
        } else {
            ret.setManagedObject(entity.getName());
        }
        ret.setEquipmentId(system.getId());
        ret.setEquipmentName(system.getName());
        ret.setEquipmentType(NEType.NMS.value());
        ret.setAckRequired(false);
        SNMPTrapV1AgentEvent snmpTrap = SystemEntityEvents.systemAgentEvent(2, entity);
        ret.setSourceIPAddress(snmpTrap.getAgentKey());
        ret.setEventOID(snmpTrap.getSnmpTrapOID());
        ret.setEventCause(snmpTrap);
        String trapName = NMSTrap.nmsManagedEntityRemoved.name();
        VarBindList vbList = snmpTrap.getVarBindList();
        String temp = TrapInternationalizer.translateEventTitle(trapName, vbList);
        ret.setEventName(EventUtil.truncateString(temp));
        temp = TrapInternationalizer.translateEventDescription(trapName, vbList);
        ret.setEventDescription(EventUtil.truncateString(temp));
        temp = TrapInternationalizer.translateEventAdvisor(trapName, vbList);
        ret.setEventAdvisor(EventUtil.truncateString(temp));
        return ret;
    }

    public static Event equipmentUnreachable(Event generatedBy, Equipment equipment) {
        NmsSystem system = NmsSystemLocator.findNmsSystem();
        Event ret = new Event();
        ret.setEquipmentId(system.getId());
        ret.setEquipmentName(system.getName());
        ret.setEquipmentType(NEType.NMS.value());
        ret.setEventCategory(EventCategory.Alarm.byteValue());
        ret.setEventType(AlarmType.communicationsAlarm.byteValue());
        ret.setEventSeverity(Severity.Critical.byteValue());
        ret.setObjectSeverity((byte)127);
        ret.setProbableCause(Integer.MAX_VALUE);
        long timestamp = System.currentTimeMillis();
        ret.setReceiveTime(timestamp);
        ret.setEventTime(timestamp);
        ret.setLastUpdateTime(timestamp);
        ret.setProtocol(EventProtocol.snmp.byteValue());
        ret.setManagedObject(equipment.getManagedObjectId());
        ret.setMoType((byte)equipment.getMOType());
        ret.setMoInstance(equipment.getMOInstance());
        ret.setMoAlias(equipment.getName());
        ret.setAckRequired(false);
        SNMPTrapV1AgentEvent snmpTrap = SystemEntityEvents.systemAgentEvent(10, equipment);
        ret.setSourceIPAddress(snmpTrap.getAgentKey());
        ret.setEventOID(snmpTrap.getSnmpTrapOID());
        ret.setEventCause(snmpTrap);
        String trapName = NMSTrap.nmsEquipmentUnreachable.name();
        VarBindList vbList = snmpTrap.getVarBindList();
        String temp = TrapInternationalizer.translateEventTitle(trapName, vbList);
        ret.setEventName(EventUtil.truncateString(temp));
        temp = TrapInternationalizer.translateEventDescription(trapName, vbList);
        ret.setEventDescription(EventUtil.truncateString(temp));
        temp = TrapInternationalizer.translateEventAdvisor(trapName, vbList);
        ret.setEventAdvisor(EventUtil.truncateString(temp));
        return ret;
    }

    public static Event equipmentResetDetected(Event generatedBy, Equipment equipment, long internalSequenceNumber) {
        NmsSystem system = NmsSystemLocator.findNmsSystem();
        Event ret = new Event();
        ret.setEquipmentId(system.getId());
        ret.setEquipmentName(system.getName());
        ret.setEquipmentType(NEType.NMS.value());
        ret.setEventCategory(EventCategory.Alarm.byteValue());
        ret.setEventType(AlarmType.equipmentAlarm.byteValue());
        ret.setEventSeverity(Severity.Cleared.byteValue());
        ret.setObjectSeverity((byte)127);
        ret.setProbableCause(Integer.MAX_VALUE);
        long timestamp = System.currentTimeMillis();
        ret.setReceiveTime(timestamp);
        ret.setEventTime(timestamp);
        ret.setLastUpdateTime(timestamp);
        ret.setProtocol(EventProtocol.snmp.byteValue());
        ret.setManagedObject(equipment.getManagedObjectId());
        ret.setMoType((byte)equipment.getMOType());
        ret.setMoInstance(equipment.getMOInstance());
        ret.setMoAlias(equipment.getName());
        ret.setAckRequired(false);
        SNMPTrapV1AgentEvent snmpTrap = SystemEntityEvents.systemAgentEvent(13, equipment);
        snmpTrap.getVarBindList().add(new VarBind("internalSequenceNumber", OID_INTERNAL_SEQ_NO, 66, internalSequenceNumber));
        ret.setSourceIPAddress(snmpTrap.getAgentKey());
        ret.setEventOID(snmpTrap.getSnmpTrapOID());
        ret.setEventCause(snmpTrap);
        String trapName = NMSTrap.nmsEquipmentResetDetected.name();
        VarBindList vbList = snmpTrap.getVarBindList();
        String temp = TrapInternationalizer.translateEventTitle(trapName, vbList);
        ret.setEventName(EventUtil.truncateString(temp));
        temp = TrapInternationalizer.translateEventDescription(trapName, vbList);
        ret.setEventDescription(EventUtil.truncateString(temp));
        temp = TrapInternationalizer.translateEventAdvisor(trapName, vbList);
        ret.setEventAdvisor(EventUtil.truncateString(temp));
        return ret;
    }

    public static Event equipmentUp(Event generatedBy, Equipment equipment) {
        NmsSystem system = NmsSystemLocator.findNmsSystem();
        Event ret = new Event();
        ret.setEquipmentId(system.getId());
        ret.setEquipmentName(system.getName());
        ret.setEquipmentType(NEType.NMS.value());
        ret.setEventCategory(EventCategory.Alarm.byteValue());
        ret.setEventType(AlarmType.equipmentAlarm.byteValue());
        ret.setEventSeverity(Severity.Cleared.byteValue());
        ret.setObjectSeverity((byte)127);
        ret.setProbableCause(Integer.MAX_VALUE);
        long timestamp = System.currentTimeMillis();
        ret.setReceiveTime(timestamp);
        ret.setEventTime(timestamp);
        ret.setLastUpdateTime(timestamp);
        ret.setProtocol(EventProtocol.snmp.byteValue());
        ret.setManagedObject(equipment.getManagedObjectId());
        ret.setMoType((byte)equipment.getMOType());
        ret.setMoInstance(equipment.getMOInstance());
        ret.setMoAlias(equipment.getName());
        ret.setAckRequired(false);
        SNMPTrapV1AgentEvent snmpTrap = SystemEntityEvents.systemAgentEvent(11, equipment);
        ret.setSourceIPAddress(snmpTrap.getAgentKey());
        ret.setEventOID(snmpTrap.getSnmpTrapOID());
        ret.setEventCause(snmpTrap);
        String trapName = NMSTrap.nmsEquipmentUp.name();
        VarBindList vbList = snmpTrap.getVarBindList();
        String temp = TrapInternationalizer.translateEventTitle(trapName, vbList);
        ret.setEventName(EventUtil.truncateString(temp));
        temp = TrapInternationalizer.translateEventDescription(trapName, vbList);
        ret.setEventDescription(EventUtil.truncateString(temp));
        temp = TrapInternationalizer.translateEventAdvisor(trapName, vbList);
        ret.setEventAdvisor(EventUtil.truncateString(temp));
        return ret;
    }

    public static Event equipmentDown(Event generatedBy, Equipment equipment) {
        NmsSystem system = NmsSystemLocator.findNmsSystem();
        Event ret = new Event();
        ret.setEquipmentId(system.getId());
        ret.setEquipmentName(system.getName());
        ret.setEquipmentType(NEType.NMS.value());
        ret.setEventCategory(EventCategory.Alarm.byteValue());
        ret.setEventType(AlarmType.equipmentAlarm.byteValue());
        ret.setEventSeverity(Severity.Critical.byteValue());
        ret.setObjectSeverity((byte)127);
        ret.setProbableCause(Integer.MAX_VALUE);
        long timestamp = System.currentTimeMillis();
        ret.setReceiveTime(timestamp);
        ret.setEventTime(timestamp);
        ret.setLastUpdateTime(timestamp);
        ret.setProtocol(EventProtocol.snmp.byteValue());
        ret.setManagedObject(equipment.getManagedObjectId());
        ret.setMoType((byte)equipment.getMOType());
        ret.setMoInstance(equipment.getMOInstance());
        ret.setMoAlias(equipment.getName());
        ret.setAckRequired(false);
        SNMPTrapV1AgentEvent snmpTrap = SystemEntityEvents.systemAgentEvent(12, equipment);
        ret.setSourceIPAddress(snmpTrap.getAgentKey());
        ret.setEventOID(snmpTrap.getSnmpTrapOID());
        ret.setEventCause(snmpTrap);
        String trapName = NMSTrap.nmsEquipmentDown.name();
        VarBindList vbList = snmpTrap.getVarBindList();
        String temp = TrapInternationalizer.translateEventTitle(trapName, vbList);
        ret.setEventName(EventUtil.truncateString(temp));
        temp = TrapInternationalizer.translateEventDescription(trapName, vbList);
        ret.setEventDescription(EventUtil.truncateString(temp));
        temp = TrapInternationalizer.translateEventAdvisor(trapName, vbList);
        ret.setEventAdvisor(EventUtil.truncateString(temp));
        return ret;
    }

    public static Event equipmentCommOk(Event generatedBy, Equipment equipment) {
        NmsSystem system = NmsSystemLocator.findNmsSystem();
        Event ret = new Event();
        ret.setEquipmentId(system.getId());
        ret.setEquipmentName(system.getName());
        ret.setEventCategory(EventCategory.Alarm.byteValue());
        ret.setEventType(AlarmType.communicationsAlarm.byteValue());
        ret.setEventSeverity(Severity.Cleared.byteValue());
        long timestamp = System.currentTimeMillis();
        ret.setReceiveTime(timestamp);
        ret.setEventTime(timestamp);
        ret.setLastUpdateTime(timestamp);
        ret.setProtocol(EventProtocol.snmp.byteValue());
        ret.setManagedObject(equipment.getManagedObjectId());
        ret.setMoType((byte)equipment.getMOType());
        ret.setMoInstance(equipment.getMOInstance());
        ret.setMoAlias(equipment.getName());
        ret.setAckRequired(false);
        SNMPTrapV1AgentEvent snmpTrap = SystemEntityEvents.systemAgentEvent(15, equipment);
        ret.setSourceIPAddress(snmpTrap.getAgentKey());
        ret.setEventOID(snmpTrap.getSnmpTrapOID());
        ret.setEventCause(snmpTrap);
        String trapName = NMSTrap.nmsEquipmentCommOk.name();
        VarBindList vbList = snmpTrap.getVarBindList();
        String temp = TrapInternationalizer.translateEventTitle(trapName, vbList);
        ret.setEventName(EventUtil.truncateString(temp));
        temp = TrapInternationalizer.translateEventDescription(trapName, vbList);
        ret.setEventDescription(EventUtil.truncateString(temp));
        temp = TrapInternationalizer.translateEventAdvisor(trapName, vbList);
        ret.setEventAdvisor(EventUtil.truncateString(temp));
        return ret;
    }

    private static SNMPTrapV1AgentEvent systemAgentEvent(int entityEventClass, Serializable entity) {
        int specific = entityEventClass & 0xFFFFF;
        if (specific < 0) {
            log.error((Object)("Cannot created SNMP Trap for " + entityEventClass));
            return null;
        }
        SystemTrap trap = new SystemTrap();
        trap.setManagedEntityId(SystemEntityEvents.getEntityId(entity));
        trap.setManagedEntityName(SystemEntityEvents.getEntityName(entity));
        trap.setManagedEntityType(SystemEntityEvents.getEntityType(entity));
        SNMPTrapV1 trapV1 = new SNMPTrapV1(systemIPAddress == null ? (systemIPAddress = PlatformFactory.getApplicationLayerPlatform().getIPAddress()) : systemIPAddress, OID_BWANMS, 6, specific, (System.currentTimeMillis() - startupTime) / 10L, trap.toVarBindList(), System.currentTimeMillis());
        return new SNMPTrapV1AgentEvent(trapV1);
    }

    private static long getEntityId(Serializable entity) {
        if (entity instanceof Task) {
            return ((Task)entity).getId();
        }
        if (entity instanceof ManagedEntity) {
            return ((ManagedEntity)entity).getId();
        }
        throw new RuntimeException("Unknown type: " + entity.getClass());
    }

    private static String getEntityName(Serializable entity) {
        if (entity instanceof Task) {
            return ((Task)entity).getName();
        }
        if (entity instanceof ManagedEntity) {
            return ((ManagedEntity)entity).getName();
        }
        throw new RuntimeException("Unknown type: " + entity.getClass());
    }

    private static int getEntityType(Serializable entity) {
        if (entity instanceof NmsSystem) {
            return 0;
        }
        if (entity instanceof Equipment) {
            return 1;
        }
        if (entity instanceof Service) {
            return 2;
        }
        if (entity instanceof ServiceProfile) {
            return 3;
        }
        if (entity instanceof Task) {
            return 4;
        }
        throw new RuntimeException("Unknown type: " + entity.getClass());
    }

    public static class ManagedEntityCreatedRunnable
    implements Runnable {
        private ManagedEntity entity;
        private Event event;

        public ManagedEntityCreatedRunnable(Event event, ManagedEntity entity) {
            this.entity = entity;
            this.event = event;
        }

        public void run() {
        }
    }

    public static class SystemTrap {
        private Long managedEntityId;
        private String deviceEUID;
        private String deviceIpAddress;
        private String managedEntityName;
        private Integer managedEntityType;

        public String getDeviceEUID() {
            return this.deviceEUID;
        }

        public void setDeviceEUID(String deviceEUID) {
            this.deviceEUID = deviceEUID;
        }

        public String getDeviceIpAddress() {
            return this.deviceIpAddress;
        }

        public void setDeviceIpAddress(String deviceIpAddress) {
            this.deviceIpAddress = deviceIpAddress;
        }

        @SNMPParameter(OID="1.3.6.1.4.1.12394.1.260.3.1.1", type=66)
        public Long getManagedEntityId() {
            return this.managedEntityId;
        }

        public void setManagedEntityId(Long managedEntityId) {
            this.managedEntityId = managedEntityId;
        }

        @SNMPParameter(OID="1.3.6.1.4.1.12394.1.260.3.1.2", type=-128)
        public String getManagedEntityName() {
            return this.managedEntityName;
        }

        public void setManagedEntityName(String managedEntityName) {
            this.managedEntityName = managedEntityName;
        }

        @SNMPParameter(OID="1.3.6.1.4.1.12394.1.260.3.1.3", type=2)
        public Integer getManagedEntityType() {
            return this.managedEntityType;
        }

        public void setManagedEntityType(Integer managedEntityType) {
            this.managedEntityType = managedEntityType;
        }

        public VarBindList toVarBindList() {
            VarBindList vbList = new VarBindList();
            vbList.add(new VarBind("managedEntityId", SystemEntityEvents.OID_MANAGEDENTITY_ID, 66, this.getManagedEntityId()));
            vbList.add(new VarBind("managedEntityName", SystemEntityEvents.OID_MANAGEDENTITY_NAME, -128, OctetString.fromDisplayString(this.getManagedEntityName())));
            vbList.add(new VarBind("managedEntityType", SystemEntityEvents.OID_MANAGEDENTITY_TYPE, 2, this.getManagedEntityType()));
            return vbList;
        }
    }
}

