/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.domain.logic;

import com.bwanms.ddi.DDInterface;
import com.bwanms.ddi.DDRegistry;
import com.bwanms.fault.correlation.CorrelationRuleProvider;
import com.bwanms.mediation.snmp.SNMPTrapAgentEvent;
import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.model.Equipment;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.constants.NEType;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.persistence.Datastore;
import com.bwanms.protocols.snmp.VarBind;
import com.bwanms.protocols.snmp.VarBindList;
import com.bwanms.services.impl.EntityEventFilter;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class NMSCorrelationRuleProvider
implements CorrelationRuleProvider {
    private static final Logger log = Logger.getLogger(NMSCorrelationRuleProvider.class);

    public boolean accept(Event event) {
        return event.getEquipmentType() == NEType.NMS.value();
    }

    public EntityEventFilter getEntityEventFilter(Event event) {
        final Event clearingEvent = event;
        return new EntityEventFilter(){

            public boolean accept(Event candidate) {
                if (candidate.getReceiveTime() <= clearingEvent.getReceiveTime()) {
                    SNMPTrapAgentEvent candidateCause = (SNMPTrapAgentEvent)candidate.getEventCause();
                    SNMPTrapV1AgentEvent clearingCause = (SNMPTrapV1AgentEvent)clearingEvent.getEventCause();
                    if (candidateCause != null && clearingCause != null) {
                        int clearingTrap = clearingCause.getSpecific();
                        switch (clearingTrap) {
                            case 11: {
                                int candidateTrap = ((SNMPTrapV1AgentEvent)candidateCause).getSpecific();
                                if (!candidate.getManagedObject().equals(clearingEvent.getManagedObject()) || candidateTrap != 10 && candidateTrap != 12) break;
                                return true;
                            }
                            case 13: {
                                Long entityId;
                                VarBind varBind;
                                if (candidate.getEquipmentType() == NEType.NMS.value()) {
                                    return false;
                                }
                                VarBindList varBinds = clearingCause.getVarBindList();
                                if (varBinds != null && varBinds != null && (varBind = varBinds.findVarBindByOID("1.3.6.1.4.1.12394.1.260.3.1.1")) != null && (entityId = (Long)varBind.getVariable()) != null) {
                                    try {
                                        Equipment equipment = new CallableDatastoreDecorator<Equipment>(new Callable<Equipment>(){

                                            @Override
                                            public Equipment call() throws Exception {
                                                return (Equipment)Datastore.session().get(Equipment.class, (Serializable)entityId);
                                            }
                                        }).call();
                                        if (equipment != null) {
                                            DDInterface ddi = DDRegistry.getInstance().getDDInterfaceByEquipmentClass(equipment.getClass().getName());
                                            EntityEventFilter ddFilter = ddi.getNMSEquipmentResetDetectedFilter(clearingEvent);
                                            return ddFilter != null && ddFilter.accept(candidate);
                                        }
                                    }
                                    catch (Exception e) {
                                        log.warn((Object)("Failed to correlate alarm : " + candidate.getEventOID()), (Throwable)e);
                                    }
                                }
                                return false;
                            }
                            case 15: {
                                int candidateTrap = ((SNMPTrapV1AgentEvent)candidateCause).getSpecific();
                                if (candidateTrap != 14) break;
                                return false;
                            }
                        }
                    }
                }
                return false;
            }
        };
    }
}

