/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.domain.logic;

import com.bwanms.model.NetworkIpAddressRange;
import com.bwanms.model.NetworkSNMPCommunity;
import com.bwanms.persistence.Datastore;
import com.bwanms.util.IpAddress;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedNetworkHelper {
    private ManagedNetworkHelper() {
    }

    public static List<NetworkIpAddressRange> getRangesForDiscovery() {
        return Datastore.session().createQuery("from " + NetworkIpAddressRange.class.getName() + " where enableDiscovery = :discovery").setBoolean("discovery", true).list();
    }

    public static NetworkIpAddressRange getRangeForIp(IpAddress address) {
        List ranges = Datastore.session().createQuery("from " + NetworkIpAddressRange.class.getName()).list();
        for (NetworkIpAddressRange range : ranges) {
            if (!range.toIpAddressRange().contains(address)) continue;
            return range;
        }
        return null;
    }

    public static List<NetworkSNMPCommunity> getCommunities() {
        return Datastore.session().createQuery("from " + NetworkSNMPCommunity.class.getName()).list();
    }
}

