/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.domain.logic;

import com.bwanms.domain.logic.LicenseSPI;
import com.bwanms.model.Equipment;
import com.bwanms.model.license.Licensable;
import com.bwanms.model.license.License;
import com.bwanms.model.license.LicenseFeature;
import com.bwanms.model.license.LicenseFeatureUsable;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.PrivateSessionManager;
import com.bwanms.services.InvalidLicenseFileException;
import com.bwanms.services.LicenseAlreadyImportedException;
import com.bwanms.util.PlatformConfiguration;
import com.licensing.verification.decryptapi.LicenseSPIImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseHelper {
    private static final Logger log = Logger.getLogger(LicenseHelper.class);
    private static LicenseSPI spi = new LicenseSPIImpl();
    private static final int BATCH_SIZE = 400;
    private static Long activeLicenseId = Licensable.UNLICENSED;
    private static ArrayList<String> activeLicenseFeature = new ArrayList();

    public static License importLicense(byte[] licenseBytes) throws InvalidLicenseFileException, LicenseAlreadyImportedException {
        List<License> licenseList = LicenseHelper.getLicenses();
        License importedLicense = null;
        for (License license : licenseList) {
            if (!license.compareLicenseBytes(licenseBytes)) continue;
            importedLicense = license;
            break;
        }
        boolean isNew = false;
        boolean hasNewFeatures = false;
        Session session = Datastore.session();
        try {
            License license = spi.parseLicense(licenseBytes);
            if (importedLicense == null) {
                importedLicense = license;
                importedLicense.setLicenseBytes(licenseBytes);
                importedLicense.computeCheckSum();
                if (licenseList.isEmpty()) {
                    importedLicense.setActive(true);
                }
                isNew = true;
            } else {
                importedLicense.checkLicense();
                if (importedLicense.isValid()) {
                    Map<String, LicenseFeature> features = importedLicense.getLicenseFeaturesMap();
                    for (LicenseFeature newFeature : license.getLicenseFeatures()) {
                        if (features.containsKey(newFeature.getName())) continue;
                        importedLicense.addLicenseFeature(newFeature);
                        hasNewFeatures = true;
                    }
                    if (hasNewFeatures) {
                        session.saveOrUpdate((Object)importedLicense);
                        session.flush();
                        importedLicense.computeCheckSum();
                    }
                } else {
                    log.warn((Object)"Invalidated hacked license");
                }
            }
        }
        catch (Exception e) {
            throw new InvalidLicenseFileException(e);
        }
        finally {
            System.gc();
        }
        if (!isNew && !hasNewFeatures) {
            throw new LicenseAlreadyImportedException();
        }
        session.saveOrUpdate((Object)importedLicense);
        return importedLicense;
    }

    public static boolean licenseEntity(Licensable entity) {
        return LicenseHelper.licenseEntity(entity, entity.getClass().getName());
    }

    public static void licenseEntities(List<Licensable> entities, String featureName) {
        ArrayList<Licensable> unlicensed = new ArrayList<Licensable>();
        ArrayList<Licensable> licensed = new ArrayList<Licensable>();
        for (Licensable entity : entities) {
            if (LicenseHelper.isLicensed(entity)) continue;
            unlicensed.add(entity);
        }
        if (!unlicensed.isEmpty()) {
            for (License license : LicenseHelper.getLicenses()) {
                if (!license.isValid() || !license.isActive()) continue;
                LicenseFeatureUsable usableFeature = (LicenseFeatureUsable)license.getLicenseFeaturesMap().get(featureName);
                int usageCount = usableFeature.getUsageCount();
                Datastore.session().refresh((Object)usableFeature);
                if (usageCount != usableFeature.getUsageCount()) {
                    log.error((Object)"Asynchronous access to license caused a general protection fault!");
                }
                if (usableFeature == null) continue;
                while (!unlicensed.isEmpty() && usableFeature.incrementUsageCount()) {
                    Licensable entity = (Licensable)unlicensed.remove(0);
                    entity.setLicenseID(license.getId());
                    licensed.add(entity);
                }
                license.computeCheckSum();
                Datastore.session().saveOrUpdate((Object)license);
            }
        }
        log.debug((Object)("Licensed[ " + licensed.size() + "," + unlicensed.size() + "," + entities.size() + "]"));
    }

    private static boolean licenseEntity(Licensable entity, String featureName) {
        if (LicenseHelper.isLicensed(entity)) {
            return true;
        }
        for (License license : LicenseHelper.getLicenses()) {
            LicenseFeatureUsable usableFeature;
            if (!license.isValid() || !license.isActive() || (usableFeature = (LicenseFeatureUsable)license.getLicenseFeaturesMap().get(featureName)) == null || !usableFeature.incrementUsageCount()) continue;
            entity.setLicenseID(license.getId());
            license.computeCheckSum();
            Datastore.session().saveOrUpdate((Object)license);
            return true;
        }
        return false;
    }

    public static void unlicenseEntity(Licensable entity) {
        LicenseHelper.unlicenseEntity(entity, entity.getClass().getName());
    }

    private static void unlicenseEntity(Licensable entity, String featureName) {
        License license;
        if (entity.getLicenseID() != null && (license = (License)Datastore.session().get(License.class, (Serializable)new Long(entity.getLicenseID()), LockMode.UPGRADE)) != null) {
            LicenseFeatureUsable usableFeature = (LicenseFeatureUsable)license.getLicenseFeaturesMap().get(featureName);
            usableFeature.decrementUsageCount();
            license.computeCheckSum();
            Datastore.session().saveOrUpdate((Object)license);
            entity.setLicenseID(Licensable.UNLICENSED);
        }
    }

    public static List<License> getLicenses() {
        return LicenseHelper.getLicenses(Datastore.session());
    }

    public static List<License> getLicenses(Session session) {
        return session.createQuery("from " + License.class.getName() + " l ").setLockMode("l", LockMode.UPGRADE).list();
    }

    public static LicenseFeatureUsable createLicenseFeatureUsable(String featureName) {
        try {
            LicenseFeatureUsable ret = (LicenseFeatureUsable)Class.forName("com.bwanms.license.features." + featureName).newInstance();
            return ret;
        }
        catch (Exception e) {
            log.debug((Object)("Specific feature not found, using default: " + featureName));
            try {
                Class.forName(featureName);
                LicenseFeatureUsable ret = new LicenseFeatureUsable();
                ret.setName(featureName);
                return ret;
            }
            catch (Exception e2) {
                log.debug((Object)("Feature not found: " + featureName));
                return null;
            }
        }
    }

    public static boolean isLicensed(Object entity) {
        if (entity instanceof Licensable) {
            return LicenseHelper.isLicensed((Licensable)entity);
        }
        return true;
    }

    private static boolean isLicensed(Licensable entity) {
        if (PlatformConfiguration.isLocalPlatform()) {
            return true;
        }
        if (Licensable.UNLICENSED.equals(activeLicenseId)) {
            LicenseHelper.retrieveActiveLicense();
        }
        return activeLicenseId.equals(entity.getLicenseID());
    }

    public static boolean isFeatureLicensed(String name) {
        if (PlatformConfiguration.isLocalPlatform()) {
            return true;
        }
        if (Licensable.UNLICENSED.equals(activeLicenseId)) {
            LicenseHelper.retrieveActiveLicense();
        }
        for (String lcsFeature : activeLicenseFeature) {
            if (!lcsFeature.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void retrieveActiveLicense() {
        Serializable serializable = activeLicenseId;
        synchronized (serializable) {
            activeLicenseId = ((License)Datastore.session().createQuery("from " + License.class.getName() + " l where l.active = true ").uniqueResult()).getId();
        }
        serializable = activeLicenseFeature;
        synchronized (serializable) {
            activeLicenseFeature.clear();
            List licenseFeatures = Datastore.session().createQuery("from " + LicenseFeature.class.getName() + " l where l.license.active = true ").list();
            for (LicenseFeature licenseFeature : licenseFeatures) {
                activeLicenseFeature.add(licenseFeature.getName());
            }
        }
    }

    public static Long getActiveLicense() {
        if (Licensable.UNLICENSED.equals(activeLicenseId)) {
            LicenseHelper.retrieveActiveLicense();
        }
        return activeLicenseId;
    }

    public static ArrayList<String> getActiveLicenseFeature() {
        if (Licensable.UNLICENSED.equals(activeLicenseId)) {
            LicenseHelper.retrieveActiveLicense();
        }
        return activeLicenseFeature;
    }

    public static void resetLicenseFeaturesWithLicenseId(Session session, long licenseId) throws Exception {
        long start = System.currentTimeMillis();
        if (session == null || !session.isOpen()) {
            session = PrivateSessionManager.privateSession();
        }
        session.beginTransaction();
        License license = (License)session.get(License.class, (Serializable)Long.valueOf(licenseId), LockMode.UPGRADE);
        if (license != null) {
            Map<String, LicenseFeature> mapUsableFeature = license.getLicenseFeaturesMap();
            for (String featureName : mapUsableFeature.keySet()) {
                LicenseFeature licenseFeature = license.getLicenseFeaturesMap().get(featureName);
                if (!(licenseFeature instanceof LicenseFeatureUsable)) continue;
                ((LicenseFeatureUsable)licenseFeature).setUsageCount(0);
            }
            license.computeCheckSum();
            session.saveOrUpdate((Object)license);
            try {
                PrivateSessionManager.commit(session);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        long finish = System.currentTimeMillis();
        log.debug((Object)("time (milliseconds) " + (finish - start)));
    }

    public static void licenseAllNotLicensedEquipments(Session session, long licenseId) throws Exception {
        long start = System.currentTimeMillis();
        if (session == null || !session.isOpen()) {
            session = PrivateSessionManager.privateSession();
        }
        session.beginTransaction();
        License license = (License)session.createQuery("from " + License.class.getName() + " lic where lic.id =:licenseId").setLockMode("lic", LockMode.UPGRADE).setLong("licenseId", licenseId).uniqueResult();
        for (LicenseFeature licenseFeature : license.getLicenseFeatures()) {
            if (!(licenseFeature instanceof LicenseFeatureUsable)) continue;
            Integer count = (Integer)Datastore.session().createQuery("select count(*) from " + licenseFeature.getName() + " where licenseID = " + licenseId).uniqueResult();
            if (((LicenseFeatureUsable)licenseFeature).getQuantity() < count) {
                log.error((Object)"big problem; should not have happened");
                continue;
            }
            ((LicenseFeatureUsable)licenseFeature).setUsageCount(count);
        }
        try {
            license.computeCheckSum();
            session.saveOrUpdate((Object)license);
            PrivateSessionManager.commit(session);
            session.clear();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        Iterator<String> iter = LicenseHelper.getLicensiableClassNameSet(session).iterator();
        int i = 0;
        while (iter.hasNext()) {
            String equipmentClassName = iter.next();
            log.debug((Object)("get equipment for " + equipmentClassName));
            int size = 0;
            do {
                session.beginTransaction();
                List equipments = session.createQuery("from " + equipmentClassName + " eq where eq.licenseID != :licenseid").setLong("licenseid", licenseId).setMaxResults(400).list();
                size = equipments.size();
                if (size > 0 && (license = (License)session.createQuery("from " + License.class.getName() + " lic where lic.id =:licenseId").setLockMode("lic", LockMode.UPGRADE).setLong("licenseId", licenseId).uniqueResult()).isValid() && license.isActive()) {
                    for (int j = 0; j < size; ++j) {
                        Licensable entity = (Licensable)equipments.get(j);
                        String featureName = entity.getClass().getName();
                        LicenseFeatureUsable usableFeature = (LicenseFeatureUsable)license.getLicenseFeaturesMap().get(featureName);
                        if (usableFeature == null) continue;
                        if (usableFeature.incrementUsageCount()) {
                            entity.setLicenseID(license.getId());
                            continue;
                        }
                        size = -1;
                        break;
                    }
                }
                license.computeCheckSum();
                try {
                    PrivateSessionManager.commit(session);
                    session.clear();
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
            } while (size == 400);
            ++i;
        }
        long finish = System.currentTimeMillis();
        log.debug((Object)("time (milliseconds) " + (finish - start)));
    }

    private static void executeUpdate(Collection collection, Query query, String parameterName) {
        query.setParameterList(parameterName, collection).executeUpdate();
        collection.clear();
    }

    private static List<Equipment> getEquipmetsLicensedWithLicense(long licenseId, String equipmentClassName) {
        return Datastore.session().createQuery("from " + equipmentClassName + " where licenseID = " + licenseId).list();
    }

    private static Set<String> getLicensiableClassNameSet(Session session) {
        HashSet<String> classNameSet = new HashSet<String>();
        List featureList = session.createQuery("from " + LicenseFeature.class.getName() + " where NOT quantity = NULL").list();
        for (LicenseFeature lf : featureList) {
            classNameSet.add(lf.getName());
        }
        return classNameSet;
    }

    public static void licenseCheck() {
        for (License license : LicenseHelper.getLicenses()) {
            license.checkLicense();
            Datastore.session().saveOrUpdate((Object)license);
        }
    }
}

