/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.domain.logic;

import com.bwanms.model.license.Licensable;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.LicenseManagerService;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.PlatformConfiguration;
import java.util.ArrayList;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;

public class LicenseClient {
    private static final Logger log = Logger.getLogger(LicenseClient.class);
    private static Long activeLicenseId = Licensable.UNLICENSED;
    private static ArrayList<String> activeLicenseFeature;
    private static LicenseClient instance;

    private LicenseClient() {
        this.registerListener();
        LicenseManagerService licSvc = ServiceRegistry.getLicenseManagerService();
        try {
            activeLicenseId = licSvc.getActiveLicense();
            activeLicenseFeature = licSvc.getActiveLicenseFeature();
        }
        catch (ServiceException e) {
            log.error((Object)"error: ", (Throwable)e);
        }
    }

    public static LicenseClient getInstance() {
        if (instance == null) {
            instance = new LicenseClient();
        }
        return instance;
    }

    public boolean isLicensed(Object entity) {
        if (entity instanceof Licensable) {
            return this.isLicensed((Licensable)entity);
        }
        return true;
    }

    public boolean isFeatureLicensed(String name) {
        if (PlatformConfiguration.isLocalPlatform()) {
            return true;
        }
        for (String lcsFeature : activeLicenseFeature) {
            if (!lcsFeature.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isLicensed(Licensable entity) {
        if (PlatformConfiguration.isLocalPlatform()) {
            return true;
        }
        return activeLicenseId.equals(entity.getLicenseID());
    }

    public void registerListener() {
        PlatformFactory.getApplicationLayerPlatform().getMessaging().addTopicListener("topic/ActiveLicenseID", new MessageListener(){

            public void onMessage(Message msg) {
                try {
                    activeLicenseId = (Long)((ObjectMessage)msg).getObject();
                }
                catch (JMSException e) {
                    log.error((Object)"error: ", (Throwable)e);
                }
            }
        });
        PlatformFactory.getApplicationLayerPlatform().getMessaging().addTopicListener("topic/ActiveLicenseFeature", new MessageListener(){

            public void onMessage(Message msg) {
                try {
                    activeLicenseFeature = (ArrayList)((ObjectMessage)msg).getObject();
                }
                catch (JMSException e) {
                    log.error((Object)"error: ", (Throwable)e);
                }
            }
        });
    }

    public Long getActiveLicenseId() {
        return activeLicenseId;
    }
}

