/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.domain.logic;

import com.bwanms.ddi.ConfigurationChangedEvent;
import com.bwanms.ddi.DDCallbackInterface;
import com.bwanms.domain.logic.SystemEntityEvents;
import com.bwanms.domain.logic.TopologyServiceHelper;
import com.bwanms.model.Equipment;
import com.bwanms.model.Service;
import com.bwanms.model.ServiceProfile;
import com.bwanms.model.fault.Event;
import com.bwanms.persistence.Datastore;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.impl.EquipmentCommunicationHandlerImpl;
import com.bwanms.util.DatastoreOperationUtil;
import org.apache.log4j.Logger;

public class DDCallbackImpl
implements DDCallbackInterface {
    private static final Logger logger = Logger.getLogger(DDCallbackImpl.class);

    public Event equipmentCreate(Event generatedBy, Equipment equipment) {
        Event event = SystemEntityEvents.managedEntityCreated(equipment);
        return event;
    }

    public Event equipmentRemove(Event generatedBy, Equipment equipment) {
        Event event = SystemEntityEvents.managedEntityRemoved(equipment);
        TopologyServiceHelper.topologyChanged(equipment.getLocation());
        return event;
    }

    public Event equipmentResetDetected(Event generatedBy, Equipment equipment, long internalSequenceNumber) {
        Event event = SystemEntityEvents.equipmentResetDetected(generatedBy, equipment, internalSequenceNumber);
        return event;
    }

    public Event setEquipmentState(Event generatedBy, Equipment equipment, int state) {
        logger.debug((Object)("STATE[" + equipment.getEUID() + "]=" + equipment.getState() + "->" + state));
        if (equipment.getState() == state) {
            return null;
        }
        equipment.setState(state);
        Event entityEvent = null;
        switch (state) {
            case 0: {
                entityEvent = SystemEntityEvents.equipmentUp(generatedBy, equipment);
                break;
            }
            case -1: {
                entityEvent = SystemEntityEvents.equipmentUnreachable(generatedBy, equipment);
                break;
            }
            case 1: {
                entityEvent = SystemEntityEvents.equipmentDown(generatedBy, equipment);
                break;
            }
            default: {
                throw new RuntimeException("Implement me!");
            }
        }
        TopologyServiceHelper.topologyChanged(equipment);
        return entityEvent;
    }

    public void configurationChanged(ConfigurationChangedEvent changes) {
        logger.debug((Object)("configurationChanged: " + changes.getEquipmentId()));
        Datastore.addOperationAfterTransaction(DatastoreOperationUtil.sendMessageOperation("queue/ConfigurationChangedTopic", changes));
    }

    public void communicationError(Equipment equipment) {
        logger.debug((Object)(" Communication ERROR: " + equipment.getId()));
        PlatformFactory.getApplicationLayerPlatform().getMessaging().send("queue/EquipmentStateComm", new EquipmentCommunicationHandlerImpl.EquipmentCommunicationEvent(equipment.getId(), 1));
    }

    public void communicationOK(Equipment equipment) {
        if (equipment.getState() == -3 || equipment.getState() == -1) {
            Datastore.addOperationAfterTransaction(DatastoreOperationUtil.sendMessageOperation("queue/EquipmentStateComm", new EquipmentCommunicationHandlerImpl.EquipmentCommunicationEvent(equipment.getId(), 0)));
        }
    }

    public Event serviceCreate(Event generatedBy, Service service) {
        Event event = SystemEntityEvents.managedEntityCreated(service);
        return event;
    }

    public Event serviceRemove(Event generatedBy, Service service) {
        Event event = SystemEntityEvents.managedEntityRemoved(service);
        return event;
    }

    public Event setServiceState(Event generatedBy, Service service, int state) {
        logger.debug((Object)("STATE[" + service.getName() + ":" + service.getSubscriberUnitEUID() + "]=" + service.getState() + "->" + state));
        if (service.getState() == state) {
            return null;
        }
        service.setState(state);
        return null;
    }

    public Event serviceProfileCreate(Event generatedBy, ServiceProfile service) {
        logger.debug((Object)"serviceCreate - implement me!");
        return null;
    }

    public Event serviceProfileRemove(Event generatedBy, ServiceProfile service) {
        logger.debug((Object)"serviceProfileRemove - implement me!");
        return null;
    }

    public Event setServiceProfileState(Event generatedBy, ServiceProfile service, int state) {
        logger.debug((Object)"setServiceProfileState - implement me!");
        return null;
    }
}

