/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.domain.logic;

import com.bwanms.ddi.DDInterface;
import com.bwanms.ddi.DDRegistry;
import com.bwanms.gui.configuration.EquipmentManagerNotFoundException;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.mo.DataObjectTable;
import com.bwanms.mo.EquipmentConfiguration;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.NetworkDomainObject;
import com.bwanms.mo.NetworkDomainObjectAccessHandler;
import com.bwanms.mo.NetworkDomainObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.model.Equipment;
import com.bwanms.model.Manageable;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.persistence.Datastore;
import com.bwanms.protocols.Protocol;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurationHelper {
    private static final Logger logger = Logger.getLogger(ConfigurationHelper.class);

    @Deprecated
    public abstract List<ManagedObject> retrieveCurrentConfiguration(long var1, String var3, Class<? extends ManagedObject> var4, boolean var5) throws MediationException;

    public abstract <T extends ManagedObject> List<T> retrieveCurrentConfiguration(long var1, String var3, Class<T> var4, String var5, boolean var6) throws MediationException;

    public abstract <T extends ManagedObject> List<T> retrieveCurrentConfiguration(MOAccessSession var1, NetworkResourceConfiguration var2, Class<T> var3, String var4, boolean var5) throws MediationException;

    @Deprecated
    public abstract List<ManagedObject> retrieveCurrentConfiguration(long var1, String var3, List<Class<? extends ManagedObject>> var4, boolean var5) throws MediationException;

    public abstract List<ManagedObject> retrieveCurrentConfiguration(Equipment var1, MOAccessSession var2, String var3, List<Class<? extends ManagedObject>> var4, boolean var5) throws MediationException;

    @Deprecated
    public abstract void updateCurrentConfiguration(long var1, ManagedObject var3) throws MediationException;

    public abstract <M extends ManagedObject> List<M> updateCurrentConfiguration(Equipment var1, String var2, Class<M> var3, String var4, List<M> var5) throws MediationException;

    @Deprecated
    public abstract <M extends ManagedObject> List<M> updateCurrentConfiguration(long var1, String var3, Class<M> var4, String var5, List<M> var6) throws MediationException;

    public abstract <M extends ManagedObject> List<M> updateCurrentConfiguration(MOAccessSession var1, NetworkResourceConfiguration var2, Class<M> var3, String var4, List<M> var5) throws MediationException;

    public abstract void updateCurrentConfiguration(long var1, List<ManagedObject> var3) throws MediationException;

    public abstract void removeFromCurrentConfiguration(NetworkResourceConfiguration var1, Class<? extends ManagedObject> var2, String var3);

    public <N extends NetworkDomainObject> List<N> retrieveData(long equipmentId, String networkResource, Class<N> ndoClass, String instanceQuery) throws MediationException {
        Equipment eq = this.findEquipment(equipmentId);
        return this.retrieveData(eq, networkResource, ndoClass, instanceQuery);
    }

    public <N extends NetworkDomainObject> List<N> retrieveData(Equipment eq, String networkResource, Class<N> ndoClass, String instanceQuery) throws MediationException {
        MOAccessSession access = null;
        try {
            access = this.getMOAccessSession(eq);
            Class.forName(ndoClass.getName());
            if (DataObjectTable.class.isAssignableFrom(ndoClass)) {
                DataObjectTable dot = (DataObjectTable)ndoClass.newInstance();
                Class entryClass = dot.getParameterClass();
                Class.forName(entryClass.getName());
                NetworkDomainObjectAccessHandler ndoAccessHandler = NetworkDomainObjectAccessHandlerRegistry.findHandler(entryClass, access.getProtocol());
                List ndos = ndoAccessHandler.fetch(eq, access, networkResource, "*");
                dot.setEntries(ndos);
                ArrayList<DataObjectTable> ret = new ArrayList<DataObjectTable>();
                ret.add(dot);
                ArrayList<DataObjectTable> arrayList = ret;
                return arrayList;
            }
            NetworkDomainObjectAccessHandler<N> ndoAccessHandler = NetworkDomainObjectAccessHandlerRegistry.findHandler(ndoClass, access.getProtocol());
            List<N> list = ndoAccessHandler.fetch(eq, access, networkResource, instanceQuery);
            return list;
        }
        catch (EquipmentManagerNotFoundException emnfe) {
            throw emnfe;
        }
        catch (MediationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.disposeMOAccessSession(access);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Object> retrieveData(long equipmentId, List<Class> dataClasses) throws MediationException {
        ArrayList<Object> arrayList;
        MOAccessSession access = null;
        try {
            Equipment eq = this.findEquipment(equipmentId);
            access = this.getMOAccessSession(eq);
            ArrayList<Object> ret = new ArrayList<Object>();
            for (Class dataClass : dataClasses) {
                if (NetworkDomainObject.class.isAssignableFrom(dataClass)) {
                    if (DataObjectTable.class.isAssignableFrom(dataClass)) {
                        DataObjectTable dot = (DataObjectTable)dataClass.newInstance();
                        Class ndoClass = dot.getParameterClass();
                        Class.forName(ndoClass.getName());
                        NetworkDomainObjectAccessHandler ndoAccessHandler = NetworkDomainObjectAccessHandlerRegistry.findHandler(ndoClass, access.getProtocol());
                        List ndos = ndoAccessHandler.fetch(eq, access, null, "*");
                        dot.setEntries(ndos);
                        ret.add(dot);
                        continue;
                    }
                    Class.forName(dataClass.getName());
                    NetworkDomainObjectAccessHandler ndoAccessHandler = NetworkDomainObjectAccessHandlerRegistry.findHandler(dataClass, access.getProtocol());
                    ret.addAll(ndoAccessHandler.fetch(eq, access, null, "*"));
                    continue;
                }
                ret.addAll(access.fetchObject(null, dataClass, AttributeFilterUtil.getMatchedAttributes(eq, dataClass), "*"));
            }
            logger.debug((Object)("Return size: " + ret.size()));
            arrayList = ret;
        }
        catch (EquipmentManagerNotFoundException emnfe) {
            try {
                throw emnfe;
                catch (MediationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                this.disposeMOAccessSession(access);
                throw throwable;
            }
        }
        this.disposeMOAccessSession(access);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(long equipmentId, List<Object> data) throws MediationException {
        MOAccessSession access = null;
        try {
            Equipment eq = this.findEquipment(equipmentId);
            access = this.getMOAccessSession(eq);
            Class<? extends Protocol> protocol = access.getProtocol();
            for (Object dataPart : data) {
                if (dataPart instanceof NetworkDomainObject) {
                    if (dataPart instanceof DataObjectTable) {
                        DataObjectTable dot = (DataObjectTable)dataPart;
                        Class ndoClass = dot.getParameterClass();
                        NetworkDomainObjectAccessHandler ndoAccessHandler = NetworkDomainObjectAccessHandlerRegistry.findHandler(ndoClass, protocol);
                        for (Object ndoObject : dot.getEntries()) {
                            ndoAccessHandler.update(eq, access, null, (NetworkDomainObject)ndoObject);
                        }
                        continue;
                    }
                    NetworkDomainObject ndo = (NetworkDomainObject)dataPart;
                    NetworkDomainObjectAccessHandler<?> ndoAccessHandler = NetworkDomainObjectAccessHandlerRegistry.findHandler(ndo.getClass(), protocol);
                    ndoAccessHandler.update(eq, access, null, ndo);
                    continue;
                }
                access.commitObject(null, dataPart, AttributeFilterUtil.getMatchedAttributes(eq, dataPart.getClass()));
            }
            this.disposeMOAccessSession(access);
        }
        catch (Throwable throwable) {
            this.disposeMOAccessSession(access);
            throw throwable;
        }
    }

    public Equipment findEquipment(long equipmentId) {
        return (Equipment)Datastore.session().get(Equipment.class, (Serializable)Long.valueOf(equipmentId));
    }

    protected MOAccessSession getMOAccessSession(Equipment e, EquipmentConfiguration configuration) throws MediationException {
        SNMPManagementInterface mi = null;
        if (e instanceof Manageable) {
            mi = (SNMPManagementInterface)((Manageable)((Object)e)).getManagementInterface();
        }
        if (mi == null) {
            throw new RuntimeException("SNMPManagementInterface not found for equipment: " + e.getEUID());
        }
        MOAccessSession ms = MediationServiceRegistry.getMOSession(mi, configuration.getNetworkResourceHandler(mi.getClass()));
        return ms;
    }

    protected MOAccessSession getMOAccessSession(Equipment e) throws MediationException {
        SNMPManagementInterface mi = null;
        if (e instanceof Manageable) {
            mi = (SNMPManagementInterface)((Manageable)((Object)e)).getManagementInterface();
        }
        if (mi == null) {
            throw new RuntimeException("SNMPManagementInterface not found for equipment: " + e.getEUID());
        }
        MOAccessSession ms = MediationServiceRegistry.getMOSession(mi, null);
        return ms;
    }

    protected void disposeMOAccessSession(MOAccessSession access) {
        if (access == null) {
            return;
        }
        try {
            access.close();
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
        }
    }

    public abstract void processConfigurationChanges(NetworkResourceConfiguration var1, Class<? extends ManagedObject> var2, Collection<String> var3);

    public void reprocessConfiguration(Equipment eq) {
        DDInterface ddi = DDRegistry.getInstance().getDDInterfaceByEquipmentClass(eq.getClass().getName());
        List<Class<? extends ManagedObject>> asyncMoClasses = ddi.getMOClassesForAsyncChangeProcessing();
        for (NetworkResourceConfiguration nrConfig : eq.findCurrentConfiguration().getNetworkResources().values()) {
            List<Class<? extends ManagedObject>> moClasses = nrConfig.getManagedObjectClasses();
            moClasses.retainAll(asyncMoClasses);
            if (moClasses.isEmpty()) continue;
            for (Class<? extends ManagedObject> moClass : moClasses) {
                List<? extends ManagedObject> mos = nrConfig.retrieveManagedObjects(moClass, "*");
                ArrayList<String> instances = new ArrayList<String>(mos.size());
                for (ManagedObject managedObject : mos) {
                    instances.add(managedObject.getRowKey());
                }
                this.processConfigurationChanges(nrConfig, moClass, instances);
            }
        }
    }
}

