/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.domain.logic;

import com.bwanms.model.AuditLogEntry;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.PrivateSessionHelper;
import com.bwanms.security.Security;
import java.util.Date;

public class AuditLogHelper {
    public static void addAuditLogEntryInCurrentSession(String action, String category, String targetEntity, String entityType) {
        AuditLogHelper.addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), action, category, targetEntity, entityType);
    }

    public static void addAuditLogEntryInCurrentSession(String userId, String action, String category, String targetEntity, String entityType) {
        AuditLogEntry auditLogEntry = AuditLogHelper.createAuditLogEntry(userId, action, category, targetEntity, entityType);
        Datastore.session().save((Object)auditLogEntry);
    }

    public static void addAuditLogEntryInNewSession(String action, String category, String targetEntity, String entityType) {
        AuditLogHelper.addAuditLogEntryInNewSession(Security.getSecurity().getCurrentUserId(), action, category, targetEntity, entityType);
    }

    public static void addAuditLogEntryInNewSession(String userId, String action, String category, String targetEntity, String entityType) {
        AuditLogEntry logEntry = AuditLogHelper.createAuditLogEntry(userId, action, category, targetEntity, entityType);
        PrivateSessionHelper.persistAndCommit((Object)logEntry);
    }

    private static AuditLogEntry createAuditLogEntry(String userId, String action, String category, String targetEntity, String entityType) {
        AuditLogEntry auditLogEntry = new AuditLogEntry();
        auditLogEntry.setEventTime(new Date().getTime());
        auditLogEntry.setUserId(userId);
        auditLogEntry.setAction(action);
        auditLogEntry.setCategory(category);
        auditLogEntry.setTargetEntity(targetEntity);
        auditLogEntry.setEntityType(entityType);
        return auditLogEntry;
    }
}

