/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ddi;

import com.bwanms.ddi.DDInterface;
import com.bwanms.ddi.DDRegistryFactory;
import com.bwanms.logging.PatternLayoutHeaderAppAbout;
import com.bwanms.mediation.snmp.SNMPTrapFilter;
import com.bwanms.model.Equipment;
import com.bwanms.model.ManagementInterface;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtension;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.services.ServiceException;
import com.bwanms.util.ApplicationAbout;
import com.bwanms.util.PlatformConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDRegistry
implements Serializable {
    private static final Logger logger = Logger.getLogger(DDRegistry.class);
    private static DDRegistry instance = null;
    private Map<String, DDInterface> ddInterfaces = new HashMap<String, DDInterface>();
    private Map<String, DDInterface> ddiEquipmentClasses = new HashMap<String, DDInterface>();
    private Map<String, DDInterface> ddiServiceProfileClasses = new HashMap<String, DDInterface>();
    private Map<String, DDInterface> ddiServiceClasses = new HashMap<String, DDInterface>();
    private Map<String, DDInterface> ddiSubscriberClasses = new HashMap<String, DDInterface>();
    private List<String> ddiTopLevelEquipment = new Vector<String>();

    public static DDRegistry getInstance() {
        if (instance == null) {
            try {
                DDRegistryFactory factory = (DDRegistryFactory)PlatformConfiguration.instance().getDDRegistryFactoryImpl().newInstance();
                instance = factory.getDDRegistryInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create DDRegistryFactory", e);
            }
        }
        return instance;
    }

    private void setApplicationAbout() {
        String about = ApplicationAbout.getAbout();
        logger.info((Object)(System.getProperty("line.separator") + about));
        PatternLayoutHeaderAppAbout.setHeader(about);
    }

    public void configure() {
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        this.setApplicationAbout();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.deviceDriver");
        IExtension[] extensions = null;
        IConfigurationElement[] elements = null;
        if (extensionPoint != null) {
            extensions = extensionPoint.getExtensions();
            for (IExtension iExtension : extensions) {
                DDInterface ddInterface = null;
                String namespace = iExtension.getNamespace();
                IConfigurationElement[] configElements = iExtension.getConfigurationElements();
                IConfigurationElement ddElement = configElements[0];
                if (!"deviceDriver".equals(ddElement.getName())) {
                    throw new RuntimeException("Invalid configuration");
                }
                logger.info((Object)("Found DD: " + namespace));
                logger.info((Object)("Loading DD: " + ddElement.getAttribute("class")));
                ddInterface = (DDInterface)ddElement.createExecutableExtension("class");
                this.ddInterfaces.put(namespace, ddInterface);
            }
        }
        if ((extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.supportedEquipment")) != null) {
            elements = extensionPoint.getConfigurationElements();
            for (IConfigurationElement iConfigurationElement : elements) {
                this.ddiEquipmentClasses.put(iConfigurationElement.getAttribute("class"), this.ddInterfaces.get(iConfigurationElement.getNamespace()));
                if (!"yes".equals(iConfigurationElement.getAttribute("topLevel"))) continue;
                this.ddiTopLevelEquipment.add(iConfigurationElement.getAttribute("class"));
            }
        }
        if ((extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.supportedServiceProfiles")) != null) {
            elements = extensionPoint.getConfigurationElements();
            for (IConfigurationElement iConfigurationElement : elements) {
                this.ddiServiceProfileClasses.put(iConfigurationElement.getAttribute("class"), this.ddInterfaces.get(iConfigurationElement.getNamespace()));
            }
        }
        if ((extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.supportedServices")) != null) {
            elements = extensionPoint.getConfigurationElements();
            for (IConfigurationElement iConfigurationElement : elements) {
                this.ddiServiceClasses.put(iConfigurationElement.getAttribute("class"), this.ddInterfaces.get(iConfigurationElement.getNamespace()));
            }
        }
        if ((extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.supportedSubscribers")) != null) {
            elements = extensionPoint.getConfigurationElements();
            for (IConfigurationElement iConfigurationElement : elements) {
                this.ddiSubscriberClasses.put(iConfigurationElement.getAttribute("class"), this.ddInterfaces.get(iConfigurationElement.getNamespace()));
            }
        }
    }

    public DDInterface getDDInterfaceByEquipmentClass(String equipmentClass) {
        return this.ddiEquipmentClasses.get(equipmentClass);
    }

    public DDInterface getDDInterfaceByServiceProfileClass(String spClass) {
        return this.ddiServiceProfileClasses.get(spClass);
    }

    public DDInterface getDDInterfaceByServiceClass(String serviceClass) {
        return this.ddiServiceClasses.get(serviceClass);
    }

    public DDInterface getDDInterfaceBySubscriberClass(String subscriberClass) {
        return this.ddiSubscriberClasses.get(subscriberClass);
    }

    public List<String> getTopLevelEquipmentClassNames() {
        return new Vector<String>(this.ddiTopLevelEquipment);
    }

    public List<DDInterface> getDDInterfaces() {
        ArrayList<DDInterface> ret = new ArrayList<DDInterface>();
        ret.addAll(this.ddInterfaces.values());
        return ret;
    }

    public Equipment createEquipment(ManagementInterface mi, String eqClassName, String eqName) throws ServiceException {
        DDInterface ddi = this.getDDInterfaceByEquipmentClass(eqClassName);
        if (null == ddi) {
            throw new ServiceException("Can't determine DDInterface for equipment type: " + eqClassName);
        }
        try {
            SNMPTrapFilter.getAutoDiscoveryMap().remove(mi.getIp());
            return ddi.createEquipment(mi, eqName, Class.forName(eqClassName));
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }
}

