/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ddi;

import com.bwanms.mo.ManagedObject;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationChangedEvent
implements Serializable {
    private static final long serialVersionUID = -8792404600478424786L;
    private long equipmentId;
    private String networkResourceName;
    private Class<? extends ManagedObject> moClass;
    private HashSet<String> instances;
    private boolean asyncProcess = false;

    public ConfigurationChangedEvent(long equipmentId, String networkResourceName, Class<? extends ManagedObject> moClass, Collection<String> instances) {
        this.equipmentId = equipmentId;
        this.networkResourceName = networkResourceName;
        this.moClass = moClass;
        this.instances = new HashSet<String>(instances);
    }

    public ConfigurationChangedEvent(long equipmentId, String networkResourceName, Class<? extends ManagedObject> moClass, Collection<String> instances, boolean asyncProcess) {
        this(equipmentId, networkResourceName, moClass, instances);
        this.asyncProcess = asyncProcess;
    }

    public long getEquipmentId() {
        return this.equipmentId;
    }

    public Class<? extends ManagedObject> getMoClass() {
        return this.moClass;
    }

    public String getNetworkResourceName() {
        return this.networkResourceName;
    }

    public Collection<String> getInstances() {
        return this.instances;
    }

    public boolean isAsyncProcess() {
        return this.asyncProcess;
    }

    public boolean errode(ConfigurationChangedEvent other) {
        if (this.equipmentId != other.equipmentId || !this.networkResourceName.equals(this.networkResourceName) || !this.moClass.equals(other.moClass)) {
            return false;
        }
        this.instances.removeAll(other.instances);
        return this.instances.isEmpty();
    }
}

