/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.craft;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class CraftStarter {
    ArrayList<String> jarFiles = new ArrayList();
    private static boolean useSimulation = false;
    private static String lightBwanmsHome = System.getProperty("com.bwanms.home");

    public static void main(String[] args) {
        CraftStarter cs = new CraftStarter();
        cs.scanJarsFolder(new File(lightBwanmsHome + "/lib"));
        cs.scanJarsFolder(new File(lightBwanmsHome + "/plugins"));
        String arguments = "";
        boolean console = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].compareTo("-console") == 0) {
                console = true;
                continue;
            }
            if (args[i].compareTo("-h") == 0) {
                useSimulation = true;
                continue;
            }
            arguments = arguments + " " + args[i];
        }
        cs.startCraftMain(console, arguments);
    }

    public void scanJarsFolder(File libPath) {
        File[] files = libPath.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file == null) continue;
                if (file.isDirectory()) {
                    this.scanJarsFolder(file);
                    continue;
                }
                if (!file.getName().endsWith("jar")) continue;
                this.jarFiles.add(file.getPath());
            }
        } else {
            System.out.println("No jar files");
        }
    }

    public void showJars() {
        if (!this.jarFiles.isEmpty()) {
            System.out.println(this.jarFiles.toString());
        } else {
            System.out.println("no jars found");
        }
    }

    public void startCraftMain(boolean console, String args) {
        String command = "\"" + System.getProperty("java.home") + "/bin/javaw\" -classpath \"";
        command = command + lightBwanmsHome + "/conf;";
        for (String jarFile : this.jarFiles) {
            command = command + jarFile + ";";
        }
        command = command + "\"";
        try {
            command = command + " -Xms64m -Xmx512m";
            command = command + " -Dcom.bwanms.home=\"" + lightBwanmsHome + "\"";
            if (useSimulation) {
                command = command + " -Dcom.bwanms.rb.ddi.simulatedEquipmentRange=192.168.103.1-192.168.104.255";
            }
            command = command + " com.bwanms.craft.CraftMain2" + args;
            if (console) {
                Runtime rt = Runtime.getRuntime();
                Process proc = rt.exec(command);
                class StreamCollector
                extends Thread {
                    InputStream is;

                    StreamCollector(InputStream is) {
                        this.is = is;
                    }

                    public void run() {
                        try {
                            InputStreamReader isr = new InputStreamReader(this.is);
                            BufferedReader br = new BufferedReader(isr);
                            String line = null;
                            while ((line = br.readLine()) != null) {
                                System.out.println(line);
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }
                StreamCollector output = new StreamCollector(proc.getInputStream());
                output.start();
            } else {
                Runtime.getRuntime().exec(command);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

