/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.craft;

import com.bwanms.craft.CraftMain2;
import com.bwanms.gui.Internationalizer;
import com.bwanms.ui.components.ImagePanel;
import com.bwanms.util.FrameUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class CraftSplash {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(CraftMain2.class);
    private JFrame splashWindow = FrameUtil.createFrame();
    private JProgressBar pBar;

    public CraftSplash(URL backgroundUrl) {
        this.splashWindow.setTitle(i18n.translateString("WindowTitle"));
        this.splashWindow.setUndecorated(true);
        this.splashWindow.setLayout(new BorderLayout());
        JLabel loading = new JLabel("Loading...");
        loading.setHorizontalAlignment(0);
        ImagePanel imagePanel1 = new ImagePanel();
        if (backgroundUrl != null) {
            ImageIcon backgroundIcon = new ImageIcon(backgroundUrl);
            imagePanel1.setBackgroundImage(backgroundIcon.getImage());
        }
        this.splashWindow.getContentPane().add((Component)loading, "North");
        this.splashWindow.getContentPane().add((Component)imagePanel1, "Center");
        this.splashWindow.setSize(400, 200);
        this.pBar = new JProgressBar();
        this.pBar.setMinimum(0);
        this.pBar.setValue(0);
        this.pBar.setMaximum(100);
        this.splashWindow.getContentPane().add((Component)this.pBar, "South");
    }

    public CraftSplash() {
        this(CraftSplash.class.getResource("craft_splash.jpg"));
    }

    public void updateBar(int newValue) {
        this.pBar.setValue(this.pBar.getValue() + newValue);
    }

    void showSplashScreen() {
        FrameUtil.centerWindow(this.splashWindow);
        this.splashWindow.setVisible(true);
    }

    void hideSplashScreen() {
        this.splashWindow.setVisible(false);
        this.splashWindow.dispose();
    }

    public JFrame getSplashWindow() {
        return this.splashWindow;
    }
}

