/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.craft;

import com.bwanms.be.connection.InternalConnectionProvider;
import com.bwanms.craft.CraftFrame2;
import com.bwanms.craft.CraftPanel2;
import com.bwanms.craft.CraftSplash;
import com.bwanms.gui.Internationalizer;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.local.DiskFileSystemServiceLocal;
import com.bwanms.mediation.local.TftpFileTransferServiceLocal;
import com.bwanms.model.Task;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.services.PlatformServiceLocator;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.services.local.ActiveEquipmentManagerLocal;
import com.bwanms.services.local.ActiveTaskManagerLocal;
import com.bwanms.services.local.AgentEventProcessorManagerLocal;
import com.bwanms.services.local.ConfigurationChangeProcessorLocal;
import com.bwanms.services.local.EquipmentCommunicationHandlerLocal;
import com.bwanms.services.local.EquipmentStateManagerLocal;
import com.bwanms.services.local.LicenseServiceLocal;
import com.bwanms.services.local.LockManagerServiceLocal;
import com.bwanms.services.local.PlatformServiceLocal;
import com.bwanms.services.local.SchedulerServiceLocal;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.jboss.hibernate.jmx.HibernateLocal;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class CraftMain2 {
    private static Logger logger;
    private final int NUMBER_OF_SERVICES = 13;
    CraftSplash craftSplash = new CraftSplash();
    private String homeDir;
    public static CraftPanel2 mainFrame;
    private boolean developer = false;
    Thread refreshTaskListThread = new Thread(new Runnable(){

        public void run() {
            List<Task> tasks = ServiceRegistry.getTaskManagerService().retrieveTasks();
            for (Task task : tasks) {
                ServiceRegistry.getTaskManagerService().deleteTask(task.getId());
            }
        }
    });

    private CraftMain2(String homeDir) {
        this.homeDir = homeDir;
    }

    private void showMainWindow() {
        CraftFrame2 cf = new CraftFrame2();
        cf.setCleanupHook(new Runnable(){

            public void run() {
                CraftMain2.this.stop();
            }
        });
        cf.start();
        mainFrame = (CraftPanel2)cf.getFrame();
    }

    public void setDeveloper(boolean developer) {
        this.developer = developer;
    }

    private Properties getDeveloperDBProperties() {
        Properties props = new Properties();
        props.setProperty("hibernate.dialect", "org.hibernate.dialect.MySQLInnoDBDialect");
        props.setProperty("hibernate.connection.driver_class", "com.mysql.jdbc.Driver");
        props.setProperty("hibernate.connection.url", "jdbc:mysql://localhost:3306/bwanms");
        props.setProperty("hibernate.connection.username", "oware");
        props.setProperty("hibernate.connection.password", "dorado");
        props.setProperty("hibernate.connection.provider_class", InternalConnectionProvider.class.getName());
        props.setProperty("hibernate.connection.shutdown", "true");
        props.setProperty("hibernate.show_sql", "false");
        props.setProperty("hibernate.max_fetch_depth", "0");
        props.setProperty("hibernate.connection.isolation", "2");
        props.setProperty("hibernate.cglib.use_reflection_optimizer", "false");
        props.setProperty("hibernate.c3p0.min_size", "0");
        props.setProperty("hibernate.c3p0.max_size", "50");
        props.setProperty("hibernate.c3p0.timeout", "120");
        props.setProperty("hibernate.c3p0.idle_test_period", "0");
        props.setProperty("hibernate.c3p0.acquire_increment", "5");
        return props;
    }

    private Properties getDBProperties() {
        Properties props = new Properties();
        props.setProperty("hibernate.dialect", "org.hibernate.dialect.HSQLDialect");
        props.setProperty("hibernate.connection.driver_class", "org.hsqldb.jdbcDriver");
        props.setProperty("hibernate.connection.url", "jdbc:hsqldb:" + this.homeDir + "/data/bwanms" + ";hsqldb.default_table_type=cached" + ";shutdown=true");
        props.setProperty("hibernate.connection.username", "sa");
        props.setProperty("hibernate.connection.password", "");
        props.setProperty("hibernate.hbm2ddl.auto", "update");
        props.setProperty("hibernate.connection.shutdown", "true");
        props.setProperty("hibernate.connection.pool_size", "1");
        return props;
    }

    private void startServices() throws Exception {
        ExtensionRegistryFactory.getExtensionRegistry();
        HibernateLocal.getInstance().setPluginsFolder(this.homeDir + "/plugins");
        if (this.developer) {
            HibernateLocal.getInstance().setFactoryProperties(this.getDeveloperDBProperties());
        } else {
            HibernateLocal.getInstance().setFactoryProperties(this.getDBProperties());
        }
        HibernateLocal.getInstance().start();
        this.craftSplash.updateBar(7);
        logger.info((Object)"started HibernateLocal");
        PlatformServiceLocal.getInstance().start();
        this.craftSplash.updateBar(7);
        logger.info((Object)"started PlatformServiceLocal");
        LockManagerServiceLocal.getInstance().start();
        this.craftSplash.updateBar(7);
        logger.info((Object)"started LockManagerServiceLocal");
        ActiveTaskManagerLocal atm = ActiveTaskManagerLocal.getInstance();
        PlatformFactory.getApplicationLayerPlatform().getLookup().bind("bwanms/ActiveTaskManager", atm);
        this.craftSplash.updateBar(7);
        logger.info((Object)"started ActiveTaskManagerLocal");
        MediationServiceRegistry.getNetworkScanMediationService();
        AgentEventProcessorManagerLocal.getInstance().setProcessorThreads(5);
        AgentEventProcessorManagerLocal.getInstance().start();
        this.craftSplash.updateBar(7);
        ActiveEquipmentManagerLocal aem = ActiveEquipmentManagerLocal.getInstance();
        PlatformFactory.getApplicationLayerPlatform().getLookup().bind("bwanms/ActiveEquipmentManager", aem);
        this.craftSplash.updateBar(7);
        EquipmentStateManagerLocal.getInstance().start();
        this.craftSplash.updateBar(7);
        logger.info((Object)"started EquipmentStateManagerLocal");
        EquipmentCommunicationHandlerLocal.getInstance().start();
        this.craftSplash.updateBar(7);
        logger.info((Object)"started EquipmentCommunicationHandlerLocal");
        ConfigurationChangeProcessorLocal.getInstance().start();
        this.craftSplash.updateBar(7);
        logger.info((Object)"started EquipmentCommunicationHandlerLocal");
        try {
            StdSchedulerFactory factory = new StdSchedulerFactory();
            Scheduler scheduler = factory.getScheduler();
            scheduler.start();
            PlatformFactory.getApplicationLayerPlatform().getLookup().bind("Quartz", scheduler);
            SchedulerServiceLocal ssl = SchedulerServiceLocal.getInstance();
            PlatformFactory.getApplicationLayerPlatform().getLookup().bind("bwanms/SchedulerService", ssl);
            this.craftSplash.updateBar(7);
            logger.info((Object)"started Quartz");
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        DiskFileSystemServiceLocal.getInstance().start();
        this.craftSplash.updateBar(7);
        logger.info((Object)"started DiskFileSystemServiceLocal");
        LicenseServiceLocal.getInstance().start();
        this.craftSplash.updateBar(7);
        logger.info((Object)"started LicenseServiceLocal");
        TftpFileTransferServiceLocal.getInstance().start();
        this.craftSplash.updateBar(7);
        logger.info((Object)"started LicenseServiceLocal");
        PlatformServiceLocator.getPlatformService().sendInitializationSignal();
    }

    public static void setLookAndFeel() {
        try {
            String look = null;
            look = "com.jgoodies.looks.plastic.PlasticXPLookAndFeel";
            logger.info((Object)("lookAndFeel=[" + look + "]"));
            UIManager.setLookAndFeel(look);
            UIManager.put("Table.selectionBackground", new Color(204, 204, 255));
            UIManager.put("Table.selectionForeground", Color.BLACK);
            UIManager.put("Tree.selectionBackground", new Color(204, 204, 255));
            UIManager.put("Tree.selectionForeground", Color.BLACK);
        }
        catch (Exception e) {
            logger.error((Object)"Can't set look and feel.", (Throwable)e);
        }
    }

    private void initializeUI() {
        CraftMain2.setLookAndFeel();
    }

    private void start() throws Exception {
        this.initializeUI();
        this.craftSplash.showSplashScreen();
        this.startServices();
        this.refreshTaskListThread.run();
        this.showMainWindow();
        this.craftSplash.hideSplashScreen();
    }

    private void stop() {
        this.stopServices();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(0);
    }

    private void stopServices() {
        EquipmentStateManagerLocal.getInstance().stop();
        EquipmentCommunicationHandlerLocal.getInstance().stop();
        ConfigurationChangeProcessorLocal.getInstance().stop();
        LockManagerServiceLocal.getInstance().stop();
        TftpFileTransferServiceLocal.getInstance().stop();
        DiskFileSystemServiceLocal.getInstance().stop();
        LicenseServiceLocal.getInstance().stop();
        PlatformServiceLocal.getInstance().stop();
        HibernateLocal.getInstance().stop();
    }

    private boolean isCraftAllowed(String command) {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(command);
            StreamConsumer errorStreamConsumer = new StreamConsumer(p.getErrorStream());
            StreamConsumer outputStreamConsumer = new StreamConsumer(p.getInputStream());
            errorStreamConsumer.start();
            outputStreamConsumer.start();
            if (p.waitFor() > 1) {
                return false;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static final void main(String[] args) {
        boolean developer = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-dev")) continue;
            developer = true;
        }
        String homeDir = System.getProperty("com.bwanms.home");
        if (homeDir == null) {
            homeDir = "c:/lightbwanms";
            System.setProperty("com.bwanms.home", "c:/lightbwanms");
        }
        if (homeDir == null) {
            System.out.println("Property com.bwanms.home not set. Exiting!");
            System.exit(1);
        }
        System.setProperty("com.bwanms.platform", "local");
        logger = Logger.getLogger(CraftMain2.class);
        CraftMain2 craft = new CraftMain2(homeDir);
        craft.setDeveloper(developer);
        String command = null;
        try {
            File homeDirF = new File(homeDir);
            String path = homeDirF.getCanonicalPath();
            command = String.format("%s\\processQuerry.exe \"%s\\jre\\bin\\javaw.exe\"", path, path);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        logger.info(command);
        if (!craft.isCraftAllowed(command)) {
            Internationalizer i18n = Internationalizer.getInternationalizer(CraftMain2.class);
            JOptionPane.showMessageDialog(null, i18n.translateString("AnotherInstance"), i18n.translateString("ErrorStartingApplication"), 1, new ImageIcon(CraftMain2.class.getResource("frameIcon.gif")));
            System.exit(1);
        }
        try {
            craft.start();
        }
        catch (Exception e) {
            System.out.println("There was an error starting the application");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private class StreamConsumer
    extends Thread {
        InputStream is;

        StreamConsumer(InputStream is) {
            this.is = is;
        }

        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String str = br.readLine();
                while (str != null) {
                    System.out.println(str);
                    str = br.readLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

