/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.craft;

import com.bwanms.backend.services.local.PropertiesManagerLocal;
import com.bwanms.be.connection.InternalConnectionProvider;
import com.bwanms.craft.CraftFrame;
import com.bwanms.craft.CraftSplash;
import com.bwanms.frontend.nbi.NbiEventForwardingServiceLocal;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.local.DiskFileSystemServiceLocal;
import com.bwanms.mediation.local.TftpFileTransferServiceLocal;
import com.bwanms.mediation.services.local.EventNotificationServiceLocal;
import com.bwanms.mediation.services.local.SNMPTrapAgentEventNetworkListenerLocal;
import com.bwanms.model.SNMPAgentAuthentication;
import com.bwanms.model.SingleRangeScanTask;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.persistence.Datastore;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.services.PlatformServiceLocator;
import com.bwanms.services.local.ActiveEquipmentManagerLocal;
import com.bwanms.services.local.ActiveTaskManagerLocal;
import com.bwanms.services.local.AgentEventProcessorManagerLocal;
import com.bwanms.services.local.ConfigurationChangeProcessorLocal;
import com.bwanms.services.local.EntityEventProcessorLocal;
import com.bwanms.services.local.EquipmentCommunicationHandlerLocal;
import com.bwanms.services.local.EquipmentStateManagerLocal;
import com.bwanms.services.local.EventsRemoveDaemonLocal;
import com.bwanms.services.local.LicenseServiceLocal;
import com.bwanms.services.local.LockManagerServiceLocal;
import com.bwanms.services.local.PlatformServiceLocal;
import com.bwanms.services.local.SchedulerServiceLocal;
import com.bwanms.services.local.TFTPManagerLocal;
import com.bwanms.services.local.TimingThreadPoolLocal;
import com.bwanms.services.local.TopologyServiceLocal;
import com.bwanms.util.Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.jboss.hibernate.jmx.HibernateLocal;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class CraftMain {
    private final int NUMBER_OF_SERVICES = 24;
    CraftSplash craftSplash;
    private String homeDir = System.getProperty("com.bwanms.home");
    private String dbms = "HSQL";

    CraftMain() {
        if (this.homeDir == null) {
            System.out.println("Property com.bwanms.home not set. Exiting!. Try something like '-Dcom.bwanms.home=path/to/the/lightbwanms' VM argument.");
            System.exit(1);
        }
    }

    private void showMainWindow() {
        CraftFrame cf = new CraftFrame();
        cf.setCleanupHook(new Runnable(){

            public void run() {
                CraftMain.this.stop();
            }
        });
        cf.start();
    }

    void setDbms(String dbms) {
        this.dbms = dbms;
    }

    private Properties getMySQLProperties() {
        Properties props = new Properties();
        props.setProperty("hibernate.dialect", "org.hibernate.dialect.MySQLInnoDBDialect");
        props.setProperty("hibernate.connection.driver_class", "com.mysql.jdbc.Driver");
        props.setProperty("hibernate.connection.url", "jdbc:mysql://localhost:3306/bwanms?rewriteBatchedStatements=true");
        props.setProperty("hibernate.connection.username", "oware");
        props.setProperty("hibernate.connection.password", "dorado");
        props.setProperty("hibernate.connection.provider_class", InternalConnectionProvider.class.getName());
        props.setProperty("hibernate.connection.shutdown", "false");
        props.setProperty("hibernate.show_sql", System.getProperty("hibernate.show_sql", "false"));
        props.setProperty("hibernate.max_fetch_depth", "0");
        props.setProperty("hibernate.connection.isolation", "2");
        props.setProperty("hibernate.cglib.use_reflection_optimizer", "false");
        props.setProperty("hibernate.c3p0.min_size", "0");
        props.setProperty("hibernate.c3p0.max_size", "50");
        props.setProperty("hibernate.c3p0.timeout", "120");
        props.setProperty("hibernate.c3p0.idle_test_period", "0");
        props.setProperty("hibernate.c3p0.acquire_increment", "5");
        return props;
    }

    private Properties getOracleProperties() {
        Properties props = new Properties();
        props.setProperty("hibernate.dialect", "org.hibernate.dialect.OracleDialect");
        props.setProperty("hibernate.connection.driver_class", "oracle.jdbc.OracleDriver");
        props.setProperty("hibernate.connection.url", "jdbc:oracle:thin:@192.168.1.212:1521:BWANMS1");
        props.setProperty("hibernate.connection.username", "andreiv");
        props.setProperty("hibernate.connection.password", "andreiv");
        props.setProperty("hibernate.connection.provider_class", InternalConnectionProvider.class.getName());
        props.setProperty("hibernate.hbm2ddl.auto", "create");
        props.setProperty("hibernate.connection.shutdown", "false");
        props.setProperty("hibernate.show_sql", "false");
        props.setProperty("hibernate.max_fetch_depth", "0");
        props.setProperty("hibernate.connection.isolation", "2");
        props.setProperty("hibernate.cglib.use_reflection_optimizer", "false");
        props.setProperty("hibernate.c3p0.min_size", "0");
        props.setProperty("hibernate.c3p0.max_size", "50");
        props.setProperty("hibernate.c3p0.timeout", "120");
        props.setProperty("hibernate.c3p0.idle_test_period", "0");
        props.setProperty("hibernate.c3p0.acquire_increment", "5");
        return props;
    }

    private Properties getHSQLProperties() {
        Properties props = new Properties();
        props.setProperty("hibernate.dialect", "org.hibernate.dialect.HSQLDialect");
        props.setProperty("hibernate.connection.driver_class", "org.hsqldb.jdbcDriver");
        props.setProperty("hibernate.connection.url", "jdbc:hsqldb:" + this.homeDir + "/data/bwanms" + ";hsqldb.default_table_type=cached;shutdown=true");
        props.setProperty("hibernate.connection.username", "sa");
        props.setProperty("hibernate.connection.password", "");
        props.setProperty("hibernate.connection.shutdown", "true");
        props.setProperty("hibernate.connection.provider_class", InternalConnectionProvider.class.getName());
        props.setProperty("hibernate.connection.pool_size", "1");
        return props;
    }

    public Properties getHibernateProperties() {
        Properties props = null;
        if ("MySQL".equalsIgnoreCase(this.dbms)) {
            props = this.getMySQLProperties();
        } else if ("Oracle".equalsIgnoreCase(this.dbms)) {
            props = this.getOracleProperties();
        } else if ("HSQL".equalsIgnoreCase(this.dbms)) {
            props = this.getHSQLProperties();
        }
        return props;
    }

    void startServices() throws Exception {
        PropertiesManagerLocal.getInstance().start();
        this.updateSplashBar();
        ExtensionRegistryFactory.getExtensionRegistry();
        HibernateLocal.getInstance().setPluginsFolder(this.homeDir + "/plugins");
        HibernateLocal.getInstance().setFactoryProperties(this.getHibernateProperties());
        HibernateLocal.getInstance().start();
        this.updateSplashBar();
        PlatformServiceLocal.getInstance().start();
        this.updateSplashBar();
        LockManagerServiceLocal.getInstance().start();
        this.updateSplashBar();
        ActiveTaskManagerLocal.getInstance().startLocalService();
        this.updateSplashBar();
        ActiveEquipmentManagerLocal.getInstance().startLocalService();
        this.updateSplashBar();
        TopologyServiceLocal.getInstance().start();
        this.updateSplashBar();
        EntityEventProcessorLocal.getInstance().start();
        this.updateSplashBar();
        TimingThreadPoolLocal.getInstance().start();
        this.updateSplashBar();
        EventNotificationServiceLocal.getInstance().start();
        this.updateSplashBar();
        MediationServiceRegistry.getNetworkScanMediationService();
        AgentEventProcessorManagerLocal.getInstance().setProcessorThreads(5);
        AgentEventProcessorManagerLocal.getInstance().start();
        this.updateSplashBar();
        SNMPTrapAgentEventNetworkListenerLocal.getInstance().start();
        this.updateSplashBar();
        EquipmentStateManagerLocal.getInstance().start();
        this.updateSplashBar();
        EquipmentCommunicationHandlerLocal.getInstance().start();
        this.updateSplashBar();
        ConfigurationChangeProcessorLocal.getInstance().start();
        this.updateSplashBar();
        try {
            StdSchedulerFactory factory = new StdSchedulerFactory();
            Scheduler scheduler = factory.getScheduler();
            scheduler.start();
            this.updateSplashBar();
            PlatformFactory.getApplicationLayerPlatform().getLookup().bind("Quartz", scheduler);
            SchedulerServiceLocal ssl = SchedulerServiceLocal.getInstance();
            PlatformFactory.getApplicationLayerPlatform().getLookup().bind("bwanms/SchedulerService", ssl);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        DiskFileSystemServiceLocal.getInstance().start();
        this.updateSplashBar();
        LicenseServiceLocal.getInstance().start();
        this.updateSplashBar();
        TftpFileTransferServiceLocal.getInstance().start();
        this.updateSplashBar();
        TFTPManagerLocal.getInstance().start();
        this.updateSplashBar();
        EventsRemoveDaemonLocal.getInstance().startDaemon();
        this.updateSplashBar();
        NbiEventForwardingServiceLocal.getInstance().startLocalService();
        this.updateSplashBar();
        PlatformServiceLocator.getPlatformService().sendInitializationSignal();
    }

    private void updateSplashBar() {
        if (this.craftSplash != null) {
            this.craftSplash.updateBar(4);
        }
    }

    private void initializeUI() {
        Settings.setLookAndFeel();
    }

    private void start() throws Exception {
        this.craftSplash = new CraftSplash();
        this.initializeUI();
        this.craftSplash.showSplashScreen();
        this.startServices();
        this.checkInitialData();
        this.showMainWindow();
        this.craftSplash.hideSplashScreen();
    }

    private void stop() {
        this.stopServices();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(0);
    }

    void stopServices() {
        NbiEventForwardingServiceLocal.getInstance().stopLocalService();
        EventsRemoveDaemonLocal.getInstance().stopDaemon();
        SNMPTrapAgentEventNetworkListenerLocal.getInstance().stop();
        AgentEventProcessorManagerLocal.getInstance().stop();
        EventNotificationServiceLocal.getInstance().stop();
        EntityEventProcessorLocal.getInstance().stop();
        EquipmentStateManagerLocal.getInstance().stop();
        EquipmentCommunicationHandlerLocal.getInstance().stop();
        ConfigurationChangeProcessorLocal.getInstance().stop();
        LockManagerServiceLocal.getInstance().stop();
        TftpFileTransferServiceLocal.getInstance().stop();
        TFTPManagerLocal.getInstance().stop();
        DiskFileSystemServiceLocal.getInstance().stop();
        LicenseServiceLocal.getInstance().stop();
        TopologyServiceLocal.getInstance().stop();
        TimingThreadPoolLocal.getInstance().stop();
        PlatformServiceLocal.getInstance().stop();
        HibernateLocal.getInstance().stop();
        PropertiesManagerLocal.getInstance().stop();
    }

    public static final void main(String[] args) {
        boolean developer = false;
        String dbms = "HSQL";
        if (args.length >= 1) {
            if (args[0].equals("-dev")) {
                developer = true;
            }
            if (developer) {
                dbms = args.length > 1 ? args[1] : "MySQL";
            }
        }
        System.setProperty("com.bwanms.platform", "debug");
        System.setProperty("com.bwanms.rb.mediationIpAddressRanges", "192.168.101.254=192.168.101.0/255.255.255.0");
        CraftMain craft = new CraftMain();
        craft.setDbms(dbms);
        try {
            craft.start();
        }
        catch (Exception e) {
            System.out.println("There was an error starting the application");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void checkInitialData() {
        try {
            new CallableDatastoreDecorator<Object>(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    List scanTaskList = Datastore.session().createQuery("from " + SingleRangeScanTask.class.getName()).list();
                    if (scanTaskList.isEmpty()) {
                        SingleRangeScanTask task = new SingleRangeScanTask();
                        task.setName("de_fault");
                        task.setRangeType(1);
                        task.setRangeStart("192.168.100.130");
                        task.setRangeEnd("192.168.100.240");
                        task.setRetries(1);
                        task.setTimeout(5000L);
                        ArrayList<SNMPAgentAuthentication> auth = new ArrayList<SNMPAgentAuthentication>(1);
                        auth.add(new SNMPAgentAuthentication("public", "private"));
                        task.setCommunities(auth);
                        Datastore.session().save((Object)task);
                    }
                    return null;
                }
            }).call();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

