/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.craft;

import com.bwanms.craft.MultiViewContainer;
import com.bwanms.gui.View;
import com.bwanms.ui.components.closeandmaxtabbedpane.CloseAndMaxTabbedPane;
import com.bwanms.ui.components.closeandmaxtabbedpane.CloseListener;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CraftImprovedJTabbedPaneContainer
implements MultiViewContainer {
    private static CloseAndMaxTabbedPane tabbedPane;
    private static final Logger logger;
    private static HashMap<JComponent, View> forCleanup;

    @Override
    public void openView(View view) {
        JComponent component = view.getUI();
        JScrollPane jPane = new JScrollPane();
        jPane.setBorder(BorderFactory.createEmptyBorder());
        if (component != null) {
            jPane.setViewportView(component);
            tabbedPane.addTab(view.getTitle(), jPane);
            forCleanup.put(component, view);
            tabbedPane.setSelectedIndex(tabbedPane.getTabCount() - 1);
        }
    }

    @Override
    public void setForegroundView(View view) {
        if (view.getUI() != null) {
            int indexPosition = tabbedPane.indexOfTab(view.getTitle());
            if (indexPosition != -1) {
                tabbedPane.setSelectedIndex(indexPosition);
            } else {
                this.openView(view);
            }
        }
    }

    @Override
    public List<Component> getOpenViews() {
        Component[] comps = tabbedPane.getComponents();
        ArrayList<Component> listComps = new ArrayList<Component>();
        for (Component comp : comps) {
            listComps.add(comp);
        }
        return listComps;
    }

    @Override
    public JComponent getUI() {
        if (tabbedPane == null) {
            tabbedPane = new CloseAndMaxTabbedPane(true);
            URL backgroundURL = CraftImprovedJTabbedPaneContainer.class.getResource("background.jpg");
            if (backgroundURL != null) {
                ImageIcon backgroundIcon = new ImageIcon(backgroundURL);
                tabbedPane.setBackgroundImage(backgroundIcon.getImage());
            }
            tabbedPane.setMaxIcon(false);
            tabbedPane.addCloseListener(new CloseListener(){

                public void closeOperation(MouseEvent e) {
                    JScrollPane jPane = (JScrollPane)tabbedPane.getComponentAt(tabbedPane.getOverTabIndex());
                    View viewToClean = (View)forCleanup.get(jPane.getViewport().getView());
                    viewToClean.cleanup();
                    tabbedPane.remove(tabbedPane.getOverTabIndex());
                }
            });
        }
        return tabbedPane;
    }

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String getTitle() {
        return null;
    }

    static {
        logger = Logger.getLogger(CraftImprovedJTabbedPaneContainer.class);
        forCleanup = new HashMap();
    }
}

