/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.craft;

import com.bwanms.craft.CraftPanel2;
import com.bwanms.gui.Application;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.about.AboutForm;
import com.bwanms.gui.about.AboutView;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CraftFrame2 {
    private static final Logger logger = Logger.getLogger(CraftFrame2.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(CraftFrame2.class);
    private static Map<String, Class> classesForApplication = new HashMap<String, Class>();
    private JScrollPane container;
    private JFrame frame;
    private JPanel panel;
    private Runnable cleanupHook;

    public CraftFrame2() {
        this.configure();
    }

    public void start() {
        CraftPanel2 craft = new CraftPanel2();
        this.frame = craft.getFrame1();
        this.panel = craft.getPanel1();
        this.setMenu(craft);
        this.container = new JScrollPane();
        this.container.setBorder(null);
        this.panel.add(this.container);
        this.setDeviceManagerPanel();
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CraftFrame2.this.closingForReal();
            }
        });
        this.run(700, 550);
    }

    private void closingForReal() {
        Object[] options = new String[]{i18n.translateString("Exit_App_Yes"), i18n.translateString("Exit_App_No")};
        if (JOptionPane.showOptionDialog(this.frame, i18n.translateString("Exit_App"), i18n.translateString("Exit_App_Title"), 0, 3, null, options, options[0]) == 0) {
            this.frame.dispose();
            if (this.cleanupHook != null) {
                this.cleanupHook.run();
            }
        }
    }

    private void setMenu(CraftPanel2 craft) {
        craft.getMenuDeviceManager().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CraftFrame2.this.setDeviceManagerPanel();
            }
        });
        craft.getMenuItemAbout().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CraftFrame2.this.setAboutPanel();
            }
        });
        craft.getMenuItemExit().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CraftFrame2.this.closingForReal();
            }
        });
    }

    private void setDeviceManagerPanel() {
        Application appDeviceManager = this.getApplication("CraftEquipmentManager");
        this.container.setViewportView(appDeviceManager.createView().getUI());
    }

    private void setAboutPanel() {
        this.panel.add(this.container);
        this.container.setViewportView(new AboutView(){

            protected void initForm() {
                this.form = new AboutForm(){

                    protected URL getBackgroundURL() {
                        return this.getClass().getResource("craftAbout.jpg");
                    }
                };
            }
        }.getUI());
    }

    public static Map<String, Class> getClassesForApplication() {
        return classesForApplication;
    }

    private void configure() {
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.application");
        if (extensionPoint != null) {
            IConfigurationElement[] elements;
            for (IConfigurationElement element : elements = extensionPoint.getConfigurationElements()) {
                try {
                    Class<?> clazz = Class.forName(element.getAttribute("class"));
                    String name = element.getAttribute("name");
                    classesForApplication.put(name, clazz);
                }
                catch (Exception e) {
                    logger.error((Object)("Error on loading application class: " + element.getAttribute("class")), (Throwable)e);
                }
            }
        }
    }

    public void setHomePage(String clazzName) {
        Application app = this.getApplication(clazzName);
        if (app != null) {
            this.container.setViewportView(app.createView().getUI());
        }
    }

    private Application getApplication(String clazzName) {
        Map<String, Class> clazzez = CraftFrame2.getClassesForApplication();
        Class clazz = clazzez.get(clazzName);
        try {
            if (clazz != null) {
                Application app = (Application)clazz.newInstance();
                String platform = System.getProperty("com.bwanms.platform");
                if (platform.equals("local") ? !app.isCraftAllowed() : !app.isEnterpriseAllowed()) {
                    return null;
                }
                return app;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to find class with name: " + clazzName), (Throwable)e);
        }
        return null;
    }

    private void run(int width, int height) {
        int maxWidth = (int)this.frame.getGraphicsConfiguration().getBounds().getWidth();
        int maxHeight = (int)this.frame.getGraphicsConfiguration().getBounds().getHeight();
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent event) {
                CraftFrame2.this.frame.setSize(Math.max(605, CraftFrame2.this.frame.getWidth()), Math.max(522, CraftFrame2.this.frame.getHeight()));
            }
        });
        this.frame.setSize(width, height);
        this.frame.setTitle(i18n.translateString("WindowTitle"));
        this.frame.repaint();
        this.frame.setLocation((maxWidth - width) / 2, (maxHeight - height) / 2);
        this.frame.setVisible(true);
        this.frame.toFront();
    }

    public void setCleanupHook(Runnable cleanupHook) {
        this.cleanupHook = cleanupHook;
    }

    public JFrame getFrame() {
        return this.frame;
    }
}

