/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.craft;

import com.bwanms.backend.services.EventDAO;
import com.bwanms.client.gui.fault.images.FaultImageLoader;
import com.bwanms.craft.CraftImprovedJTabbedPaneContainer;
import com.bwanms.craft.CraftMain;
import com.bwanms.craft.CraftPanel;
import com.bwanms.craft.MultiViewContainer;
import com.bwanms.gui.Application;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CraftFrame {
    private static final Logger logger = Logger.getLogger(CraftFrame.class);
    private static Map<String, Class<Application>> classesForApplication = new HashMap<String, Class<Application>>();
    private MultiViewContainer container;
    private JFrame frame;
    private JPanel panel;
    private Runnable cleanupHook;

    public CraftFrame() {
        this.configure();
    }

    public void start() {
        CraftPanel craft = new CraftPanel();
        this.frame = craft.getFrame1();
        this.panel = craft.getPanel1();
        this.setMenu(craft.getMenuBar1());
        this.setIconMenu(craft.getMenuBar2());
        craft.setMouseListenersForOverlap();
        this.container = new CraftImprovedJTabbedPaneContainer();
        this.panel.add(this.container.getUI());
        this.setHomePage("EquipmentManager");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CraftFrame.this.frame.dispose();
                super.windowClosing(e);
                if (CraftFrame.this.cleanupHook != null) {
                    CraftFrame.this.cleanupHook.run();
                }
            }
        });
        this.run(800, 680);
    }

    public static Map<String, Class<Application>> getClassesForApplication() {
        return classesForApplication;
    }

    private void configure() {
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.application");
        if (extensionPoint != null) {
            IConfigurationElement[] elements;
            for (IConfigurationElement element : elements = extensionPoint.getConfigurationElements()) {
                try {
                    Class<?> clazz = Class.forName(element.getAttribute("class"));
                    String name = element.getAttribute("name");
                    classesForApplication.put(name, clazz);
                }
                catch (Exception e) {
                    logger.error((Object)("Error on loading application class: " + element.getAttribute("class")), (Throwable)e);
                }
            }
        }
    }

    public void setHomePage(String clazzName) {
        Application app = this.getApplication(clazzName);
        if (app != null) {
            this.container.openView(app.createView());
        }
    }

    private void setMenu(JMenuBar menuBar) {
        JMenu menu = this.createMenu("File");
        JMenu open = this.createMenu("Open");
        JMenu menuInv = this.createMenu("Inventory");
        this.addMenuItem(menuInv, "ManagedNetwork");
        this.addMenuItem(menuInv, "EquipmentManager");
        this.addMenuItem(menuInv, "ConfigBackupManager");
        this.addMenuItem(menuInv, "LocationManager");
        this.addMenuItem(menuInv, "ContactManager");
        this.addMenuItem(menuInv, "TaskManager");
        this.addMenuItem(menuInv, "AuditLogManager");
        this.addMenuItem(menuInv, "FileManager");
        this.addMenuItem(menuInv, "PerformanceCollectionViewer");
        this.addMenuItem(menuInv, "GPSChainManager");
        open.add(menuInv);
        JMenu menuServices = this.createMenu("Services");
        this.addMenuItem(menuServices, "ServiceManager");
        this.addMenuItem(menuServices, "ServiceProfileManager");
        this.addMenuItem(menuServices, "SubscriberManager");
        open.add(menuServices);
        JMenu menuEventServices = this.createMenu("New Events");
        this.addMenuItem(menuEventServices, "EventMonitorManager");
        this.addMenuItem(menuEventServices, "EventHistoryManager");
        this.addMenuItem(menuEventServices, "EventFilterManager");
        this.addMenuItem(menuEventServices, "EventTemplateManager");
        this.addMenuItem(menuEventServices, "CommandsManager");
        this.addMenuItem(menuEventServices, "EventForwardingManager");
        open.add(menuEventServices);
        JMenu menuHelp = this.createMenu("Help");
        this.addMenuItem(menuHelp, "About");
        menuHelp.addSeparator();
        this.addMenuItem(menuHelp, "LicenseManager");
        JMenuItem exitMenu = new JMenuItem();
        exitMenu.setText("Exit");
        exitMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CraftFrame.this.frame.dispatchEvent(new WindowEvent(CraftFrame.this.frame, 201));
            }
        });
        menu.add(open);
        menu.add(exitMenu);
        menuBar.add(menu);
        menuBar.add(menuHelp);
    }

    private void setIconMenu(JMenuBar menuBar) {
        JMenu menuInv = this.createIconMenu("Inventory", "inventory.jpg", CraftMain.class);
        this.addMenuItem(menuInv, "ManagedNetwork");
        this.addMenuItem(menuInv, "EquipmentManager");
        this.addMenuItem(menuInv, "ConfigBackupManager");
        this.addMenuItem(menuInv, "LocationManager");
        this.addMenuItem(menuInv, "GPSChainManager");
        menuBar.add(menuInv);
        JMenu menuServices = this.createIconMenu("Services", "inventory.jpg", CraftMain.class);
        this.addMenuItem(menuServices, "ServiceManager");
        this.addMenuItem(menuServices, "ServiceProfileManager");
        this.addMenuItem(menuServices, "SubscriberManager");
        menuBar.add(menuServices);
        JMenu menuFault = this.createIconMenu("Fault", "eventservices.gif", FaultImageLoader.class);
        this.addMenuItem(menuFault, "EventMonitorManager", "eventmonitor.gif", FaultImageLoader.class);
        this.addMenuItem(menuFault, "EventHistoryManager", "eventhistory.gif", FaultImageLoader.class);
        this.addMenuItem(menuFault, "EventFilterManager", "eventfilter.gif", FaultImageLoader.class);
        this.addMenuItem(menuFault, "EventTemplateManager", "eventtemplates.gif", FaultImageLoader.class);
        this.addMenuItem(menuFault, "CommandsManager", "command.gif", FaultImageLoader.class);
        this.addMenuItem(menuFault, "EventForwardingManager", "northbound.gif", FaultImageLoader.class);
        menuBar.add(menuFault);
        JMenu menuPerformance = this.createIconMenu("Performance", "inventory.jpg", CraftMain.class);
        this.addMenuItem(menuPerformance, "PerformanceCollectionViewer");
        menuBar.add(menuPerformance);
        JMenu menuAdmin = this.createIconMenu("Administration", "inventory.jpg", CraftMain.class);
        this.addMenuItem(menuAdmin, "TaskManager");
        this.addMenuItem(menuAdmin, "FileManager");
        this.addMenuItem(menuAdmin, "ContactManager");
        this.addMenuItem(menuAdmin, "AuditLogManager");
        menuAdmin.addSeparator();
        this.addMenuItem(menuAdmin, "LicenseManager");
        menuBar.add(menuAdmin);
        JMenu menuHelp = this.createIconMenu("Help", "inventory.jpg", CraftMain.class);
        this.addMenuItem(menuHelp, "About");
        this.addMenuItem(menuHelp, "Help");
        menuBar.add(menuHelp);
    }

    private JMenu createIconMenu(String name, String icon, Class<?> clazz) {
        JMenu menu = new JMenu();
        URL backgroundURL = null;
        if (clazz != null) {
            backgroundURL = clazz.getResource(icon);
        } else {
            try {
                backgroundURL = new URL(icon);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (backgroundURL != null) {
            ImageIcon backgroundIcon = new ImageIcon(backgroundURL);
            menu.setIcon(backgroundIcon);
        }
        menu.setText(name);
        menu.setHorizontalAlignment(0);
        menu.setVerticalTextPosition(3);
        menu.setHorizontalTextPosition(0);
        menu.setPreferredSize(new Dimension(80, 80));
        return menu;
    }

    private JMenu createMenu(String name) {
        JMenu menu = new JMenu();
        menu.setText(name);
        return menu;
    }

    private JMenuItem createMenuItem(String clazzName) {
        JMenuItem menuItem = new JMenuItem();
        final Application app = this.getApplication(clazzName);
        if (app != null) {
            menuItem.setText(app.getName());
            menuItem.setMnemonic(app.getMnemonic());
            menuItem.setAccelerator(app.getAccelerator());
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (app.isMultiInstance()) {
                        CraftFrame.this.container.openView(app.createView());
                    } else {
                        CraftFrame.this.container.setForegroundView(app.createView());
                    }
                }
            });
            return menuItem;
        }
        return null;
    }

    private void addMenuItem(JMenu menu, String item) {
        JMenuItem menuItem = this.createMenuItem(item);
        if (menuItem != null) {
            menu.add(menuItem);
        }
    }

    private void addMenuItem(JMenu menu, String item, String icon, Class<?> clazz) {
        URL backgroundURL;
        JMenuItem menuItem = this.createMenuItem(item);
        if (clazz != null && (backgroundURL = clazz.getResource(icon)) != null) {
            ImageIcon backgroundIcon = new ImageIcon(backgroundURL);
            menuItem.setIcon(backgroundIcon);
        }
        if (menuItem != null) {
            menu.add(menuItem);
        }
    }

    private Application getApplication(String clazzName) {
        Map<String, Class<Application>> clazzez = CraftFrame.getClassesForApplication();
        Class<Application> clazz = clazzez.get(clazzName);
        try {
            if (clazz != null) {
                Application app = clazz.newInstance();
                String platform = System.getProperty("com.bwanms.platform");
                if (platform.equals("local") ? !app.isCraftAllowed() : !app.isEnterpriseAllowed()) {
                    return null;
                }
                return app;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to find class with name: " + clazzName), (Throwable)e);
        }
        return null;
    }

    private void run(int width, int height) {
        int maxWidth = (int)this.frame.getGraphicsConfiguration().getBounds().getWidth();
        int maxHeight = (int)this.frame.getGraphicsConfiguration().getBounds().getHeight();
        this.frame.setSize(width, height);
        this.frame.setTitle("Debug Platform - " + EventDAO.Database.getDB(null).name());
        this.frame.repaint();
        this.frame.setLocation((maxWidth - width) / 2, (maxHeight - height) / 2);
        this.frame.setVisible(true);
    }

    public void setCleanupHook(Runnable cleanupHook) {
        this.cleanupHook = cleanupHook;
    }
}

