/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.craft;

import com.bwanms.craft.CraftMain2;
import com.bwanms.gui.Internationalizer;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class CraftCheckAnotherInstance {
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(CraftCheckAnotherInstance.class);
    private static final Logger logger = Logger.getLogger(CraftCheckAnotherInstance.class);
    private static CraftCheckAnotherInstance instance;
    private CraftServerSocket css;
    private Frame parent;
    private final int port = 7811;
    private final int portStep = 101;
    private final int numIterations = 3;
    private static final String QUESTION = "9120ue8hdsfs0*(@Y!(*";
    private static final String RESPONSE = "oidsfb834^@&jos)@-128";
    private static final String NOPARENT = "82hrdso;ljx9";
    private static final int NO_ERROR = 0;
    private static final int ERROR = 1;
    private static final int BAD_SERVER = 2;
    private static final int ANOTHER_INSTANCE = 3;
    private static final int ANOTHER_INSTANCE_DIALOG = 4;

    private CraftCheckAnotherInstance() {
    }

    public static CraftCheckAnotherInstance getInstance() {
        if (instance == null) {
            instance = new CraftCheckAnotherInstance();
        }
        return instance;
    }

    public void setParent(JFrame parent) {
        this.parent = parent;
    }

    public void start() {
        int step;
        int errorCode = 1;
        String ports = "";
        int iPort = 0;
        for (step = 0; step < 3; ++step) {
            iPort = 7811 + step * 101;
            ports = ports + " " + iPort;
            try {
                CraftClientSocket ccs = new CraftClientSocket(iPort);
                boolean doBreak = false;
                switch (ccs.talk()) {
                    case 1: {
                        errorCode = 3;
                        doBreak = true;
                        break;
                    }
                    case 2: {
                        errorCode = 4;
                        doBreak = true;
                        break;
                    }
                    default: {
                        errorCode = 2;
                    }
                }
                if (!doBreak) continue;
                break;
            }
            catch (Exception e) {
                errorCode = 1;
            }
        }
        if (errorCode == 1) {
            for (step = 0; step < 3; ++step) {
                iPort = 7811 + step * 101;
                try {
                    this.css = new CraftServerSocket(iPort);
                    this.css.start();
                    errorCode = 0;
                    break;
                }
                catch (Exception e) {
                    continue;
                }
            }
        }
        String msg = i18n.translateString("ErrorStartingApplication");
        switch (errorCode) {
            case 0: {
                logger.info((Object)("Another Instance not found. Starting Craft on port " + iPort + " ..."));
                break;
            }
            case 3: {
                logger.info((Object)(msg + " " + i18n.translateString("AnotherInstance") + " port:" + iPort));
                System.exit(1);
                break;
            }
            case 4: {
                JOptionPane.showMessageDialog(null, i18n.translateString("AnotherInstance"), msg, 1, new ImageIcon(CraftMain2.class.getResource("frameIcon.gif")));
                logger.info((Object)(msg + " " + i18n.translateString("AnotherInstance") + " port:" + iPort));
                System.exit(1);
                break;
            }
            default: {
                logger.info((Object)"Another Instance not found. Can't create Server Socket Starting Craft...");
            }
        }
    }

    public void stop() {
        if (this.css != null) {
            this.css.end();
        }
    }

    private class CraftClientSocket {
        int port;

        public CraftClientSocket(int port) throws Exception {
            this.port = port;
        }

        public int talk() throws Exception {
            int ret = 0;
            Socket socket = new Socket(InetAddress.getLocalHost(), this.port);
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out.print(CraftCheckAnotherInstance.QUESTION);
            out.flush();
            int readLen = CraftCheckAnotherInstance.RESPONSE.length();
            char[] readFromServer = new char[readLen];
            if (in.read(readFromServer, 0, readLen) == readLen && CraftCheckAnotherInstance.RESPONSE.equals(String.valueOf(readFromServer))) {
                ret = 1;
                readLen = CraftCheckAnotherInstance.NOPARENT.length();
                readFromServer = new char[readLen];
                if (in.read(readFromServer, 0, readLen) == readLen && CraftCheckAnotherInstance.NOPARENT.equals(String.valueOf(readFromServer))) {
                    ret = 2;
                }
            }
            out.close();
            in.close();
            socket.close();
            return ret;
        }
    }

    public class CraftServerSocketThread
    extends Thread {
        private Socket socket;

        public CraftServerSocketThread(Socket socket) {
            super("CraftServerSocket");
            this.socket = null;
            this.socket = socket;
        }

        public void run() {
            try {
                PrintWriter out = new PrintWriter(this.socket.getOutputStream(), true);
                BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                int readLen = CraftCheckAnotherInstance.QUESTION.length();
                char[] readFromClient = new char[readLen];
                if (in.read(readFromClient, 0, readLen) == readLen && CraftCheckAnotherInstance.QUESTION.equals(String.valueOf(readFromClient))) {
                    out.print(CraftCheckAnotherInstance.RESPONSE);
                    if (CraftCheckAnotherInstance.this.parent != null && CraftCheckAnotherInstance.this.parent.isVisible()) {
                        CraftCheckAnotherInstance.this.parent.setState(0);
                        CraftCheckAnotherInstance.this.parent.toFront();
                    } else {
                        out.print(CraftCheckAnotherInstance.NOPARENT);
                    }
                }
                out.close();
                in.close();
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class CraftServerSocket
    extends Thread {
        ServerSocket serverSocket;

        public CraftServerSocket(int port) throws Exception {
            this.serverSocket = new ServerSocket(port, 0, InetAddress.getLocalHost());
        }

        public void run() {
            try {
                while (true) {
                    new CraftServerSocketThread(this.serverSocket.accept()).start();
                }
            }
            catch (SocketException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void end() {
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

