/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.configuration.info;

import com.bwanms.configuration.info.MultipleConfigPanelInfo;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.util.version.VersionDomain;
import com.bwanms.util.version.VersionFactory;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigSectionInfo {
    private String name;
    private List<ConfigSectionInfo> childSections;
    private MultipleConfigPanelInfo configPanelInfo;
    private VersionDomain versions;

    public ConfigSectionInfo(String name) {
        this(name, VersionFactory.getInstance().createUniversalDomain(), new MultipleConfigPanelInfo(name));
    }

    public ConfigSectionInfo(String name, MultipleConfigPanelInfo configPanelInfo) {
        this(name, VersionFactory.getInstance().createUniversalDomain(), configPanelInfo);
    }

    public ConfigSectionInfo(String name, VersionDomain versions) {
        this(name, versions, new MultipleConfigPanelInfo(name));
    }

    protected ConfigSectionInfo(String name, VersionDomain versions, MultipleConfigPanelInfo configPanelInfo) {
        this.name = name;
        this.versions = versions;
        this.configPanelInfo = configPanelInfo;
        this.childSections = new ArrayList<ConfigSectionInfo>();
    }

    public String getName() {
        return this.name;
    }

    public String getEquipmentClassName() {
        return null;
    }

    public List<ConfigSectionInfo> getChildSections() {
        return this.childSections;
    }

    public void addSection(ConfigSectionInfo section) {
        this.childSections.add(section);
    }

    public MultipleConfigPanelInfo getMultipleConfigPanelInfo() {
        return this.configPanelInfo;
    }

    public String toString() {
        return this.name;
    }

    public abstract boolean isDefinedFor(NetworkResourceConfiguration var1);

    public VersionDomain getVersions() {
        return this.versions;
    }
}

