/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.properties;

import com.bwanms.platform.PlatformFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class PropertiesManagerClient {
    private static final String ENV_OWARE_USER_ROOT = "OWARE_USER_ROOT";
    private static final String DIR_OWAREAPPS = "owareapps";
    private static final String PATH_TO_CONF_DIR = "etc/client/conf";
    private static PropertiesManagerClient instance;
    private Properties propsClient = new Properties();
    private Properties propsServer;

    private PropertiesManagerClient() throws Exception {
        this.loadPropertiesClient(this.propsClient);
        this.exportProperties(this.propsClient);
        this.propsServer = new Properties();
        this.loadPropertiesServer(this.propsServer);
        this.exportProperties(this.propsServer);
    }

    public static PropertiesManagerClient getInstance() throws Exception {
        if (instance == null) {
            instance = new PropertiesManagerClient();
        }
        return instance;
    }

    public Properties retrivePropertiesClient() {
        return this.propsClient;
    }

    public Properties retrivePropertiesServer() {
        return this.propsServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertiesClient(Properties props) throws Exception {
        String owareRoot = System.getenv(ENV_OWARE_USER_ROOT);
        if (owareRoot == null || owareRoot.equals("")) {
            throw new Exception("Undefined system env var OWARE_USER_ROOT");
        }
        File owappDir = new File(owareRoot, DIR_OWAREAPPS);
        if (!owappDir.isDirectory()) {
            throw new Exception("Can't find directory " + owappDir.getCanonicalPath());
        }
        try {
            for (File prjDir : owappDir.listFiles()) {
                File confDir = new File(prjDir, PATH_TO_CONF_DIR);
                if (!confDir.isDirectory()) continue;
                for (File f : confDir.listFiles()) {
                    if (!f.isFile()) continue;
                    FileInputStream inStream = null;
                    try {
                        inStream = new FileInputStream(f);
                        props.load(inStream);
                    }
                    catch (Exception e) {
                    }
                    finally {
                        if (inStream != null) {
                            try {
                                ((InputStream)inStream).close();
                            }
                            catch (Exception e) {}
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void loadPropertiesServer(Properties props) {
        Properties iProps = (Properties)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms.sar/conf/*.properties");
        props.putAll((Map<?, ?>)iProps);
    }

    private void exportProperties(Properties props) throws Exception {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

