/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.tasks.pmcollection;

import com.bwanms.client.gui.tasks.pmcollection.PMCollectionTaskGeneralPanel;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextAreaBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.performance.PMCollectionEntityTypeUtil;
import com.bwanms.ui.components.ComboItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMCollectionTaskGeneralView
extends AbstractBindedEditorView<PerformanceCollectionGenericTask> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(PMCollectionTaskGeneralView.class);
    private static final Internationalizer ddI18N = Internationalizer.getInternationalizer("com.bwanms.performance.perfTaskTranslation");
    private PMCollectionTaskGeneralPanel panel = new PMCollectionTaskGeneralPanel();
    private boolean incoming = true;

    public PMCollectionTaskGeneralView() {
        this.initUI();
    }

    private void initUI() {
        JComboBox cmbEntityType = this.panel.getCmbEntityType();
        cmbEntityType.removeAllItems();
        for (String entityType : PMCollectionEntityTypeUtil.getAvailableEntityTypes()) {
            cmbEntityType.addItem(new ComboItem(entityType, ddI18N.translateString(entityType)));
        }
        cmbEntityType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                PMCollectionTaskGeneralView.this.actionEntityTypeChanged();
            }
        });
        boolean debugMarker = false;
    }

    private void actionEntityTypeChanged() {
    }

    @Override
    public String getApplicationPermission() {
        return null;
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.task.pmcoll_editor_general";
    }

    @Override
    public JComponent getUI() {
        return this.panel;
    }

    @Override
    public String getTitle() {
        return i18n.translateString("PMCollectionTaskGeneral");
    }

    @Override
    public void fillUI(PerformanceCollectionGenericTask entity) {
        String entityType = entity.getEntityType();
        if (null == entityType) {
            return;
        }
        if (this.incoming) {
            JComboBox cmbEntityType = this.panel.getCmbEntityType();
            cmbEntityType.setEnabled(false);
            cmbEntityType.setSelectedItem(ComboItem.findItemByValue(cmbEntityType, entityType));
            this.incoming = false;
        }
    }

    @Override
    public List<InvalidValue> configureEntity(PerformanceCollectionGenericTask entityReceived) {
        List<InvalidValue> iValues = super.configureEntity(entityReceived);
        entityReceived.setEntityType((String)((ComboItem)this.panel.getCmbEntityType().getSelectedItem()).getValue());
        return iValues;
    }

    @Override
    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        binders.add(new DefaultBinder(this.getUI(), this.entity).add(new JTextFieldBinding("txtName", "name", i18n.translateString("TaskName"))).add((JTextFieldBinding)((Object)new JTextAreaBinding("txtDescription", "description", i18n.translateString("TaskDescription")))));
        return binders;
    }
}

