/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.tasks.pmcollection;

import com.bwanms.client.gui.tasks.pmcollection.PMCollectionTaskEntitiesPanel;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.model.Identifiable;
import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.performance.PMCollectionEntityTypeUtil;
import com.bwanms.performance.PerformanceCollectionEntity;
import com.bwanms.performance.PerformanceCollectionTaskHandler;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMCollectionTaskEntitiesView
extends AbstractBindedEditorView<PerformanceCollectionGenericTask> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(PMCollectionTaskEntitiesView.class);
    private static Internationalizer ddI18N = Internationalizer.getInternationalizer("com.bwanms.performance.perfTaskTranslation");
    private PMCollectionTaskEntitiesPanel panel = new PMCollectionTaskEntitiesPanel();
    PerformanceCollectionTaskHandler handler;
    EntityManagerTableModel<Serializable> entityTableModel;
    Internationalizer handlerI18n;
    private boolean incoming = true;

    public PMCollectionTaskEntitiesView() {
        this.initUI();
    }

    private void initUI() {
        this.panel.getBtnEntitiesAdd().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                PMCollectionTaskEntitiesView.this.actionAddEntities();
            }
        });
        this.panel.getBtnEntitiesRemove().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                PMCollectionTaskEntitiesView.this.actionRemoveEntities();
            }
        });
    }

    private void actionAddEntities() {
        SelectorView<? extends Serializable> selectorView = null;
        List<String> availableSelectors = this.handler.getAvailableSelectors();
        if (null != availableSelectors && availableSelectors.size() >= 2) {
            JPopupMenu popup = this.panel.getPopupAdd();
            popup.removeAll();
            for (String item : availableSelectors) {
                popup.add(new JMenuItem(new SelectEntitiesManagerAction(item)));
            }
            JButton addButton = this.panel.getBtnEntitiesAdd();
            popup.show(addButton, addButton.getX() + addButton.getSize().width / 2, addButton.getY() + addButton.getSize().height / 2);
        } else {
            selectorView = this.handler.getSelectorView(null);
            SelectorUtil.displayModalSelector(this.panel, selectorView);
            this.processAddSelection(selectorView);
        }
    }

    private void processAddSelection(SelectorView<? extends Serializable> selectorView) {
        for (Serializable serializable : selectorView.getSelection()) {
            String key = String.valueOf(((Identifiable)((Object)serializable)).getId());
            int row = this.entityTableModel.getEntityRow(key);
            if (-1 != row) {
                this.entityTableModel.updateRow(serializable, key);
                this.entityTableModel.revertRow(row);
                continue;
            }
            this.entityTableModel.addRow(serializable, key);
        }
    }

    private void actionRemoveEntities() {
        int[] selectedRows = this.panel.getTableEntities().getSelectedRows();
        this.entityTableModel.removeRows(selectedRows);
    }

    @Override
    public String getApplicationPermission() {
        return null;
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.task.pmcoll_editor_entities";
    }

    @Override
    public JComponent getUI() {
        return this.panel;
    }

    @Override
    public String getTitle() {
        return i18n.translateString("PMCollectionTaskEntities");
    }

    @Override
    public void fillUI(PerformanceCollectionGenericTask entity) {
        String entityType = entity.getEntityType();
        if (null == entityType) {
            return;
        }
        if (this.incoming) {
            boolean bEditTask;
            this.handler = PMCollectionEntityTypeUtil.createTaskHandler(entityType);
            this.handlerI18n = this.handler.getInternationalizer();
            this.initEntityTableModel();
            boolean bl = bEditTask = null != entity && null != entityType && 0 < entityType.trim().length();
            if (bEditTask) {
                for (PerformanceCollectionEntity pmEntity : entity.getEntities()) {
                    Serializable collEntity = pmEntity.getEntity();
                    if (null == collEntity) continue;
                    this.entityTableModel.addRow(collEntity, String.valueOf(((Identifiable)((Object)collEntity)).getId()));
                }
            }
            this.incoming = false;
        }
    }

    @Override
    public List<InvalidValue> configureEntity(PerformanceCollectionGenericTask entity) {
        List<InvalidValue> iValues = super.configureEntity(entity);
        ArrayList<Serializable> entityList = new ArrayList<Serializable>(this.entityTableModel.getRowCount());
        for (int row = 0; row < this.entityTableModel.getRowCount(); ++row) {
            if (1 == this.entityTableModel.getRowState(row)) continue;
            entityList.add(this.entityTableModel.getEntity(row));
        }
        entity.setCollectionEntityList(entityList, this.handler);
        if (entityList.isEmpty()) {
            if (null == iValues) {
                iValues = new ArrayList<InvalidValue>(2);
            }
            iValues.add(new InvalidValue(i18n.translateString("Selectatleastonecollectionentity"), PerformanceCollectionGenericTask.class, "Entities", (Object)"", (Object)entity));
        }
        return iValues;
    }

    private void initEntityTableModel() {
        SimpleRowTableModel.ColumnDefinition[] colDefs = new SimpleRowTableModel.ColumnDefinition[this.handler.getColumnNames().length];
        int idx = 0;
        for (String colName : this.handler.getColumnNames()) {
            colDefs[idx++] = new SimpleRowTableModel.ColumnDefinition(colName, String.class);
        }
        this.entityTableModel = new EntityManagerTableModel<Serializable>(colDefs){
            private static final long serialVersionUID = 6473181684731810540L;

            @Override
            public void setRowValues(int row, Serializable entity) {
                EntityManagerRowProvider rowProvider = PMCollectionTaskEntitiesView.this.handler.getEntityRowProvider();
                EntityManagerRow entityRow = rowProvider.createRow(entity);
                List<String> displayValues = rowProvider.getDisplayValues(entityRow);
                for (int i = 0; i < displayValues.size(); ++i) {
                    this.setInitialValueAt(displayValues.get(i), row, i);
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        new SimpleRowTable(this.panel.getTableEntities(), this.entityTableModel);
    }

    private class SelectEntitiesManagerAction
    extends AbstractAction {
        private static final long serialVersionUID = -4260621646801040095L;
        private String key;

        SelectEntitiesManagerAction(String key) {
            this.key = key;
            super.putValue("Name", PMCollectionTaskEntitiesView.this.handler.getInternationalizer().translateString(key));
        }

        public void actionPerformed(ActionEvent e) {
            SelectorView<? extends Serializable> selectorView = PMCollectionTaskEntitiesView.this.handler.getSelectorView(this.key);
            SelectorUtil.displayModalSelector(PMCollectionTaskEntitiesView.this.panel, selectorView);
            PMCollectionTaskEntitiesView.this.processAddSelection(selectorView);
        }
    }
}

