/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.tasks.pmcollection;

import com.bwanms.client.gui.tasks.pmcollection.PMCollectionTaskCountersPanel;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.performance.PMCollectionEntityTypeUtil;
import com.bwanms.performance.PerformanceCollectionLookup;
import com.bwanms.performance.PerformanceCollectionTaskHandler;
import com.bwanms.ui.components.ComboItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.ListModel;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMCollectionTaskCountersView
extends AbstractBindedEditorView<PerformanceCollectionGenericTask> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(PMCollectionTaskCountersView.class);
    private PMCollectionTaskCountersPanel panel = new PMCollectionTaskCountersPanel();
    PerformanceCollectionTaskHandler handler;
    Internationalizer handlerI18n;
    private boolean incoming = true;

    public PMCollectionTaskCountersView() {
        this.initUI();
    }

    private void initUI() {
        JComboBox cmbPollingInterval = this.panel.getCmbPollingInterval();
        cmbPollingInterval.removeAllItems();
        cmbPollingInterval.addItem(new ComboItem(1, " 1 min"));
        cmbPollingInterval.addItem(new ComboItem(3, " 3 min"));
        cmbPollingInterval.addItem(new ComboItem(5, " 5 min"));
        cmbPollingInterval.addItem(new ComboItem(15, "15 min"));
        cmbPollingInterval.setSelectedIndex(3);
        this.panel.getRadioButtonCapacity().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PMCollectionTaskCountersView.this.radioButtonCapacityActionPerformed(e);
            }
        });
        this.panel.getRadioButtonTraffic().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PMCollectionTaskCountersView.this.radioButtonTrafficActionPerformed(e);
            }
        });
        this.panel.getRadioButtonRadio().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PMCollectionTaskCountersView.this.radioButtonRadioActionPerformed(e);
            }
        });
        this.panel.getBtnCountersAdd().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                PMCollectionTaskCountersView.this.actionCountersAdd();
            }
        });
        this.panel.getListCountersLeft().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (1 == e.getButton() && e.getClickCount() >= 2) {
                    PMCollectionTaskCountersView.this.actionCountersAdd();
                }
            }
        });
        this.panel.getBtnCountersRemove().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                PMCollectionTaskCountersView.this.actionCountersRemove();
            }
        });
        this.panel.getListCountersRight().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (1 == e.getButton() && e.getClickCount() >= 2) {
                    PMCollectionTaskCountersView.this.actionCountersRemove();
                }
            }
        });
    }

    @Override
    public String getApplicationPermission() {
        return null;
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.task.pmcoll_editor_counters";
    }

    @Override
    public JComponent getUI() {
        return this.panel;
    }

    @Override
    public String getTitle() {
        return i18n.translateString("PMCollectionTaskCounters");
    }

    @Override
    public void fillUI(PerformanceCollectionGenericTask entity) {
        String entityType = entity.getEntityType();
        if (null == entityType) {
            return;
        }
        if (this.incoming) {
            this.setSelectedCountersCategoryAndPollingInterval();
            this.updateCountersTable(entity.getCounters());
            this.incoming = false;
        }
    }

    @Override
    public List<InvalidValue> configureEntity(PerformanceCollectionGenericTask entity) {
        List<InvalidValue> iValues = super.configureEntity(entity);
        entity.setCountersCategory(this.getSelectedCountersCategory());
        ComboItem selectedPollingInterval = (ComboItem)this.panel.getCmbPollingInterval().getSelectedItem();
        entity.setPollingInterval((Integer)selectedPollingInterval.getValue());
        ListModel listModel = this.panel.getListCountersRight().getModel();
        int listItemsCount = listModel.getSize();
        String[] counters = new String[listItemsCount];
        for (int i = 0; i < listItemsCount; ++i) {
            counters[i] = (String)((ComboItem)listModel.getElementAt(i)).getValue();
        }
        entity.setCounters(counters);
        if (0 == listItemsCount) {
            if (null == iValues) {
                iValues = new ArrayList<InvalidValue>(2);
            }
            iValues.add(new InvalidValue(i18n.translateString("Countersnotdefined"), PerformanceCollectionGenericTask.class, "Counters", (Object)"", (Object)entity));
        }
        return iValues;
    }

    private int getSelectedCountersCategory() {
        if (this.panel.getRadioButtonCapacity().isSelected()) {
            return 1;
        }
        if (this.panel.getRadioButtonTraffic().isSelected()) {
            return 2;
        }
        if (this.panel.getRadioButtonRadio().isSelected()) {
            return 3;
        }
        return 0;
    }

    private void setSelectedCountersCategoryAndPollingInterval() {
        JComboBox cmbPollingInterval = this.panel.getCmbPollingInterval();
        int countersCategory = ((PerformanceCollectionGenericTask)this.entity).getCountersCategory();
        block0 : switch (countersCategory) {
            case 1: {
                this.panel.getRadioButtonCapacity().setSelected(true);
                cmbPollingInterval.setEnabled(false);
                cmbPollingInterval.setSelectedIndex(3);
                break;
            }
            case 2: {
                this.panel.getRadioButtonTraffic().setSelected(true);
                cmbPollingInterval.setEnabled(false);
                cmbPollingInterval.setSelectedIndex(3);
                break;
            }
            case 3: {
                this.panel.getRadioButtonRadio().setSelected(true);
                cmbPollingInterval.setEnabled(true);
                for (int i = 0; i < cmbPollingInterval.getItemCount(); ++i) {
                    int val = (Integer)((ComboItem)cmbPollingInterval.getItemAt(i)).getValue();
                    if (val != ((PerformanceCollectionGenericTask)this.entity).getPollingInterval()) continue;
                    cmbPollingInterval.setSelectedIndex(i);
                    break block0;
                }
                break;
            }
        }
    }

    private void filterCategories(JRadioButton radio, String category) {
        boolean existsSelection = false;
        String entityType = ((PerformanceCollectionGenericTask)this.entity).getEntityType();
        PerformanceCollectionLookup countersLookup = PMCollectionEntityTypeUtil.getLookupByEntityType(entityType);
        String categories = countersLookup.get("PMCollectionCategories", category);
        if (null == categories || categories.length() == 0 || categories.equals(";")) {
            radio.setEnabled(false);
            radio.setSelected(false);
        } else if (!existsSelection) {
            existsSelection = true;
            radio.setSelected(true);
        }
    }

    private void updateCountersTable(String[] selectedCounters) {
        String entityType = ((PerformanceCollectionGenericTask)this.entity).getEntityType();
        this.handler = PMCollectionEntityTypeUtil.createTaskHandler(entityType);
        this.handlerI18n = this.handler.getInternationalizer();
        PerformanceCollectionLookup countersLookup = PMCollectionEntityTypeUtil.getLookupByEntityType(entityType);
        DefaultListModel leftListModel = new DefaultListModel();
        this.fillCountersTableRecursive(countersLookup, "PMCollectionCategories", this.getSelectedCategory(), leftListModel, null);
        this.panel.getListCountersLeft().setModel(leftListModel);
        DefaultListModel<ComboItem> rightListModel = new DefaultListModel<ComboItem>();
        if (selectedCounters != null) {
            for (String counter : selectedCounters) {
                rightListModel.addElement(new ComboItem(counter, this.handlerI18n.translateString(counter)));
            }
        }
        this.panel.getListCountersRight().setModel(rightListModel);
    }

    private String getSelectedCategory() {
        if (this.panel.getRadioButtonCapacity().isSelected()) {
            return "Capacity";
        }
        if (this.panel.getRadioButtonTraffic().isSelected()) {
            return "Traffic";
        }
        if (this.panel.getRadioButtonRadio().isSelected()) {
            return "Radio";
        }
        return null;
    }

    private void fillCountersTableRecursive(PerformanceCollectionLookup lookup, String category, String key, DefaultListModel listModel, Internationalizer internationalizer) {
        String categories = null;
        try {
            categories = null == key ? lookup.get(category) : lookup.get(category, key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null == categories || -1 == categories.indexOf(";")) {
            return;
        }
        StringTokenizer semiColonTokenizer = new StringTokenizer(categories, ";");
        while (semiColonTokenizer.hasMoreTokens()) {
            String catName = semiColonTokenizer.nextToken();
            if (catName.trim().length() <= 0) continue;
            listModel.addElement(new ComboItem(catName, this.handlerI18n.translateString(catName)));
            this.fillCountersTableRecursive(lookup, catName, null, listModel, internationalizer);
        }
    }

    private void actionCountersAdd() {
        JList listCountersLeft = this.panel.getListCountersLeft();
        Object[] leftListSelectedValues = listCountersLeft.getSelectedValues();
        if (null != leftListSelectedValues && leftListSelectedValues.length > 0) {
            DefaultListModel<Object> listModel = new DefaultListModel<Object>();
            ListModel rightListModel = this.panel.getListCountersRight().getModel();
            int rightListValuesSize = this.panel.getListCountersRight().getModel().getSize();
            ArrayList rightListValues = new ArrayList(rightListValuesSize);
            for (int i = 0; i < rightListValuesSize; ++i) {
                Object val = rightListModel.getElementAt(i);
                rightListValues.add(val);
                listModel.addElement(val);
            }
            for (Object leftCategory : leftListSelectedValues) {
                boolean found = false;
                for (Object rightCategory : rightListValues) {
                    if (!leftCategory.equals(rightCategory)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                listModel.addElement(leftCategory);
            }
            this.panel.getListCountersRight().setModel(listModel);
        }
    }

    private void actionCountersRemove() {
        int[] selectedIndices = this.panel.getListCountersRight().getSelectedIndices();
        if (selectedIndices.length > 0) {
            int i;
            ListModel crtListModel = this.panel.getListCountersRight().getModel();
            int crtListSize = crtListModel.getSize();
            DefaultListModel newListModel = new DefaultListModel();
            int j = 0;
            for (i = 0; i < crtListSize && j < selectedIndices.length; ++i) {
                if (i < selectedIndices[j]) {
                    newListModel.addElement(crtListModel.getElementAt(i));
                    continue;
                }
                ++j;
            }
            for (i = selectedIndices[selectedIndices.length - 1] + 1; i < crtListSize; ++i) {
                newListModel.addElement(crtListModel.getElementAt(i));
            }
            this.panel.getListCountersRight().setModel(newListModel);
        }
    }

    private void radioButtonCapacityActionPerformed(ActionEvent e) {
        JComboBox cmbPollingInterval = this.panel.getCmbPollingInterval();
        cmbPollingInterval.setEnabled(false);
        cmbPollingInterval.setSelectedIndex(3);
        this.updateCountersTable(null);
    }

    private void radioButtonTrafficActionPerformed(ActionEvent e) {
        JComboBox cmbPollingInterval = this.panel.getCmbPollingInterval();
        cmbPollingInterval.setEnabled(false);
        cmbPollingInterval.setSelectedIndex(3);
        this.updateCountersTable(null);
    }

    private void radioButtonRadioActionPerformed(ActionEvent e) {
        JComboBox cmbPollingInterval = this.panel.getCmbPollingInterval();
        cmbPollingInterval.setEnabled(true);
        this.updateCountersTable(null);
    }
}

