/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.tasks.pmcollection;

import com.bwanms.client.gui.tasks.pmcollection.PMCollectionTaskActionsPanel;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.model.task.PerformanceCollectionGenericTask;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMCollectionTaskActionsView
extends AbstractBindedEditorView<PerformanceCollectionGenericTask> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(PMCollectionTaskActionsView.class);
    private PMCollectionTaskActionsPanel panel = new PMCollectionTaskActionsPanel();
    private boolean incoming = true;

    public PMCollectionTaskActionsView() {
        this.initUI();
    }

    private void initUI() {
        this.panel.getRadioButtonData().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PMCollectionTaskActionsView.this.radioButtonDataActionPerformed(e);
            }
        });
        this.panel.getRadioButtonFile().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PMCollectionTaskActionsView.this.radioButtonFileActionPerformed(e);
            }
        });
        this.panel.getCbAutoExport().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PMCollectionTaskActionsView.this.cbAutoExportActionPerformed(e);
            }
        });
    }

    protected void cbAutoExportActionPerformed(ActionEvent e) {
        String exportFolderName = ((PerformanceCollectionGenericTask)this.entity).getExportFolder();
        this.panel.getTxtExportFolder().setText(this.panel.getCbAutoExport().isSelected() ? exportFolderName : "");
    }

    protected void radioButtonDataActionPerformed(ActionEvent e) {
        JCheckBox cbAutoExport = this.panel.getCbAutoExport();
        cbAutoExport.setSelected(false);
        cbAutoExport.setEnabled(false);
        this.panel.getTxtExportFolder().setText("");
    }

    protected void radioButtonFileActionPerformed(ActionEvent e) {
        JCheckBox cbAutoExport = this.panel.getCbAutoExport();
        cbAutoExport.setEnabled(true);
    }

    @Override
    public String getApplicationPermission() {
        return null;
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.task.pmcoll_editor_actions";
    }

    @Override
    public JComponent getUI() {
        return this.panel;
    }

    @Override
    public String getTitle() {
        return i18n.translateString("PMCollectionTaskActions");
    }

    @Override
    public void fillUI(PerformanceCollectionGenericTask entity) {
        String entityType = entity.getEntityType();
        if (null == entityType) {
            return;
        }
        if (this.incoming) {
            this.setSelectedStorageType();
            this.panel.getCbAutoExport().setSelected(entity.isAutoExport());
            this.incoming = false;
        }
        String exportFolderName = entity.getExportFolder();
        this.panel.getTxtExportFolder().setText(entity.isAutoExport() ? exportFolderName : "");
    }

    private void setSelectedStorageType() {
        JCheckBox cbAutoExport = this.panel.getCbAutoExport();
        int storage = ((PerformanceCollectionGenericTask)this.entity).getStorage();
        switch (storage) {
            case 1: {
                this.panel.getRadioButtonData().setSelected(true);
                cbAutoExport.setSelected(false);
                cbAutoExport.setEnabled(false);
                break;
            }
            case 2: {
                this.panel.getRadioButtonFile().setSelected(true);
                cbAutoExport.setEnabled(true);
                break;
            }
        }
    }

    @Override
    public List<InvalidValue> configureEntity(PerformanceCollectionGenericTask entity) {
        if (null == entity.getCreatedDate()) {
            entity.setCreatedDate(new Date());
        }
        entity.setStorage(this.getStorageType());
        entity.setAutoExport(this.panel.getCbAutoExport().isSelected());
        return super.configureEntity(entity);
    }

    private int getStorageType() {
        if (this.panel.getRadioButtonData().isSelected()) {
            return 1;
        }
        if (this.panel.getRadioButtonFile().isSelected()) {
            return 2;
        }
        return 0;
    }
}

