/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.selectors;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.selectors.EnumTreeSelectorPanel;
import com.bwanms.gui.selectors.MultipleEnumSelectorConfig;
import com.bwanms.model.fault.constants.AlarmType;
import com.bwanms.model.fault.constants.ConfigChangeType;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.model.fault.constants.StateChangeType;
import com.bwanms.model.fault.constants.SysEventType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTypeSelectorConfig
extends MultipleEnumSelectorConfig {
    static final Internationalizer i18n = Internationalizer.getInternationalizer(EventTypeSelectorConfig.class);
    static final Internationalizer faulti18n = Internationalizer.getInternationalizer("com.bwanms.faultConstants");

    public EventTypeSelectorConfig(Enum<?> ... args) {
        super(args);
        this.form = new EnumTreeSelectorPanel("EventType");
        this.fillUI();
    }

    @Override
    public void fillUI() {
        for (Enum eventCategory : this.constants) {
            Enum[] eventTypes = null;
            switch ((EventCategory)((Object)EventCategory.class.cast(eventCategory))) {
                case Alarm: {
                    eventTypes = AlarmType.values();
                    break;
                }
                case StateChange: {
                    eventTypes = StateChangeType.values();
                    break;
                }
                case SysEvent: {
                    eventTypes = SysEventType.values();
                    break;
                }
                case ConfigChange: {
                    eventTypes = ConfigChangeType.values();
                }
            }
            try {
                if (eventTypes == null || eventTypes.length <= 0) continue;
                ((EnumTreeSelectorPanel)this.form).addItems(eventCategory, eventTypes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<Enum<?>> getSelectedValues() {
        return ((EnumTreeSelectorPanel)this.form).getSelectedValues();
    }

    @Override
    public String getTitle() {
        return i18n.translateString("EventTypeSelector");
    }

    @Override
    public void clearSelection() {
        ((EnumTreeSelectorPanel)this.form).getTree().clearSelection();
    }
}

