/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.selectors;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.selectors.EnumListSelectorPanel;
import com.bwanms.gui.selectors.MultipleEnumSelectorConfig;
import com.bwanms.model.fault.constants.EventFilterConstantsProvider;
import com.bwanms.model.fault.constants.GenericTrap;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.ui.components.ListItem;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventNameSelectorConfig
extends MultipleEnumSelectorConfig {
    static final Internationalizer i18n = Internationalizer.getInternationalizer(EventNameSelectorConfig.class);
    static final Internationalizer faulti18n = Internationalizer.getInternationalizer("com.bwanms.faultConstants");
    private DefaultListModel listModel;

    public EventNameSelectorConfig(Enum<?> ... args) {
        super(args);
        this.form = new EnumListSelectorPanel();
        this.fillUI();
    }

    @Override
    public void fillUI() {
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.eventFilterConstantsProvider");
        this.listModel = ((EnumListSelectorPanel)this.form).getListModel();
        this.listModel.clear();
        LinkedList<ListItem> items = new LinkedList<ListItem>();
        LinkedHashSet trapTypes = new LinkedHashSet();
        try {
            for (GenericTrap genericTrap : GenericTrap.values()) {
                if (genericTrap.value() < GenericTrap.ColdStart.value() || genericTrap.value() >= GenericTrap.EnterpriseSpecific.value()) continue;
                StringBuilder name = new StringBuilder(faulti18n.translateString(genericTrap.toString())).append(" (").append(genericTrap.oid()).append(")");
                this.listModel.add(this.listModel.size(), new ListItem((Object)genericTrap, name.toString()));
            }
            if (this.constants != null) {
                for (Enum moType : this.constants) {
                    for (IConfigurationElement element : extensionPoint.getConfigurationElements()) {
                        String className = element.getAttribute("class");
                        try {
                            Class<?> clazz = Class.forName(className);
                            EventFilterConstantsProvider constProvider = (EventFilterConstantsProvider)clazz.newInstance();
                            if (!constProvider.accept(moType)) continue;
                            for (Enum<?> trapType : constProvider.getTrapTypes(moType)) {
                                trapTypes.add(trapType);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            for (Enum enum_ : trapTypes) {
                Method m2 = enum_.getClass().getMethod("value", new Class[0]);
                Integer value = (Integer)m2.invoke((Object)enum_, new Object[0]);
                if (value == Integer.MAX_VALUE) continue;
                Method m = enum_.getClass().getMethod("oid", new Class[0]);
                String oid = (String)m.invoke((Object)enum_, new Object[0]);
                StringBuilder name = new StringBuilder(faulti18n.translateString(enum_.toString())).append(" (").append(oid).append(")");
                items.add(new ListItem(enum_, name.toString()));
            }
            Collections.sort(items, new Comparator<ListItem>(){

                @Override
                public int compare(ListItem o1, ListItem o2) {
                    return o1.getText().compareToIgnoreCase(o2.getText());
                }
            });
            for (ListItem listItem : items) {
                this.listModel.add(this.listModel.size(), listItem);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<Enum<?>> getSelectedValues() {
        return ((EnumListSelectorPanel)this.form).getSelectedValues();
    }

    @Override
    public String getTitle() {
        return i18n.translateString("EventNameSelector");
    }

    @Override
    public void clearSelection() {
        ((EnumListSelectorPanel)this.form).getList().clearSelection();
    }
}

