/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.selectors;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.selectors.EnumListSelectorPanel;
import com.bwanms.gui.selectors.MultipleEnumSelectorConfig;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.ui.components.ListItem;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.DefaultListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventCategorySelectorConfig
extends MultipleEnumSelectorConfig {
    static final Internationalizer i18n = Internationalizer.getInternationalizer(EventCategorySelectorConfig.class);
    static final Internationalizer faulti18n = Internationalizer.getInternationalizer("com.bwanms.faultConstants");

    public EventCategorySelectorConfig() {
        super(new Enum[0]);
        this.form = new EnumListSelectorPanel();
        this.fillUI();
    }

    @Override
    public void fillUI() {
        DefaultListModel listModel = ((EnumListSelectorPanel)this.form).getListModel();
        listModel.clear();
        try {
            for (EventCategory eventCategory : EventCategory.values()) {
                Method m2 = ((Object)((Object)eventCategory)).getClass().getMethod("value", new Class[0]);
                Integer value = (Integer)m2.invoke((Object)eventCategory, new Object[0]);
                if (value == Integer.MAX_VALUE) continue;
                StringBuilder name = new StringBuilder(faulti18n.translateString(eventCategory.toString()));
                listModel.add(listModel.size(), new ListItem((Object)eventCategory, name.toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<Enum<?>> getSelectedValues() {
        return ((EnumListSelectorPanel)this.form).getSelectedValues();
    }

    @Override
    public String getTitle() {
        return i18n.translateString("EventCategorySelector");
    }

    @Override
    public void clearSelection() {
        ((EnumListSelectorPanel)this.form).getList().clearSelection();
    }
}

