/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.templates;

import com.bwanms.client.gui.fault.templates.EventTemplateEditorContainer;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.entitymanager.EntityQueryStrategy;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.gui.manager.DefaultRowCreator;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.SimpleEntityQueryStrategy;
import com.bwanms.model.fault.EventTemplate;
import com.bwanms.security.Security;
import com.bwanms.services.EntityManagerService;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ServerValidationException;
import com.bwanms.util.fault.TemplateUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTemplatesManagerConfig
extends EntityManagerConfig {
    private static final Logger log = Logger.getLogger(EventTemplatesManagerConfig.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(EventTemplatesManagerConfig.class);
    private static final Internationalizer i18nTask = Internationalizer.getInternationalizer("com.bwanms.tasks");
    private static String[] columnNames = new String[]{"Name", "Description", "Owner", "CreationDate", "Priority"};
    private static String[] columnAttribNames = new String[]{"name", "description", "owner", "creationDate", "priority"};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public EventTemplatesManagerConfig() {
        for (int i = 0; i < columnNames.length; ++i) {
            this.columns.add(new EntityManagerColumn(columnNames[i], columnAttribNames[i], i18n.translateString(columnNames[i]), new EntityManagerRowDisplayComparator(i)));
        }
        this.filterCriteria = new Vector();
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("Name"), "name", 1, 1, null, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("Owner"), "owner", 1, 1, null, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("Priority"), "priority", 1, 1, null, false));
        this.entityRowProvider = new EventTemplateManagerRowProvider(EventTemplatesManagerConfig.getColumnAttributeNames(this.columns));
        this.declaredActions = new Vector<ManagerAction>();
        this.declaredActions.add(new EventTemplateManagerAction("New", 1));
        this.defaultAction = new EventTemplateManagerAction("Edit", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new EventTemplateManagerAction("Delete", 1));
    }

    @Override
    protected String getBaseName() {
        return EventTemplate.class.getName();
    }

    @Override
    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    @Override
    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    @Override
    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    @Override
    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.fm.event_template_manager";
    }

    @Override
    public String getTitle() {
        return i18n.translateString("EventTemplatesManager");
    }

    @Override
    public EntityQueryStrategy getQueryStrategy() {
        return new SimpleEntityQueryStrategy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventTemplateManagerRowProvider
    extends DefaultRowCreator {
        public EventTemplateManagerRowProvider(List<String> attributes) {
            super(attributes);
        }

        @Override
        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List<String> ret = super.getDisplayValues(entityRow);
            EventTemplate evtTempl = (EventTemplate)entityRow.getEntity();
            ret.set(3, TemplateUtil.formatCreationDate(evtTempl.getCreationDate()));
            return ret;
        }

        @Override
        public String readEntityId(Serializable entity) {
            return String.valueOf(((EventTemplate)entity).getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventTemplateManagerAction
    extends ManagerAction {
        private EntitiesSelectedCallback selectorListener;

        public EventTemplateManagerAction(String name, int category) {
            this(name, category, null);
        }

        public EventTemplateManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.name = name;
            this.category = category;
            this.selectorListener = selectorListener;
        }

        @Override
        public void performAction(final ManagerView manager) {
            final List<Serializable> selection = manager.getSelection();
            if ("New".equals(this.name)) {
                try {
                    EventTemplate eventTempl = new EventTemplate();
                    eventTempl.setCreationDate(System.currentTimeMillis());
                    eventTempl.setOwner(Security.getSecurity().getCurrentUserId());
                    eventTempl.setPriority(1L);
                    new EventTemplateEditorContainer(eventTempl, (EntityChangeListener<Serializable>)((EntityChangeListener)((Object)manager)));
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(manager.getUI(), ex.getMessage());
                }
            } else if ("Edit".equals(this.name) && 1 == selection.size()) {
                EventTemplate eventTemplate = (EventTemplate)selection.get(0);
                try {
                    if (!TemplateUtil.checkOwner(eventTemplate, false)) {
                        MessageBox.Alert.quickShow(manager.getUI(), i18n.translateString("CannotEditTemplate", eventTemplate.getName()) + "\n" + i18n.translateString("YouAreNotOwner"));
                        return;
                    }
                    new EventTemplateEditorContainer(eventTemplate, (EntityChangeListener<Serializable>)((EntityChangeListener)((Object)manager)));
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(manager.getUI(), ex.getMessage());
                }
            } else if ("Delete".equals(this.name) && !selection.isEmpty()) {
                if (!MessageBox.WarnConfirm.showResult(manager.getUI(), null, i18n.translateString("DeleteConfirmationTitle"))) {
                    return;
                }
                AbstractLongOperation deleteOperation = new AbstractLongOperation(){

                    public String getTitle() {
                        return i18n.translateString("DeleteTitle");
                    }

                    public boolean isCancelable() {
                        return true;
                    }

                    public long getMaxProgress() {
                        return selection.size();
                    }

                    public void run() {
                        long progress = 0L;
                        EntityManagerService eventTemplateService = ServiceRegistry.getEntityManagerService();
                        EntityChangeListener listener = null;
                        if (manager instanceof EntityChangeListener) {
                            listener = (EntityChangeListener)((Object)manager);
                        }
                        for (Serializable row : selection) {
                            if (this.shouldCancel) {
                                this.monitor.logMessage(i18n.translateString("Canceled"));
                                break;
                            }
                            EventTemplate eventTemplate = (EventTemplate)row;
                            String eventTemplateName = eventTemplate.getName();
                            String message = i18n.translateString("DeletingEventTemplate", eventTemplateName);
                            this.monitor.updateProgress(progress, message);
                            if (!TemplateUtil.checkOwner(eventTemplate, true)) {
                                this.monitor.logMessage(i18n.translateString("CannotDeleteNotOwner", eventTemplateName));
                                this.monitor.updateProgress(++progress, message);
                                continue;
                            }
                            try {
                                eventTemplateService.delete(eventTemplate);
                                ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "EntityDelete", "EventTemplateManager", eventTemplate.getName(), eventTemplate.getClass().getName());
                                if (listener != null) {
                                    listener.entityRemoved(row);
                                }
                                this.monitor.logMessage(i18n.translateString("SuccesfullyDeleted", eventTemplateName));
                                log.debug((Object)("Deleted EventTemplate: " + eventTemplateName));
                            }
                            catch (ServerValidationException e) {
                                this.monitor.logMessage(i18n.translateString("DeletingError", eventTemplateName, e.getInvalidValues().get(0).getMessage()));
                                log.debug((Object)"Failed to delete EventTemplate.", (Throwable)e);
                            }
                            catch (Exception e) {
                                this.monitor.logMessage(i18n.translateString("DeletingError", eventTemplateName, e.getMessage()));
                                log.debug((Object)"Failed to delete EventTemplate.", (Throwable)e);
                            }
                            this.monitor.updateProgress(++progress, message);
                        }
                        this.monitor.operationCompleted(false);
                    }
                };
                LongOperationUtil.startDetailLongOperationDialog(manager.getUI(), deleteOperation);
            } else if ("Select".equals(this.name) && 1 == selection.size()) {
                this.selectorListener.entitiesSelected(manager.getSelection());
            }
        }

        @Override
        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (!this.name.equals("New")) {
                if (this.name.equals("Edit")) {
                    return 1 == selectionSize;
                }
                if (this.name.equals("Delete")) {
                    return selectionSize > 0;
                }
                if (this.name.equals("Select")) {
                    return 1 == selectionSize;
                }
            }
            return true;
        }
    }
}

