/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.templates;

import com.bwanms.client.gui.fault.templates.EventTemplateEditorPanel;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.JTextAreaBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.model.Contact;
import com.bwanms.model.Equipment;
import com.bwanms.model.Location;
import com.bwanms.model.entity.LightQuery;
import com.bwanms.model.fault.Command;
import com.bwanms.model.fault.EventTemplate;
import com.bwanms.model.fault.EventTemplateBehavior;
import com.bwanms.model.fault.EventTemplateFilter;
import com.bwanms.model.fault.EvtTmplFilterEquipment;
import com.bwanms.model.fault.EvtTmplFilterEventCategory;
import com.bwanms.model.fault.EvtTmplFilterEventType;
import com.bwanms.model.fault.EvtTmplFilterEvtOID;
import com.bwanms.model.fault.EvtTmplFilterLocation;
import com.bwanms.model.fault.EvtTmplFilterMOAlias;
import com.bwanms.model.fault.EvtTmplFilterMOInst;
import com.bwanms.model.fault.EvtTmplFilterMOType;
import com.bwanms.model.fault.EvtTmplFilterNEType;
import com.bwanms.model.fault.EvtTmplFilterSeverity;
import com.bwanms.model.fault.constants.AlarmType;
import com.bwanms.model.fault.constants.ConfigChangeType;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.model.fault.constants.StateChangeType;
import com.bwanms.model.fault.constants.SysEventType;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.FormUtil;
import com.bwanms.util.PluginUtil;
import com.bwanms.util.fault.FilterUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTemplateView
extends AbstractBindedEditorView<EventTemplate> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(EventTemplateEditorPanel.class);
    private EventTemplateEditorPanel panel = new EventTemplateEditorPanel();

    @Override
    public String getApplicationPermission() {
        return null;
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.fm.event_template_editor";
    }

    @Override
    public String getTitle() {
        return i18n.translateString("EventTemplate");
    }

    @Override
    public JComponent getUI() {
        return this.panel;
    }

    @Override
    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        binders.add(new DefaultBinder(this.panel.getPnlGeneral(), this.entity).add(new JTextFieldBinding("txtName", "name", i18n.translateString("Name"))));
        binders.add(new DefaultBinder(this.panel.getPnlGeneral(), this.entity).add(new JTextFieldBinding("txtDescription", "description")));
        binders.add(new DefaultBinder(this.panel.getPnlGeneral(), this.entity).add(new JSpinnerBinding("spnPriority", "priority")));
        binders.add(new ReadOnlyBinder(this.panel.getPnlGeneral(), this.entity).add(new JTextFieldBinding("txtOwner", "owner")));
        binders.add(new DefaultBinder(this.panel.getPnlBehavior().getPnlBehaviorActions(), ((EventTemplate)this.entity).getBehavior()).add(new JTextAreaBinding("txtAdvisorMessage", "advisorMessage")));
        return binders;
    }

    @Override
    public List<InvalidValue> configureEntity(EventTemplate entity) {
        List<InvalidValue> invalidValues = super.configureEntity(entity);
        EventTemplateFilter filter = entity.getFilter();
        filter.removeNeTypes();
        List listNETypes = (List)this.panel.getSelectorNEType().getValue();
        if (listNETypes != null) {
            for (Enum neTypeEnum : listNETypes) {
                try {
                    Method m = neTypeEnum.getClass().getMethod("value", new Class[0]);
                    Byte moValue = ((Integer)m.invoke((Object)neTypeEnum, new Object[0])).byteValue();
                    filter.addNeTypes(new EvtTmplFilterNEType(filter, moValue));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        filter.removeEventCategories();
        List listEventCategories = (List)this.panel.getSelectorEventCategory().getValue();
        if (listEventCategories != null) {
            for (Enum eventCategoryEnum : listEventCategories) {
                try {
                    Method m = eventCategoryEnum.getClass().getMethod("value", new Class[0]);
                    Byte eventTypeValue = ((Integer)m.invoke((Object)eventCategoryEnum, new Object[0])).byteValue();
                    filter.addEventCategory(new EvtTmplFilterEventCategory(filter, eventTypeValue));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        filter.removeEventTypes();
        List listEventTypes = (List)this.panel.getSelectorEventType().getValue();
        if (listEventTypes != null) {
            for (Enum eventTypeEnum : listEventTypes) {
                try {
                    Method m = eventTypeEnum.getClass().getMethod("value", new Class[0]);
                    Byte eventTypeValue = ((Integer)m.invoke((Object)eventTypeEnum, new Object[0])).byteValue();
                    filter.addEventType(new EvtTmplFilterEventType(filter, eventTypeValue));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        filter.removeMoTypes();
        List listMoTypes = (List)this.panel.getPnlFilter().getEvtFilterNETypeCriteriaPanel().getSelectorResultMOType().getValue();
        if (listMoTypes != null) {
            for (Enum moTypeEnum : listMoTypes) {
                try {
                    Method m = moTypeEnum.getClass().getMethod("value", new Class[0]);
                    Byte moValue = ((Integer)m.invoke((Object)moTypeEnum, new Object[0])).byteValue();
                    filter.addMoType(new EvtTmplFilterMOType(filter, moValue));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        filter.removeMoInstances();
        String st = new String(this.panel.getPnlFilter().getEvtFilterNETypeCriteriaPanel().getTxtMOInstance().getText());
        String[] moInstances = null;
        if (st.compareTo("") != 0) {
            moInstances = st.split(",");
        }
        if (moInstances != null) {
            for (String moInst : moInstances) {
                filter.addMoInstance(new EvtTmplFilterMOInst(filter, moInst));
            }
        }
        filter.removeMoAliases();
        String stAlias = new String(this.panel.getPnlFilter().getEvtFilterNETypeCriteriaPanel().getTxtMOAlias().getText());
        String[] moAliases = null;
        if (stAlias.compareTo("") != 0) {
            moAliases = stAlias.split(",");
        }
        if (moAliases != null) {
            for (String moAlias : moAliases) {
                filter.addMoAlias(new EvtTmplFilterMOAlias(filter, moAlias));
            }
        }
        filter.removeEventOIDs();
        List listOID = (List)this.panel.getPnlFilter().getEvtFilterNETypeCriteriaPanel().getSelectorResultTrapName().getValue();
        if (listOID != null) {
            for (Enum oidEnum : listOID) {
                try {
                    Method m = oidEnum.getClass().getMethod("oid", new Class[0]);
                    String oidValue = (String)m.invoke((Object)oidEnum, new Object[0]);
                    filter.addEventOID(new EvtTmplFilterEvtOID(filter, oidValue));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        filter.removeSeverities();
        for (Integer severityValue : this.panel.getPnlFilter().getEvtFilterEventCriteriaPanel().getSelectedSeverities()) {
            filter.addSeverity(new EvtTmplFilterSeverity(filter, severityValue.byteValue()));
        }
        for (Enum eventCateg : listEventCategories) {
            if (EventCategory.Alarm.equals(eventCateg)) continue;
            filter.addSeverity(new EvtTmplFilterSeverity(filter, Severity.Other.byteValue()));
            break;
        }
        filter.getLocations().clear();
        List listLocation = (List)this.panel.getPnlFilter().getEvtFilterTopologyCriteriaPanel().getSelectorLocations().getValue();
        if (listLocation != null) {
            for (Location location : listLocation) {
                filter.addLocation(new EvtTmplFilterLocation(filter, location.getId()));
            }
        }
        filter.getNetworkElements().clear();
        List listNENames = (List)this.panel.getPnlFilter().getEvtFilterTopologyCriteriaPanel().getSelectorNEList().getValue();
        if (listNENames != null) {
            for (Equipment neName : listNENames) {
                filter.addNetworkElement(new EvtTmplFilterEquipment(filter, neName.getId()));
            }
        }
        EventTemplateBehavior behavior = entity.getBehavior();
        behavior.setAlarmSeverity((Byte)FormUtil.getSelectedValue(this.panel.getPnlBehavior().getPnlBehaviorActions().getCmbAlarmSeverity()));
        List listCommands = (List)this.panel.getPnlBehavior().getPnlBehaviorActions().getSelectorCommands().getValue();
        if (listCommands != null) {
            behavior.setScriptCommand((Command)listCommands.get(0));
        } else {
            behavior.setScriptCommand(null);
        }
        behavior.setAckRequired(this.panel.getPnlBehavior().getPnlBehaviorActions().getChkRequiresAck().isSelected());
        behavior.setAudible(this.panel.getPnlBehavior().getPnlBehaviorActions().getChkAudible().isSelected());
        String str = (String)FormUtil.getSelectedValue(this.panel.getPnlBehavior().getPnlBehaviorActions().getCmbUserClassifier());
        behavior.setUserClassifier(str);
        behavior.getContacts().clear();
        List listContacts = (List)this.panel.getPnlBehavior().getPnlBehaviorEmail().getSelectorContactsEMail().getValue();
        if (listContacts != null) {
            behavior.setContacts(new HashSet<Contact>(listContacts));
        }
        behavior.setAutoSendEmail(this.panel.getPnlBehavior().getPnlBehaviorEmail().getChkAutoSendEmail().isSelected());
        behavior.setEMailSubject(FormUtil.getText(this.panel.getPnlBehavior().getPnlBehaviorEmail().getTxtSubject()));
        behavior.setEMailMessage(FormUtil.getText(this.panel.getPnlBehavior().getPnlBehaviorEmail().getTxtMessage()));
        return invalidValues;
    }

    @Override
    public void fillUI(EventTemplate entity) {
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.eventFilterConstantsProvider");
        this.panel.getPnlGeneral().getTxtCreationDate().setText(FilterUtil.formatCreationDate(entity.getCreationDate()));
        EventTemplateFilter filter = entity.getFilter();
        StringBuffer buf = new StringBuffer();
        for (EvtTmplFilterMOInst moInst : filter.getMoInstances()) {
            String moInstVal = new String(moInst.getMoInst());
            buf.append(moInstVal).append(",");
        }
        this.panel.getPnlFilter().getEvtFilterNETypeCriteriaPanel().getTxtMOInstance().setText(buf.toString());
        StringBuffer bufAlias = new StringBuffer();
        for (EvtTmplFilterMOAlias moAlias : filter.getMoAliases()) {
            String moAliasVal = new String(moAlias.getMoAlias());
            bufAlias.append(moAliasVal).append(",");
        }
        this.panel.getPnlFilter().getEvtFilterNETypeCriteriaPanel().getTxtMOAlias().setText(bufAlias.toString());
        ArrayList listNETypesEnums = new ArrayList();
        for (EvtTmplFilterNEType neType : filter.getNeTypes()) {
            Integer neTypeValue = new Integer(neType.getNeType());
            Enum<?> enumClass = PluginUtil.returnSavedNETypeEnum(extensionPoint, neTypeValue);
            if (enumClass == null) continue;
            listNETypesEnums.add(enumClass);
        }
        this.panel.getPnlFilter().getEvtFilterNETypeCriteriaPanel().getSelectorResultNEType().setValue(listNETypesEnums);
        Enum[] neTypesArray = new Enum[listNETypesEnums.size()];
        int k = 0;
        Iterator i$ = listNETypesEnums.iterator();
        while (i$.hasNext()) {
            Enum neTypeEnum;
            neTypesArray[k] = neTypeEnum = (Enum)i$.next();
            ++k;
        }
        ArrayList listSingleMOTypes = new ArrayList();
        int[] moTypeValues = new int[filter.getMoTypes().size()];
        int i = 0;
        for (EvtTmplFilterMOType eventMOType : filter.getMoTypes()) {
            byte moType = eventMOType.getMoType();
            Integer evtMOType = new Integer(FilterUtil.fixMoTypeValue(moType));
            moTypeValues[i] = evtMOType;
            ++i;
            Enum<?> moTypeEnumClass = PluginUtil.returnSavedMOTypeEnum(extensionPoint, evtMOType);
            if (moTypeEnumClass == null) continue;
            listSingleMOTypes.add(moTypeEnumClass);
        }
        if (neTypesArray == null || neTypesArray.length == 0) {
            this.panel.getPnlFilter().getEvtFilterNETypeCriteriaPanel().getSelectorResultMOType().setValue(listSingleMOTypes);
        } else {
            List<Enum<?>> listMOTypeEnums = PluginUtil.getMOTypeEnums(moTypeValues, neTypesArray);
            this.panel.getPnlFilter().getEvtFilterNETypeCriteriaPanel().getSelectorResultMOType().setValue(listMOTypeEnums);
        }
        ArrayList<EventCategory> listEventCategoriesEnums = new ArrayList<EventCategory>();
        for (EvtTmplFilterEventCategory eventCategory : filter.getEventCategories()) {
            for (EventCategory eventCat : EventCategory.values()) {
                if (eventCategory.getEventCategory() != eventCat.byteValue()) continue;
                listEventCategoriesEnums.add(eventCat);
            }
        }
        this.panel.getSelectorEventCategory().setValue(listEventCategoriesEnums);
        Enum[] evtCatArray = new Enum[listEventCategoriesEnums.size()];
        int l = 0;
        for (EventCategory evtCatEnum : listEventCategoriesEnums) {
            evtCatArray[l] = evtCatEnum;
            ++l;
        }
        ArrayList<Enum> listEvtTypeEnums = new ArrayList<Enum>();
        for (EvtTmplFilterEventType eventEvtType : filter.getEventTypes()) {
            AlarmType alarmType = AlarmType.fromValue(eventEvtType.getEventType());
            if (alarmType != AlarmType.unexpectedValue) {
                listEvtTypeEnums.add(alarmType);
                continue;
            }
            StateChangeType stateChangeType = StateChangeType.fromValue(eventEvtType.getEventType());
            if (stateChangeType != StateChangeType.unexpectedValue) {
                listEvtTypeEnums.add(stateChangeType);
                continue;
            }
            SysEventType sysEventType = SysEventType.fromValue(eventEvtType.getEventType());
            if (sysEventType != SysEventType.unexpectedValue) {
                listEvtTypeEnums.add(sysEventType);
                continue;
            }
            ConfigChangeType configChangeType = ConfigChangeType.fromValue(eventEvtType.getEventType());
            if (configChangeType == ConfigChangeType.unexpectedValue) continue;
            listEvtTypeEnums.add(configChangeType);
        }
        this.panel.getSelectorEventType().setValue(listEvtTypeEnums);
        ArrayList listOIDEnums = new ArrayList();
        for (EvtTmplFilterEvtOID eventOid : filter.getEventOIDs()) {
            String evtOID = eventOid.getEventOID();
            Enum<?> enumClass = PluginUtil.returnSavedOIDEnums(extensionPoint, evtOID);
            if (enumClass == null) continue;
            listOIDEnums.add(enumClass);
        }
        this.panel.getPnlFilter().getEvtFilterNETypeCriteriaPanel().getSelectorResultTrapName().setValue(listOIDEnums);
        ArrayList<Location> listLocation = new ArrayList<Location>();
        for (EvtTmplFilterLocation locationTmpl : filter.getLocations()) {
            LightQuery<Location> query = new LightQuery<Location>(Location.class);
            query.addParameter("id", new Long(locationTmpl.getLocationID()).intValue());
            List<Location> locations = ServiceRegistry.getEntityManagerService().retrieveByQuery(query);
            listLocation.addAll(locations);
        }
        this.panel.getPnlFilter().getEvtFilterTopologyCriteriaPanel().getSelectorLocations().setValue(listLocation);
        ArrayList<Equipment> listEquipment = new ArrayList<Equipment>();
        for (EvtTmplFilterEquipment equipmentTmpl : filter.getNetworkElements()) {
            LightQuery<Equipment> query = new LightQuery<Equipment>(Equipment.class);
            query.addParameter("id", new Long(equipmentTmpl.getEquipmentID()).intValue());
            List<Equipment> equipments = ServiceRegistry.getEntityManagerService().retrieveByQuery(query);
            listEquipment.addAll(equipments);
        }
        this.panel.getPnlFilter().getEvtFilterTopologyCriteriaPanel().getSelectorNEList().setValue(listEquipment);
        ArrayList<Integer> severityValues = new ArrayList<Integer>();
        for (EvtTmplFilterSeverity severity : filter.getSeverities()) {
            severityValues.add(new Integer(severity.getSeverity()));
        }
        this.panel.getPnlFilter().getEvtFilterEventCriteriaPanel().setSelectedSeverities(severityValues);
        EventTemplateBehavior behavior = entity.getBehavior();
        FormUtil.setSelectedValue(this.panel.getPnlBehavior().getPnlBehaviorActions().getCmbAlarmSeverity(), behavior.getAlarmSeverity());
        this.panel.getPnlBehavior().getPnlBehaviorActions().getChkRequiresAck().setSelected(behavior.isAckRequired());
        FormUtil.setSelectedValue(this.panel.getPnlBehavior().getPnlBehaviorActions().getCmbUserClassifier(), behavior.getUserClassifier());
        ArrayList<Command> value = new ArrayList<Command>();
        value.add(behavior.getScriptCommand());
        this.panel.getPnlBehavior().getPnlBehaviorActions().getSelectorCommands().setValue(value);
        ArrayList<Contact> listContacts = new ArrayList<Contact>();
        for (Contact contact : behavior.getContacts()) {
            listContacts.add(contact);
        }
        this.panel.getPnlBehavior().getPnlBehaviorEmail().getSelectorContactsEMail().setValue(listContacts);
        this.panel.getPnlBehavior().getPnlBehaviorEmail().getChkAutoSendEmail().setSelected(behavior.isAutoSendEmail());
        this.panel.getPnlBehavior().getPnlBehaviorEmail().getTxtSubject().setText(behavior.getEMailSubject());
        this.panel.getPnlBehavior().getPnlBehaviorEmail().getTxtMessage().setText(behavior.getEMailMessage());
        super.fillUI(entity);
    }
}

