/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.templates;

import com.bwanms.client.gui.fault.templates.EventTemplateView;
import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.editor.EntityEditorContainer;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.model.entity.LightQuery;
import com.bwanms.model.fault.EventTemplate;
import com.bwanms.security.Security;
import com.bwanms.services.EntityAlreadyExistsException;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ServerValidationException;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTemplateEditorContainer
extends EntityEditorContainer<EventTemplate> {
    private static final Logger log = Logger.getLogger(EventTemplateEditorContainer.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(EventTemplateEditorContainer.class);

    public EventTemplateEditorContainer(EventTemplate entity, EntityChangeListener<Serializable> listener) throws ServiceException {
        super(entity, listener);
    }

    @Override
    protected String getEntityClass() {
        return i18n.translateString(EventTemplate.class.getName());
    }

    @Override
    public String getEntityId() {
        return String.valueOf(((EventTemplate)this.getEntity()).getId());
    }

    @Override
    protected String getEntityName() {
        return this.getEntity() != null ? ((EventTemplate)this.getEntity()).getName() : "null";
    }

    @Override
    public String getTitle() {
        return i18n.translateString("EventTemplateEditor");
    }

    @Override
    protected EditorView<EventTemplate> initView() {
        return new EventTemplateView();
    }

    @Override
    protected void saveEntity() throws ServiceException {
        try {
            super.saveEntity();
            ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), this.entityIsNew ? "EntityCreate" : "EntityChange", "EventTemplateManager", ((EventTemplate)this.entity).getName(), ((EventTemplate)this.entity).getClass().getName());
        }
        catch (EntityAlreadyExistsException e) {
            this.invalidValues.add(new InvalidValue(i18n.translateString("EventTemplateWithTheSameNameIsAlreadyDefined"), EventTemplate.class, i18n.translateString("Name"), (Object)e.getMessage(), null));
            throw new ServerValidationException(this.invalidValues);
        }
    }

    @Override
    protected boolean beforeSave() {
        return this.checkUniquePriority();
    }

    private boolean checkUniquePriority() {
        try {
            LightQuery<EventTemplate> query = new LightQuery<EventTemplate>(EventTemplate.class);
            query.addParameter("priority", ((EventTemplate)this.entity).getPriority());
            List<EventTemplate> list = ServiceRegistry.getEntityManagerService().retrieveByQuery(query);
            if (list != null && !list.isEmpty()) {
                for (EventTemplate tmpl : list) {
                    if (tmpl.getId() == ((EventTemplate)this.entity).getId()) continue;
                    return MessageBox.WarnConfirm2.showResult(this.view.getUI(), i18n.translateString("TemplateWithSamePriorityAlreadyDefined"));
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)("Failed to check unique priority for template : " + ((EventTemplate)this.entity).getName()));
        }
        return true;
    }
}

