/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.nbi.policies;

import com.bwanms.client.gui.fault.nbi.policies.NbiPolicyEditorPanel;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.model.Equipment;
import com.bwanms.model.Location;
import com.bwanms.model.entity.LightQuery;
import com.bwanms.model.fault.constants.AlarmType;
import com.bwanms.model.fault.constants.ConfigChangeType;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.model.fault.constants.StateChangeType;
import com.bwanms.model.fault.constants.SysEventType;
import com.bwanms.model.fault.nbi.NbiPolicy;
import com.bwanms.model.fault.nbi.NbiPolicyFilterEquipment;
import com.bwanms.model.fault.nbi.NbiPolicyFilterEventCategory;
import com.bwanms.model.fault.nbi.NbiPolicyFilterEventType;
import com.bwanms.model.fault.nbi.NbiPolicyFilterEvtOID;
import com.bwanms.model.fault.nbi.NbiPolicyFilterLocation;
import com.bwanms.model.fault.nbi.NbiPolicyFilterMOAlias;
import com.bwanms.model.fault.nbi.NbiPolicyFilterMOInst;
import com.bwanms.model.fault.nbi.NbiPolicyFilterMOType;
import com.bwanms.model.fault.nbi.NbiPolicyFilterNEType;
import com.bwanms.model.fault.nbi.NbiPolicyFilterSeverity;
import com.bwanms.model.fault.nbi.NbiPolicyTimeDays;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.FormUtil;
import com.bwanms.util.PluginUtil;
import com.bwanms.util.fault.FilterUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NbiPolicyView
extends AbstractBindedEditorView<NbiPolicy> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(NbiPolicyView.class);
    private static Calendar cal = Calendar.getInstance();
    private NbiPolicyEditorPanel panel = new NbiPolicyEditorPanel();

    @Override
    public String getApplicationPermission() {
        return null;
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.fm.nbi.nbi_policy_editor";
    }

    @Override
    public String getTitle() {
        return i18n.translateString("NbiPolicyView");
    }

    @Override
    public JComponent getUI() {
        return this.panel;
    }

    @Override
    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        DefaultBinder binder = new DefaultBinder(this.panel.getNbiPolicyGeneralPanel(), this.entity);
        binder.add(new JTextFieldBinding("txtName", "name", i18n.translateString("NbiName")));
        binder.add(new JTextFieldBinding("txtDesc", "description", i18n.translateString("NbiDescription")));
        binders.add(binder);
        return binders;
    }

    @Override
    public List<InvalidValue> configureEntity(NbiPolicy nbiPolicy) {
        NbiPolicyFilterSeverity severity;
        List<InvalidValue> invalidValues = super.configureEntity(this.entity);
        nbiPolicy.setEnabled((byte)(this.panel.getNbiPolicyGeneralPanel().getChkEnabled().isSelected() ? 1 : 0));
        NbiPolicy.NbiPolicyFilter filter = nbiPolicy.getPolicyFilter();
        filter.removeNETypes();
        List listNETypes = (List)this.panel.getNbiPolicyFilterPanel().getEvtFilterNETypeCriteriaPanel().getSelectorResultNEType().getValue();
        if (listNETypes != null) {
            for (Enum neTypeEnum : listNETypes) {
                try {
                    Method m = neTypeEnum.getClass().getMethod("value", new Class[0]);
                    Byte moValue = ((Integer)m.invoke((Object)neTypeEnum, new Object[0])).byteValue();
                    filter.addNETypes(new NbiPolicyFilterNEType((NbiPolicy)this.entity, moValue));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        filter.removeEventCategories();
        List listEvtCategories = (List)this.panel.getNbiPolicyFilterPanel().getEvtFilterEventCriteriaPanel().getSelectorEventCategory().getValue();
        if (listEvtCategories != null) {
            for (Enum evtCatEnum : listEvtCategories) {
                try {
                    Method m = evtCatEnum.getClass().getMethod("value", new Class[0]);
                    Byte evtCatValue = ((Integer)m.invoke((Object)evtCatEnum, new Object[0])).byteValue();
                    filter.addEventCategories(new NbiPolicyFilterEventCategory((NbiPolicy)this.entity, evtCatValue));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        filter.removeEventTypes();
        List listEventTypes = (List)this.panel.getNbiPolicyFilterPanel().getEvtFilterEventCriteriaPanel().getSelectorEventType().getValue();
        if (listEventTypes != null) {
            for (Enum evtTypeEnum : listEventTypes) {
                try {
                    Method m = evtTypeEnum.getClass().getMethod("value", new Class[0]);
                    Byte evtTypeValue = ((Integer)m.invoke((Object)evtTypeEnum, new Object[0])).byteValue();
                    filter.addEventTypes(new NbiPolicyFilterEventType((NbiPolicy)this.entity, evtTypeValue));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        filter.removeEventOIDs();
        List listOID = (List)this.panel.getNbiPolicyFilterPanel().getEvtFilterNETypeCriteriaPanel().getSelectorResultTrapName().getValue();
        if (listOID != null) {
            for (Enum oidEnum : listOID) {
                try {
                    Method m = oidEnum.getClass().getMethod("oid", new Class[0]);
                    String oidValue = (String)m.invoke((Object)oidEnum, new Object[0]);
                    filter.addEventOID(new NbiPolicyFilterEvtOID((NbiPolicy)this.entity, oidValue));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        filter.removeMoTypes();
        List listMOtypes = (List)this.panel.getNbiPolicyFilterPanel().getEvtFilterNETypeCriteriaPanel().getSelectorResultMOType().getValue();
        if (listMOtypes != null) {
            for (Enum oidEnum : listMOtypes) {
                try {
                    Method m = oidEnum.getClass().getMethod("value", new Class[0]);
                    Byte moValue = ((Integer)m.invoke((Object)oidEnum, new Object[0])).byteValue();
                    filter.addMoType(new NbiPolicyFilterMOType((NbiPolicy)this.entity, moValue));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        filter.removeMoInstances();
        String st = new String(this.panel.getNbiPolicyFilterPanel().getEvtFilterNETypeCriteriaPanel().getTxtMOInstance().getText());
        String[] moInstances = null;
        if (st.compareTo("") != 0) {
            moInstances = st.split(",");
        }
        if (moInstances != null) {
            for (String moInst : moInstances) {
                filter.addMoInstances(new NbiPolicyFilterMOInst((NbiPolicy)this.entity, moInst));
            }
        }
        filter.removeMoAliases();
        String stAlias = new String(this.panel.getNbiPolicyFilterPanel().getEvtFilterNETypeCriteriaPanel().getTxtMOAlias().getText());
        String[] moAliases = null;
        if (stAlias.compareTo("") != 0) {
            moAliases = stAlias.split(",");
        }
        if (moAliases != null) {
            for (String moAlias : moAliases) {
                filter.addMoAliases(new NbiPolicyFilterMOAlias((NbiPolicy)this.entity, moAlias));
            }
        }
        Set<NbiPolicyFilterSeverity> severities = filter.getSeverities();
        severities.clear();
        for (Integer severityValue : this.panel.getNbiPolicyFilterPanel().getEvtFilterEventCriteriaPanel().getSelectedSeverities()) {
            severity = new NbiPolicyFilterSeverity();
            severity.setNbiPolicy(nbiPolicy);
            severity.setSeverity(severityValue.byteValue());
            severities.add(severity);
        }
        for (Enum eventCateg : listEvtCategories) {
            if (EventCategory.Alarm.equals(eventCateg)) continue;
            severity = new NbiPolicyFilterSeverity();
            severity.setNbiPolicy(nbiPolicy);
            severity.setSeverity(Severity.Other.byteValue());
            severities.add(severity);
            break;
        }
        String str = (String)FormUtil.getSelectedValue(this.panel.getNbiPolicyFilterPanel().getEvtFilterEventCriteriaPanel().getCmbUserClassifier());
        filter.setUserClassifier(str);
        Set<NbiPolicyFilterLocation> locations = filter.getLocations();
        locations.clear();
        List listLocation = (List)this.panel.getNbiPolicyFilterPanel().getEvtFilterTopologyCriteriaPanel().getSelectorLocations().getValue();
        if (listLocation != null) {
            for (Location location : listLocation) {
                NbiPolicyFilterLocation filterLocation = new NbiPolicyFilterLocation();
                filterLocation.setNbiPolicy(nbiPolicy);
                filterLocation.setLocationID(location.getId());
                locations.add(filterLocation);
            }
        }
        Set<NbiPolicyFilterEquipment> equipments = filter.getEquipments();
        equipments.clear();
        List listNENames = (List)this.panel.getNbiPolicyFilterPanel().getEvtFilterTopologyCriteriaPanel().getSelectorNEList().getValue();
        if (listNENames != null) {
            for (Equipment equipment : listNENames) {
                NbiPolicyFilterEquipment filterEquipment = new NbiPolicyFilterEquipment();
                filterEquipment.setNbiPolicy(nbiPolicy);
                filterEquipment.setEquipmentID(equipment.getId());
                equipments.add(filterEquipment);
            }
        }
        NbiPolicy.NbiPolicyTime policyTime = nbiPolicy.getPolicyTime();
        Set<NbiPolicyTimeDays> days = policyTime.getDays();
        days.clear();
        for (int dayValue : this.panel.getNbiPolicySchedulerPanel().getSelectedDays()) {
            NbiPolicyTimeDays day = new NbiPolicyTimeDays();
            day.setNbiPolicy(nbiPolicy);
            day.setDay(dayValue);
            days.add(day);
        }
        policyTime.setStartTime(this.panel.getNbiPolicySchedulerPanel().getStartTime().getDate().getTime());
        policyTime.setEndTime(this.panel.getNbiPolicySchedulerPanel().getEndTime().getDate().getTime());
        return invalidValues;
    }

    @Override
    public void fillUI(NbiPolicy nbiPolicy) {
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.eventFilterConstantsProvider");
        if (nbiPolicy.getId() > 0L) {
            this.panel.getNbiPolicyGeneralPanel().getChkEnabled().setSelected(nbiPolicy.getEnabled() != 0);
        }
        NbiPolicy.NbiPolicyFilter filter = nbiPolicy.getPolicyFilter();
        ArrayList listNETypesEnums = new ArrayList();
        for (NbiPolicyFilterNEType neType : filter.getNeTypes()) {
            Integer neTypeValue = new Integer(neType.getNeType());
            Enum<?> enumClass = PluginUtil.returnSavedNETypeEnum(extensionPoint, neTypeValue);
            if (enumClass == null) continue;
            listNETypesEnums.add(enumClass);
        }
        this.panel.getNbiPolicyFilterPanel().getEvtFilterNETypeCriteriaPanel().getSelectorResultNEType().setValue(listNETypesEnums);
        Enum[] neTypesArray = new Enum[listNETypesEnums.size()];
        int k = 0;
        Iterator i$ = listNETypesEnums.iterator();
        while (i$.hasNext()) {
            Enum neTypeEnum;
            neTypesArray[k] = neTypeEnum = (Enum)i$.next();
            ++k;
        }
        ArrayList listSingleMOTypes = new ArrayList();
        int[] moTypeValues = new int[filter.getMoTypes().size()];
        int i = 0;
        for (NbiPolicyFilterMOType eventMOType : filter.getMoTypes()) {
            byte moType = eventMOType.getMoType();
            Integer evtMOType = new Integer(FilterUtil.fixMoTypeValue(moType));
            moTypeValues[i] = evtMOType;
            ++i;
            Enum<?> moTypeEnumClass = PluginUtil.returnSavedMOTypeEnum(extensionPoint, evtMOType);
            if (moTypeEnumClass == null) continue;
            listSingleMOTypes.add(moTypeEnumClass);
        }
        if (neTypesArray == null || neTypesArray.length == 0) {
            this.panel.getNbiPolicyFilterPanel().getEvtFilterNETypeCriteriaPanel().getSelectorResultMOType().setValue(listSingleMOTypes);
        } else {
            List<Enum<?>> listMOTypeEnums = PluginUtil.getMOTypeEnums(moTypeValues, neTypesArray);
            this.panel.getNbiPolicyFilterPanel().getEvtFilterNETypeCriteriaPanel().getSelectorResultMOType().setValue(listMOTypeEnums);
        }
        ArrayList<EventCategory> listEvtCategoriesEnums = new ArrayList<EventCategory>();
        for (NbiPolicyFilterEventCategory evtCategory : filter.getEventCategories()) {
            for (EventCategory eventCat : EventCategory.values()) {
                if (evtCategory.getEventCategory() != eventCat.byteValue()) continue;
                listEvtCategoriesEnums.add(eventCat);
            }
        }
        this.panel.getNbiPolicyFilterPanel().getEvtFilterEventCriteriaPanel().getSelectorEventCategory().setValue(listEvtCategoriesEnums);
        Enum[] evtCategoryArray = new Enum[listEvtCategoriesEnums.size()];
        int l = 0;
        for (EventCategory evtCategoryEnum : listEvtCategoriesEnums) {
            evtCategoryArray[l] = evtCategoryEnum;
            ++l;
        }
        ArrayList<Enum> listEvtTypeEnums = new ArrayList<Enum>();
        for (NbiPolicyFilterEventType eventEvtType : filter.getEventTypes()) {
            AlarmType alarmType = AlarmType.fromValue(eventEvtType.getEventType());
            if (alarmType != AlarmType.unexpectedValue) {
                listEvtTypeEnums.add(alarmType);
                continue;
            }
            StateChangeType stateChangeType = StateChangeType.fromValue(eventEvtType.getEventType());
            if (stateChangeType != StateChangeType.unexpectedValue) {
                listEvtTypeEnums.add(stateChangeType);
                continue;
            }
            SysEventType sysEventType = SysEventType.fromValue(eventEvtType.getEventType());
            if (sysEventType != SysEventType.unexpectedValue) {
                listEvtTypeEnums.add(sysEventType);
                continue;
            }
            ConfigChangeType configChangeType = ConfigChangeType.fromValue(eventEvtType.getEventType());
            if (configChangeType == ConfigChangeType.unexpectedValue) continue;
            listEvtTypeEnums.add(configChangeType);
        }
        this.panel.getNbiPolicyFilterPanel().getEvtFilterEventCriteriaPanel().getSelectorEventType().setValue(listEvtTypeEnums);
        ArrayList listOIDEnums = new ArrayList();
        for (NbiPolicyFilterEvtOID eventOid : filter.getEventOIDs()) {
            String evtOID = eventOid.getEventOID();
            Enum<?> enumClass = PluginUtil.returnSavedOIDEnums(extensionPoint, evtOID);
            if (enumClass == null) continue;
            listOIDEnums.add(enumClass);
        }
        this.panel.getNbiPolicyFilterPanel().getEvtFilterNETypeCriteriaPanel().getSelectorResultTrapName().setValue(listOIDEnums);
        StringBuffer buf = new StringBuffer();
        for (NbiPolicyFilterMOInst moInst : filter.getMoInstances()) {
            String moInstVal = new String(moInst.getMoInst());
            buf.append(moInstVal).append(",");
        }
        this.panel.getNbiPolicyFilterPanel().getEvtFilterNETypeCriteriaPanel().getTxtMOInstance().setText(buf.toString());
        StringBuffer bufAlias = new StringBuffer();
        for (NbiPolicyFilterMOAlias moAlias : filter.getMoAliases()) {
            String moAliasVal = new String(moAlias.getMoAlias());
            bufAlias.append(moAliasVal).append(",");
        }
        this.panel.getNbiPolicyFilterPanel().getEvtFilterNETypeCriteriaPanel().getTxtMOAlias().setText(bufAlias.toString());
        ArrayList<Integer> severityValues = new ArrayList<Integer>();
        for (NbiPolicyFilterSeverity severity : filter.getSeverities()) {
            severityValues.add(new Integer(severity.getSeverity()));
        }
        this.panel.getNbiPolicyFilterPanel().getEvtFilterEventCriteriaPanel().setSelectedSeverities(severityValues);
        FormUtil.setSelectedValue(this.panel.getNbiPolicyFilterPanel().getEvtFilterEventCriteriaPanel().getCmbUserClassifier(), filter.getUserClassifier());
        ArrayList<Location> listLocation = new ArrayList<Location>();
        for (NbiPolicyFilterLocation evtLocation : filter.getLocations()) {
            LightQuery<Location> query = new LightQuery<Location>(Location.class);
            query.addParameter("id", new Long(evtLocation.getLocationID()).intValue());
            List<Location> locations = ServiceRegistry.getEntityManagerService().retrieveByQuery(query);
            if (locations.isEmpty()) continue;
            listLocation.addAll(locations);
        }
        this.panel.getNbiPolicyFilterPanel().getEvtFilterTopologyCriteriaPanel().getSelectorLocations().setValue(listLocation);
        ArrayList<Equipment> listEquipment = new ArrayList<Equipment>();
        for (NbiPolicyFilterEquipment evtEquipment : filter.getEquipments()) {
            LightQuery<Equipment> query = new LightQuery<Equipment>(Equipment.class);
            query.addParameter("id", new Long(evtEquipment.getEquipmentID()).intValue());
            List<Equipment> equipments = ServiceRegistry.getEntityManagerService().retrieveByQuery(query);
            if (equipments.isEmpty()) continue;
            listEquipment.addAll(equipments);
        }
        this.panel.getNbiPolicyFilterPanel().getEvtFilterTopologyCriteriaPanel().getSelectorNEList().setValue(listEquipment);
        NbiPolicy.NbiPolicyTime policyTime = nbiPolicy.getPolicyTime();
        if (((NbiPolicy)this.entity).getId() > 0L) {
            this.panel.getNbiPolicySchedulerPanel().setSelectedDays(policyTime.getDays());
            this.panel.getNbiPolicySchedulerPanel().getStartTime().setDate(new Date(policyTime.getStartTime()));
            this.panel.getNbiPolicySchedulerPanel().getEndTime().setDate(new Date(policyTime.getEndTime()));
        } else {
            this.panel.getNbiPolicySchedulerPanel().setSelectedDays(true);
            cal.setTimeInMillis(System.currentTimeMillis());
            cal.set(9, 0);
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            this.panel.getNbiPolicySchedulerPanel().getStartTime().setDate(cal.getTime());
            cal.set(9, 1);
            cal.set(10, 11);
            cal.set(12, 59);
            cal.set(13, 59);
            this.panel.getNbiPolicySchedulerPanel().getEndTime().setDate(cal.getTime());
        }
        super.fillUI(nbiPolicy);
    }

    static {
        cal.setLenient(false);
    }
}

