/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.nbi.policies;

import com.bwanms.client.gui.fault.nbi.policies.NbiPolicyEditorContainer;
import com.bwanms.client.gui.fault.nbi.policies.NbiPolicyEditorPanel;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.gui.manager.DefaultRowCreator;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerFilterView;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerFilterView;
import com.bwanms.model.fault.nbi.Nbi;
import com.bwanms.model.fault.nbi.NbiPolicy;
import com.bwanms.security.Security;
import com.bwanms.services.EntityManagerService;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ServerValidationException;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NbiPolicyManagerConfig
extends EntityManagerConfig {
    private static final Logger log = Logger.getLogger(NbiPolicyManagerConfig.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(NbiPolicyManagerConfig.class);
    private static String[] columnNames = new String[]{"NbiPolicyName", "NbiPolicyDescription", "NbiPolicyStatus"};
    private static String[] columnAttribNames = new String[]{"name", "description", "enabled"};
    private List<EntityManagerColumn> columns;
    private EntityManagerRowProvider entityRowProvider;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private Nbi nbi;

    public NbiPolicyManagerConfig(Nbi nbi) {
        this.nbi = nbi;
        this.columns = new Vector<EntityManagerColumn>();
        for (int i = 0; i < columnNames.length; ++i) {
            this.columns.add(new EntityManagerColumn(columnNames[i], columnAttribNames[i], i18n.translateString(columnNames[i]), new EntityManagerRowDisplayComparator(i)));
        }
        this.filterCriteria = new Vector();
        this.addNameCriteria();
        this.addDescriptionCriteria();
        this.addStatusCriteria();
        this.entityRowProvider = new NbiPolicyManagerRowProvider(NbiPolicyManagerConfig.getColumnAttributeNames(this.columns));
        this.declaredActions = new Vector<ManagerAction>();
        this.declaredActions.add(new NbiPolicyManagerAction("NbiPolicyNew", 1));
        this.defaultAction = new NbiPolicyManagerAction("NbiPolicyEdit", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new NbiPolicyManagerAction("NbiPolicyDelete", 1));
    }

    protected void addNameCriteria() {
        EntityManagerFilterCriteria nameCriteria = new EntityManagerFilterCriteria(i18n.translateString("NbiPolicyName"), "name", 1, 1, null, false);
        this.filterCriteria.add(nameCriteria);
    }

    protected void addDescriptionCriteria() {
    }

    protected void addStatusCriteria() {
        Vector<Object> items = new Vector<Object>();
        items.add(new ComboItem(1, i18n.translateString("NbiEnabled")));
        items.add(new ComboItem(0, i18n.translateString("NbiDisabled")));
        EntityManagerFilterCriteria statusCriteria = new EntityManagerFilterCriteria(i18n.translateString("NbiPolicyStatus"), "enabled", 1, 3, items, true, false);
        this.filterCriteria.add(statusCriteria);
    }

    @Override
    protected String getBaseName() {
        return NbiPolicy.class.getName();
    }

    @Override
    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    @Override
    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    @Override
    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    @Override
    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    @Override
    public ManagerFilterView getFilterView() {
        String adittionalFilter = " tbl1.nbi=" + this.nbi.getId();
        return new EntityManagerFilterView(this.getManagerName(), this.getBaseName(), this.getFilterCriteria(), this.getEntityRowProvider(), adittionalFilter);
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.fm.nbi.nbi_policy_manager";
    }

    @Override
    public String getTitle() {
        return i18n.translateString("NbiPolicyManager", this.nbi.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NbiPolicyManagerRowProvider
    extends DefaultRowCreator {
        public NbiPolicyManagerRowProvider(List<String> attributes) {
            super(attributes);
        }

        @Override
        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List<String> ret = super.getDisplayValues(entityRow);
            Byte enabled = (Byte)entityRow.getAttributeValue(2);
            ret.set(2, NbiPolicyEditorPanel.i18n.translateString(enabled == 0 ? "NbiDisabled" : "NbiEnabled"));
            return ret;
        }

        @Override
        public String readEntityId(Serializable entity) {
            return String.valueOf(((NbiPolicy)entity).getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NbiPolicyManagerAction
    extends ManagerAction {
        public NbiPolicyManagerAction(String name, int category) {
            this.name = name;
            this.category = category;
        }

        @Override
        public Internationalizer getI18n() {
            return i18n;
        }

        @Override
        public void performAction(final ManagerView manager) {
            final List<Serializable> selection = manager.getSelection();
            if ("NbiPolicyNew".equals(this.name)) {
                try {
                    NbiPolicy nbiPolicy = new NbiPolicy();
                    nbiPolicy.setNbi(NbiPolicyManagerConfig.this.nbi);
                    new NbiPolicyEditorContainer(nbiPolicy, (EntityChangeListener<Serializable>)((EntityChangeListener)((Object)manager)));
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(manager.getUI(), ex.getMessage());
                }
            } else if ("NbiPolicyEdit".equals(this.name) && 1 == selection.size()) {
                NbiPolicy nbiPolicy = (NbiPolicy)selection.get(0);
                try {
                    new NbiPolicyEditorContainer(nbiPolicy, (EntityChangeListener<Serializable>)((EntityChangeListener)((Object)manager)));
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(manager.getUI(), ex.getMessage());
                }
            } else if ("NbiPolicyDelete".equals(this.name) && !selection.isEmpty()) {
                if (!MessageBox.WarnConfirm.showResult(manager.getUI(), null, i18n.translateString("NbiPolicyDeleteConfirmationTitle"))) {
                    return;
                }
                AbstractLongOperation deleteOperation = new AbstractLongOperation(){

                    public String getTitle() {
                        return i18n.translateString("NbiPolicyDeleteTitle");
                    }

                    public boolean isCancelable() {
                        return true;
                    }

                    public long getMaxProgress() {
                        return selection.size();
                    }

                    public void run() {
                        long progress = 0L;
                        EntityManagerService entityService = ServiceRegistry.getEntityManagerService();
                        EntityChangeListener listener = null;
                        if (manager instanceof EntityChangeListener) {
                            listener = (EntityChangeListener)((Object)manager);
                        }
                        for (Serializable row : selection) {
                            if (this.shouldCancel) {
                                this.monitor.logMessage(i18n.translateString("NbiPolicyDeleteCanceled"));
                                break;
                            }
                            NbiPolicy nbiPolicy = (NbiPolicy)row;
                            String nbiPolicyName = nbiPolicy.getName();
                            String message = i18n.translateString("NbiPolicyDeleting", nbiPolicyName);
                            this.monitor.updateProgress(progress, message);
                            try {
                                nbiPolicy.getNbi().removePolicy(nbiPolicy);
                                entityService.save(nbiPolicy.getNbi());
                                ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "EntityDelete", "NBIPolicyManager", nbiPolicy.getName(), nbiPolicy.getClass().getName());
                                if (listener != null) {
                                    listener.entityRemoved(row);
                                }
                                this.monitor.logMessage(i18n.translateString("NbiPolicyDeleteSuccesfull", nbiPolicyName));
                                log.debug((Object)("Deleted nbi policy: " + nbiPolicyName));
                            }
                            catch (ServerValidationException e) {
                                this.monitor.logMessage(i18n.translateString("NbiPolicyDeleteError", nbiPolicyName, e.getInvalidValues().get(0).getMessage()));
                                log.debug((Object)"Failed to delete nbi policy.", (Throwable)e);
                            }
                            catch (Exception e) {
                                this.monitor.logMessage(i18n.translateString("NbiPolicyDeleteError", nbiPolicyName, e.getMessage()));
                                log.debug((Object)"Failed to delete nbi policy.", (Throwable)e);
                            }
                            this.monitor.updateProgress(++progress, message);
                        }
                        this.monitor.operationCompleted(false);
                    }
                };
                LongOperationUtil.startDetailLongOperationDialog(manager.getUI(), deleteOperation);
            }
        }

        @Override
        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("NbiPolicyNew")) {
                return true;
            }
            if (this.name.equals("NbiPolicyEdit")) {
                return 1 == selectionSize;
            }
            if (this.name.equals("NbiPolicyDelete")) {
                return selectionSize > 0;
            }
            return false;
        }
    }
}

