/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.nbi;

import com.bwanms.client.gui.fault.nbi.NbiEditorPanel;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.model.fault.constants.NbiProtocol;
import com.bwanms.model.fault.nbi.Nbi;
import com.bwanms.model.fault.nbi.NbiProtocolParams;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.FormUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NbiView
extends AbstractBindedEditorView<Nbi> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(NbiView.class);
    private NbiEditorPanel panel = new NbiEditorPanel();
    private AbstractBindedEditorView protocolParamsView;
    NbiProtocolParams protocolParams;

    public void validateProtocolParamsView(NbiProtocolParams pParams) {
        try {
            Class protocolParamsBean = (Class)((ComboItem)this.panel.getCmbProtocol().getSelectedItem()).getValue();
            this.protocolParamsView = (AbstractBindedEditorView)NbiProtocol.getNbiProtocol(protocolParamsBean).getView().newInstance();
            this.panel.getPanelProtocol().removeAll();
            this.panel.getPanelProtocol().add(this.protocolParamsView.getUI());
            this.panel.validate();
            if (pParams == null) {
                this.protocolParams = (NbiProtocolParams)protocolParamsBean.newInstance();
            }
            this.protocolParamsView.setEntity(this.protocolParams);
        }
        catch (IllegalAccessException iae) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    @Override
    public String getApplicationPermission() {
        return null;
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.fm.nbi.nbi_editor";
    }

    @Override
    public String getTitle() {
        return i18n.translateString("NbiView");
    }

    @Override
    public JComponent getUI() {
        return this.panel;
    }

    @Override
    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        DefaultBinder binder = new DefaultBinder(this.panel, this.entity);
        binder.add(new JTextFieldBinding("txtName", "name", i18n.translateString("NbiName")));
        binder.add(new JTextFieldBinding("txtDesc", "description", i18n.translateString("NbiDescription")));
        binder.add(new JTextFieldBinding("txtIPAddr", "ipAddress", i18n.translateString("NbiIPAddress")));
        binders.add(binder);
        return binders;
    }

    @Override
    public List<InvalidValue> configureEntity(Nbi nbi) {
        ArrayList<InvalidValue> invalidValues = new ArrayList<InvalidValue>();
        nbi.setEnabled((byte)(this.panel.getChkEnabled().isSelected() ? 1 : 0));
        nbi.setUser(FormUtil.getText(this.panel.getTxtUser()));
        nbi.setPassword(FormUtil.getText(this.panel.getPass()));
        invalidValues.addAll(super.configureEntity(nbi));
        invalidValues.addAll(this.protocolParamsView.configureEntity(this.protocolParams));
        nbi.setProtocolParams(this.protocolParams);
        return invalidValues;
    }

    @Override
    public void fillUI(Nbi nbi) {
        if (nbi.getId() > 0L) {
            this.panel.getChkEnabled().setSelected(nbi.getEnabled() != 0);
        }
        this.panel.getTxtUser().setText(nbi.getUser());
        this.panel.getPass().setText(nbi.getPassword());
        this.protocolParams = nbi.getProtocolParams();
        this.panel.getCmbProtocol().setSelectedItem(NbiProtocol.getNbiProtocol(this.protocolParams.getClass()).getView());
        this.validateProtocolParamsView(this.protocolParams);
        this.panel.getCmbProtocol().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NbiView.this.validateProtocolParamsView(null);
            }
        });
    }
}

