/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.nbi;

import com.bwanms.client.gui.fault.nbi.NbiCellRenderer;
import com.bwanms.client.gui.fault.nbi.NbiEditorContainer;
import com.bwanms.client.gui.fault.nbi.NbiEditorPanel;
import com.bwanms.client.gui.fault.nbi.NbiManagerRowTableModel;
import com.bwanms.client.gui.fault.nbi.policies.NbiPolicyManagerConfig;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.entitymanager.EntityQueryStrategy;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.gui.manager.DefaultRowCreator;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerResultForm;
import com.bwanms.gui.manager.generic.EntityManagerResultView;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerView;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerResultsView;
import com.bwanms.gui.manager.generic.SimpleEntityQueryStrategy;
import com.bwanms.model.fault.constants.NbiProtocol;
import com.bwanms.model.fault.nbi.Nbi;
import com.bwanms.model.fault.nbi.NbiProtocolParams;
import com.bwanms.security.Security;
import com.bwanms.services.EntityManagerService;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ServerValidationException;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NbiManagerConfig
extends EntityManagerConfig {
    private static final Logger log = Logger.getLogger(NbiManagerConfig.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(NbiManagerConfig.class);
    private static String[] columnNames = new String[]{"ColNbiName", "ColNbiDescription", "ColNbiIPAddress", "ColNbiProtocol", "ColNbiEventForwarding"};
    private static String[] columnAttribNames = new String[]{"name", "description", "ipAddress", "protocolParams", "enabled"};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private Vector<ManagerFilterCriteria> filterCriteria;
    private NbiManagerRowProvider entityRowProvider;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public NbiManagerConfig() {
        for (int i = 0; i < columnNames.length; ++i) {
            this.columns.add(new EntityManagerColumn(columnNames[i], columnAttribNames[i], i18n.translateString(columnNames[i]), new EntityManagerRowDisplayComparator(i)));
        }
        this.filterCriteria = new Vector();
        this.addNameCriteria();
        this.addDescriptionCriteria();
        this.addIPAddressCriteria();
        this.addEventForwardingCriteria();
        this.entityRowProvider = new NbiManagerRowProvider(NbiManagerConfig.getColumnAttributeNames(this.columns));
        this.declaredActions = new Vector<ManagerAction>();
        this.declaredActions.add(new NbiManagerAction("NbiNew", 1));
        this.defaultAction = new NbiManagerAction("NbiEdit", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new NbiManagerAction("NbiDelete", 1));
        this.declaredActions.add(new NbiManagerAction("NbiPolicy", 1));
    }

    protected void addNameCriteria() {
        EntityManagerFilterCriteria nameCriteria = new EntityManagerFilterCriteria(i18n.translateString("Name"), "name", 1, 1, null, false);
        this.filterCriteria.add(nameCriteria);
    }

    @Override
    public ManagerResultsView getResultsView() {
        NbiManagerRowTableModel tableModel = new NbiManagerRowTableModel(this.getEntityRowProvider(), this.getColumnTitles());
        EntityManagerResultView view = new EntityManagerResultView(tableModel, this.getColumns());
        EntityManagerResultForm form = (EntityManagerResultForm)view.getUI();
        form.getResultTable().setDefaultRenderer(Object.class, new NbiCellRenderer(tableModel));
        return view;
    }

    protected void addDescriptionCriteria() {
    }

    protected void addIPAddressCriteria() {
        EntityManagerFilterCriteria ipAddressCriteria = new EntityManagerFilterCriteria(i18n.translateString("NbiIPAddress"), "ipAddress", 1, 1, null, false);
        this.filterCriteria.add(ipAddressCriteria);
    }

    private void addProtocolCriteria() {
        Vector<Object> items = new Vector<Object>();
        for (NbiProtocol protocol : NbiProtocol.values()) {
            items.add(new ComboItem(protocol.getResource(), i18n.translateString(protocol.getResource())));
        }
        EntityManagerFilterCriteria protocolCriteria = new EntityManagerFilterCriteria(i18n.translateString("NbiProtocol"), "protocol", 1, 3, items, true, false);
        this.filterCriteria.add(protocolCriteria);
    }

    protected void addEventForwardingCriteria() {
        Vector<Object> items = new Vector<Object>();
        items.add(new ComboItem(1, i18n.translateString("NbiEnabled")));
        items.add(new ComboItem(0, i18n.translateString("NbiDisabled")));
        EntityManagerFilterCriteria eventForwardingCriteria = new EntityManagerFilterCriteria(i18n.translateString("NbiEventForwarding"), "enabled", 1, 3, items, true, false);
        this.filterCriteria.add(eventForwardingCriteria);
    }

    @Override
    protected String getBaseName() {
        return Nbi.class.getName();
    }

    @Override
    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    @Override
    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    @Override
    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    @Override
    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.fm.nbi.northbound_manager";
    }

    @Override
    public String getTitle() {
        return i18n.translateString("NbiManager");
    }

    @Override
    public EntityQueryStrategy getQueryStrategy() {
        return new SimpleEntityQueryStrategy();
    }

    public int getMaxDevices() {
        return 10;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NbiManagerRowProvider
    extends DefaultRowCreator {
        public NbiManagerRowProvider(List<String> attributes) {
            super(attributes);
        }

        @Override
        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List<String> ret = super.getDisplayValues(entityRow);
            NbiProtocolParams protocolParams = (NbiProtocolParams)entityRow.getAttributeValue(3);
            ret.set(3, NbiEditorPanel.i18n.translateString(NbiProtocol.getNbiProtocol(protocolParams.getClass()).getResource()));
            Byte enabled = (Byte)entityRow.getAttributeValue(4);
            ret.set(4, NbiEditorPanel.i18n.translateString(enabled == 0 ? "NbiDisabled" : "NbiEnabled"));
            return ret;
        }

        @Override
        public String readEntityId(Serializable entity) {
            return String.valueOf(((Nbi)entity).getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NbiManagerAction
    extends ManagerAction {
        public NbiManagerAction(String name, int category) {
            this.name = name;
            this.category = category;
        }

        @Override
        public Internationalizer getI18n() {
            return i18n;
        }

        @Override
        public void performAction(final ManagerView manager) {
            final List<Serializable> selection = manager.getSelection();
            if ("NbiNew".equals(this.name)) {
                if (manager.getData().size() >= NbiManagerConfig.this.getMaxDevices()) {
                    MessageBox.Alert.quickShow(manager.getUI(), i18n.translateString("Nbi_New_Warning_Reached_Max", NbiManagerConfig.this.getMaxDevices()));
                    return;
                }
                try {
                    Nbi nbi = new Nbi();
                    new NbiEditorContainer(nbi, (EntityChangeListener<Serializable>)((EntityChangeListener)((Object)manager)));
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(manager.getUI(), ex.getMessage());
                }
            } else if ("NbiEdit".equals(this.name) && 1 == selection.size()) {
                Nbi nbi = (Nbi)selection.get(0);
                try {
                    new NbiEditorContainer(nbi, (EntityChangeListener<Serializable>)((EntityChangeListener)((Object)manager)));
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(manager.getUI(), ex.getMessage());
                }
            } else if ("NbiDelete".equals(this.name) && !selection.isEmpty()) {
                if (!MessageBox.WarnConfirm.showResult(manager.getUI(), null, i18n.translateString("NbiDeleteConfirmationTitle"))) {
                    return;
                }
                AbstractLongOperation deleteOperation = new AbstractLongOperation(){

                    public String getTitle() {
                        return i18n.translateString("NbiDeleteTitle");
                    }

                    public boolean isCancelable() {
                        return true;
                    }

                    public long getMaxProgress() {
                        return selection.size();
                    }

                    public void run() {
                        long progress = 0L;
                        EntityManagerService contactService = ServiceRegistry.getEntityManagerService();
                        EntityChangeListener listener = null;
                        if (manager instanceof EntityChangeListener) {
                            listener = (EntityChangeListener)((Object)manager);
                        }
                        for (Serializable row : selection) {
                            if (this.shouldCancel) {
                                this.monitor.logMessage(i18n.translateString("NbiDeleteCanceled"));
                                break;
                            }
                            Nbi nbi = (Nbi)row;
                            String nbiName = nbi.getName();
                            String message = i18n.translateString("NbiDeleting", nbiName);
                            this.monitor.updateProgress(progress, message);
                            try {
                                contactService.delete(nbi);
                                ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "EntityDelete", "NBIManager", nbi.getName(), nbi.getClass().getName());
                                if (listener != null) {
                                    listener.entityRemoved(row);
                                }
                                this.monitor.logMessage(i18n.translateString("NbiDeleteSuccesfull", nbiName));
                                log.debug((Object)("Deleted nbi: " + nbiName));
                            }
                            catch (ServerValidationException e) {
                                this.monitor.logMessage(i18n.translateString("NbiDeleteError", nbiName, e.getInvalidValues().get(0).getMessage()));
                                log.debug((Object)"Failed to delete nbi.", (Throwable)e);
                            }
                            catch (Exception e) {
                                this.monitor.logMessage(i18n.translateString("NbiDeleteError", nbiName, e.getMessage()));
                                log.debug((Object)"Failed to delete nbi.", (Throwable)e);
                            }
                            this.monitor.updateProgress(++progress, message);
                        }
                        this.monitor.operationCompleted(false);
                    }
                };
                LongOperationUtil.startDetailLongOperationDialog(manager.getUI(), deleteOperation);
            } else if ("NbiPolicy".equals(this.name) && 1 == selection.size()) {
                try {
                    final Nbi nbi = (Nbi)selection.get(0);
                    EntityManagerView managerView = new EntityManagerView(new NbiPolicyManagerConfig(nbi)){

                        public void cleanup() {
                            ((EntityChangeListener)((Object)manager)).entityChanged(nbi);
                            super.cleanup();
                        }
                    };
                    FrameUtil.runView(managerView, 800, 500);
                }
                catch (Exception ex) {
                    MessageBox.Error.quickShow(manager.getUI(), ex.getMessage());
                }
            }
        }

        @Override
        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("NbiNew")) {
                return true;
            }
            if (this.name.equals("NbiEdit")) {
                return 1 == selectionSize;
            }
            if (this.name.equals("NbiDelete")) {
                return selectionSize > 0;
            }
            if (this.name.equals("NbiPolicy")) {
                return 1 == selectionSize;
            }
            return false;
        }
    }
}

