/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.nbi;

import com.bwanms.client.gui.fault.nbi.NbiView;
import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.editor.EntityEditorContainer;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.model.fault.nbi.Nbi;
import com.bwanms.security.Security;
import com.bwanms.services.EntityAlreadyExistsException;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.ServerValidationException;
import java.io.Serializable;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NbiEditorContainer
extends EntityEditorContainer<Nbi> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(NbiEditorContainer.class);

    public NbiEditorContainer(Nbi entity, EntityChangeListener<Serializable> listener) throws ServiceException {
        super(entity, listener);
    }

    @Override
    protected String getEntityClass() {
        return i18n.translateString(Nbi.class.getName());
    }

    @Override
    public String getEntityId() {
        return String.valueOf(((Nbi)this.getEntity()).getId());
    }

    @Override
    protected String getEntityName() {
        return this.getEntity() != null ? ((Nbi)this.getEntity()).getName() : "null";
    }

    @Override
    public String getTitle() {
        return i18n.translateString("NbiEditor");
    }

    @Override
    protected EditorView<Nbi> initView() {
        return new NbiView();
    }

    @Override
    protected void saveEntity() throws ServiceException {
        try {
            super.saveEntity();
            ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), this.entityIsNew ? "EntityCreate" : "EntityChange", "NBIManager", ((Nbi)this.entity).getName(), ((Nbi)this.entity).getClass().getName());
        }
        catch (EntityAlreadyExistsException e) {
            this.invalidValues.add(new InvalidValue(i18n.translateString("NBIWithTheSameNameIsAlreadyDefined"), Nbi.class, i18n.translateString("Name"), (Object)e.getMessage(), null));
            throw new ServerValidationException(this.invalidValues);
        }
    }
}

