/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.filters;

import com.bwanms.client.gui.fault.filters.EvtFilterEditorPanel;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.model.Equipment;
import com.bwanms.model.Location;
import com.bwanms.model.entity.LightQuery;
import com.bwanms.model.fault.EventFilter;
import com.bwanms.model.fault.EvtFilterEquipment;
import com.bwanms.model.fault.EvtFilterEventCategory;
import com.bwanms.model.fault.EvtFilterEventType;
import com.bwanms.model.fault.EvtFilterEvtOID;
import com.bwanms.model.fault.EvtFilterLocation;
import com.bwanms.model.fault.EvtFilterMOAlias;
import com.bwanms.model.fault.EvtFilterMOInst;
import com.bwanms.model.fault.EvtFilterMOType;
import com.bwanms.model.fault.EvtFilterNEType;
import com.bwanms.model.fault.EvtFilterSeverity;
import com.bwanms.model.fault.constants.AlarmType;
import com.bwanms.model.fault.constants.ConfigChangeType;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.model.fault.constants.StateChangeType;
import com.bwanms.model.fault.constants.SysEventType;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.FormUtil;
import com.bwanms.util.IpAddress;
import com.bwanms.util.PluginUtil;
import com.bwanms.util.fault.FilterUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvtFilterView
extends AbstractBindedEditorView<EventFilter> {
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(EvtFilterView.class);
    private EvtFilterEditorPanel panel = new EvtFilterEditorPanel();

    @Override
    public String getApplicationPermission() {
        return null;
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.fm.event_filter_editor";
    }

    @Override
    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        DefaultBinder generalPanelBinder = new DefaultBinder(this.panel.getEvtFilterGeneralPanel(), this.entity);
        generalPanelBinder.add(new JTextFieldBinding("txtName", "name", i18n.translateString("Name")));
        generalPanelBinder.add(new JTextFieldBinding("txtDescription", "description"));
        ReadOnlyBinder generalPanelOwnerBinder = new ReadOnlyBinder(this.panel.getEvtFilterGeneralPanel(), this.entity);
        generalPanelOwnerBinder.add(new JTextFieldBinding("txtOwner", "owner"));
        binders.add(generalPanelBinder);
        binders.add(generalPanelOwnerBinder);
        return binders;
    }

    @Override
    public String getTitle() {
        return i18n.translateString("EventFilter");
    }

    @Override
    public JComponent getUI() {
        return this.panel;
    }

    @Override
    public List<InvalidValue> configureEntity(EventFilter entity) {
        List<InvalidValue> invalidValues = super.configureEntity(entity);
        entity.removeNETypes();
        List listNETypes = (List)this.panel.getSelectorNEType().getValue();
        if (listNETypes != null) {
            for (Enum neTypeEnum : listNETypes) {
                try {
                    Method m = neTypeEnum.getClass().getMethod("value", new Class[0]);
                    Byte moValue = ((Integer)m.invoke((Object)neTypeEnum, new Object[0])).byteValue();
                    entity.addNETypes(new EvtFilterNEType(entity, moValue));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        entity.removeMoInstances();
        String st = new String(this.panel.getTxtMOInstance().getText());
        String[] moInstances = null;
        if (st.compareTo("") != 0) {
            moInstances = st.split(",");
        }
        if (moInstances != null) {
            for (String moInst : moInstances) {
                entity.addMoInstance(new EvtFilterMOInst(entity, moInst));
            }
        }
        entity.removeMoAliases();
        String aliasString = new String(this.panel.getTxtMOAlias().getText());
        String[] moAliases = null;
        if (aliasString.compareTo("") != 0) {
            moAliases = aliasString.split(",");
        }
        if (moAliases != null) {
            for (String moAlias : moAliases) {
                entity.addMoAlias(new EvtFilterMOAlias(entity, moAlias));
            }
        }
        entity.removeEventCategories();
        List listEventCategories = (List)this.panel.getSelectorEventCategory().getValue();
        if (listEventCategories != null) {
            for (EventCategory eventCategoryEnum : listEventCategories) {
                entity.addEventCategory(new EvtFilterEventCategory(entity, eventCategoryEnum.byteValue()));
            }
        }
        entity.removeEventTypes();
        List listEventTypes = (List)this.panel.getSelectorEventType().getValue();
        if (listEventTypes != null) {
            for (Enum eventTypeEnum : listEventTypes) {
                try {
                    Method m = eventTypeEnum.getClass().getMethod("value", new Class[0]);
                    Byte eventTypeValue = ((Integer)m.invoke((Object)eventTypeEnum, new Object[0])).byteValue();
                    entity.addEventType(new EvtFilterEventType(entity, eventTypeValue));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        entity.removeMoTypes();
        List listMOtypes = (List)this.panel.getSelectorMOType().getValue();
        if (listMOtypes != null) {
            for (Enum moType : listMOtypes) {
                try {
                    Method m = moType.getClass().getMethod("value", new Class[0]);
                    Byte moValue = ((Integer)m.invoke((Object)moType, new Object[0])).byteValue();
                    entity.addMoType(new EvtFilterMOType(entity, moValue));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        entity.removeEventOIDs();
        List listOID = (List)this.panel.getSelectorEventName().getValue();
        if (listOID != null) {
            for (Enum oidEnum : listOID) {
                try {
                    Method m = oidEnum.getClass().getMethod("oid", new Class[0]);
                    String oidValue = (String)m.invoke((Object)oidEnum, new Object[0]);
                    entity.addEventOID(new EvtFilterEvtOID(entity, oidValue));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        entity.removeSeverities();
        for (Integer severityValue : this.panel.getSelectedSeverities()) {
            entity.addSeverity(new EvtFilterSeverity(entity, severityValue.byteValue()));
        }
        for (EventCategory eventCateg : listEventCategories) {
            if (EventCategory.Alarm.equals((Object)eventCateg)) continue;
            entity.addSeverity(new EvtFilterSeverity(entity, Severity.Other.byteValue()));
            break;
        }
        entity.removeLocationIDs();
        List listLocation = (List)this.panel.getSelectorLocations().getValue();
        if (listLocation != null) {
            for (Location location : listLocation) {
                entity.addLocationIDs(new EvtFilterLocation(entity, location.getId(), location.getName()));
            }
        }
        entity.removeEquipmentIDs();
        List listNE = (List)this.panel.getSelectorNEList().getValue();
        if (listNE != null) {
            for (Equipment ne : listNE) {
                entity.addEquipmentIDs(new EvtFilterEquipment(entity, ne.getId(), ne.getName(), new IpAddress(ne.getIpAddr()).toString()));
            }
        }
        entity.setAcknowledged(this.panel.getEvtSimpleFilterPanel().getEvtFilterEventCriteriaPanel().getEventStatusAcknowledged());
        entity.setCleared(this.panel.getEvtSimpleFilterPanel().getEvtFilterEventCriteriaPanel().getEventStatusCleared());
        String str = (String)FormUtil.getSelectedValue(this.panel.getEvtSimpleFilterPanel().getEvtFilterEventCriteriaPanel().getCmbUserClassifier());
        entity.setUserClassifier(str);
        return invalidValues;
    }

    @Override
    public void fillUI(EventFilter entity) {
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.eventFilterConstantsProvider");
        this.panel.getEvtFilterGeneralPanel().getTxtCreationDate().setText(FilterUtil.formatCreationDate(entity.getCreationDate()));
        ArrayList listNETypesEnums = new ArrayList();
        for (EvtFilterNEType neType : entity.getNeTypes()) {
            Integer neTypeValue = new Integer(neType.getNeType());
            Enum<?> neTypeEnumClass = PluginUtil.returnSavedNETypeEnum(extensionPoint, neTypeValue);
            if (neTypeEnumClass == null) continue;
            listNETypesEnums.add(neTypeEnumClass);
        }
        this.panel.getSelectorNEType().setValue(listNETypesEnums);
        Enum[] neTypesArray = new Enum[listNETypesEnums.size()];
        int k = 0;
        Iterator i$ = listNETypesEnums.iterator();
        while (i$.hasNext()) {
            Enum neTypeEnum;
            neTypesArray[k] = neTypeEnum = (Enum)i$.next();
            ++k;
        }
        ArrayList listSingleMOTypes = new ArrayList();
        int[] moTypesArray = new int[entity.getMoTypes().size()];
        int i = 0;
        for (EvtFilterMOType eventMOType : entity.getMoTypes()) {
            byte moType = eventMOType.getMoType();
            Integer moTypeValue = new Integer(FilterUtil.fixMoTypeValue(moType));
            moTypesArray[i] = moTypeValue;
            ++i;
            Enum<?> moTypeEnumClass = PluginUtil.returnSavedMOTypeEnum(extensionPoint, moTypeValue);
            if (moTypeEnumClass == null) continue;
            listSingleMOTypes.add(moTypeEnumClass);
        }
        if (neTypesArray == null || neTypesArray.length == 0) {
            this.panel.getSelectorMOType().setValue(listSingleMOTypes);
        } else {
            List<Enum<?>> listMOTypeEnums = PluginUtil.getMOTypeEnums(moTypesArray, neTypesArray);
            this.panel.getSelectorMOType().setValue(listMOTypeEnums);
        }
        StringBuffer buf = new StringBuffer();
        for (EvtFilterMOInst moInst : entity.getMoInstances()) {
            String moInstVal = new String(moInst.getMoInst());
            buf.append(moInstVal).append(",");
        }
        this.panel.getTxtMOInstance().setText(buf.toString());
        StringBuffer aliasBuf = new StringBuffer();
        for (EvtFilterMOAlias moAlias : entity.getMoAliases()) {
            String moAliasVal = new String(moAlias.getMoAlias());
            aliasBuf.append(moAliasVal).append(",");
        }
        this.panel.getTxtMOAlias().setText(aliasBuf.toString());
        ArrayList<EventCategory> listEvtCategoriesEnums = new ArrayList<EventCategory>();
        for (EvtFilterEventCategory evtCategory : entity.getEventCategories()) {
            for (EventCategory eventCat : EventCategory.values()) {
                if (evtCategory.getEventCategory() != eventCat.byteValue()) continue;
                listEvtCategoriesEnums.add(eventCat);
            }
        }
        this.panel.getSelectorEventCategory().setValue(listEvtCategoriesEnums);
        Enum[] evtCategoryArray = new Enum[listEvtCategoriesEnums.size()];
        int l = 0;
        for (EventCategory evtCategoryEnum : listEvtCategoriesEnums) {
            evtCategoryArray[l] = evtCategoryEnum;
            ++l;
        }
        ArrayList<Enum> listEvtTypeEnums = new ArrayList<Enum>();
        for (EvtFilterEventType eventEvtType : entity.getEventTypes()) {
            AlarmType alarmType = AlarmType.fromValue(eventEvtType.getEventType());
            if (alarmType != AlarmType.unexpectedValue) {
                listEvtTypeEnums.add(alarmType);
                continue;
            }
            StateChangeType stateChangeType = StateChangeType.fromValue(eventEvtType.getEventType());
            if (stateChangeType != StateChangeType.unexpectedValue) {
                listEvtTypeEnums.add(stateChangeType);
                continue;
            }
            SysEventType sysEventType = SysEventType.fromValue(eventEvtType.getEventType());
            if (sysEventType != SysEventType.unexpectedValue) {
                listEvtTypeEnums.add(sysEventType);
                continue;
            }
            ConfigChangeType configChangeType = ConfigChangeType.fromValue(eventEvtType.getEventType());
            if (configChangeType == ConfigChangeType.unexpectedValue) continue;
            listEvtTypeEnums.add(configChangeType);
        }
        this.panel.getSelectorEventType().setValue(listEvtTypeEnums);
        ArrayList listOIDEnums = new ArrayList();
        for (EvtFilterEvtOID eventOid : entity.getEventOIDs()) {
            String evtOID = eventOid.getEventOID();
            Enum<?> enumClass = PluginUtil.returnSavedOIDEnums(extensionPoint, evtOID);
            if (enumClass == null) continue;
            listOIDEnums.add(enumClass);
        }
        this.panel.getSelectorEventName().setValue(listOIDEnums);
        ArrayList<Location> listLocation = new ArrayList<Location>();
        for (EvtFilterLocation evtLocation : entity.getLocationIDs()) {
            LightQuery<Location> query = new LightQuery<Location>(Location.class);
            query.addParameter("id", new Long(evtLocation.getLocationID()).intValue());
            List<Location> locations = ServiceRegistry.getEntityManagerService().retrieveByQuery(query);
            if (locations.isEmpty()) continue;
            listLocation.addAll(locations);
        }
        this.panel.getSelectorLocations().setValue(listLocation);
        ArrayList<Equipment> listEquipment = new ArrayList<Equipment>();
        for (EvtFilterEquipment evtEquipment : entity.getEquipmentIDs()) {
            LightQuery<Equipment> query = new LightQuery<Equipment>(Equipment.class);
            query.addParameter("id", new Long(evtEquipment.getEquipmentID()).intValue());
            List<Equipment> equipments = ServiceRegistry.getEntityManagerService().retrieveByQuery(query);
            if (equipments.isEmpty()) continue;
            listEquipment.addAll(equipments);
        }
        this.panel.getSelectorNEList().setValue(listEquipment);
        this.panel.setSelectedSeverities(entity.getSeverities());
        this.panel.getEvtSimpleFilterPanel().getEvtFilterEventCriteriaPanel().setEventStatus(entity.isAcknowledged(), entity.isCleared());
        FormUtil.setSelectedValue(this.panel.getEvtSimpleFilterPanel().getEvtFilterEventCriteriaPanel().getCmbUserClassifier(), entity.getUserClassifier());
        super.fillUI(entity);
    }
}

