/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.filters;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.selectors.SelectorListComponent;
import com.bwanms.gui.selectors.SelectorListViewValueDisplay;
import com.bwanms.model.Equipment;
import com.bwanms.model.Location;
import com.bwanms.ui.components.ListItem;
import com.bwanms.util.IpAddress;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class EvtFilterTopologyCriteriaPanel
extends JPanel {
    static final Internationalizer i18n = Internationalizer.getInternationalizer(EvtFilterTopologyCriteriaPanel.class);
    private JPanel pnlTopologyCriteria;
    private SelectorListComponent selectorLocations;
    private SelectorListComponent selectorNEList;

    public EvtFilterTopologyCriteriaPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        i18n.getSwingInternationalizer().translateComponent(this);
        this.selectorLocations.setSelectorName("Locations");
        this.selectorLocations.setDisplay(new SelectorListViewValueDisplay(){

            @Override
            public List<ListItem> toDisplayString(Object value) {
                ArrayList<ListItem> listItem = new ArrayList<ListItem>();
                for (Location location : (List)value) {
                    listItem.add(new ListItem(location.getId(), location.getName()));
                }
                return listItem;
            }
        });
        this.selectorLocations.setSelectorView(Selectors.getSelectorView(Location.class, "multipleSelect"));
        this.selectorNEList.setSelectorName("NetworkElements");
        this.selectorNEList.setDisplay(new SelectorListViewValueDisplay(){

            @Override
            public List<ListItem> toDisplayString(Object value) {
                ArrayList<ListItem> listItem = new ArrayList<ListItem>();
                for (Equipment equipment : (List)value) {
                    listItem.add(new ListItem(equipment.getId(), equipment.getModel()));
                }
                return listItem;
            }
        });
        this.selectorNEList.selectorEnabled(false);
    }

    private void initComponents() {
        this.pnlTopologyCriteria = new JPanel();
        this.selectorLocations = new SelectorListComponent(){

            public void setValue(Object value) {
                List listLocations = (List)value;
                this.listModel.clear();
                if (value != null) {
                    for (Location location : listLocations) {
                        this.listModel.add(this.listModel.size(), new ListItem(location.getId(), location.getName()));
                    }
                }
                super.setValue(value);
            }
        };
        this.selectorNEList = new SelectorListComponent(){

            public void setValue(Object value) {
                List listEquipment = (List)value;
                this.listModel.clear();
                if (value != null) {
                    for (Equipment equipment : listEquipment) {
                        this.listModel.add(this.listModel.size(), new ListItem(equipment.getId(), i18n.translateString("EquipmentName", equipment.getName(), new IpAddress(equipment.getIpAddr()).toString())));
                    }
                }
                super.setValue(value);
            }
        };
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout("default:grow", "default"));
        this.pnlTopologyCriteria.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.dluX((int)125), 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.dluX((int)125), 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.selectorLocations.setNullable(true);
        this.pnlTopologyCriteria.add((Component)this.selectorLocations, cc.xywh(3, 3, 1, 3));
        this.selectorNEList.setNullable(true);
        this.pnlTopologyCriteria.add((Component)this.selectorNEList, cc.xywh(5, 3, 1, 3));
        this.add((Component)this.pnlTopologyCriteria, cc.xy(1, 1));
    }

    public SelectorListComponent getSelectorLocations() {
        return this.selectorLocations;
    }

    public SelectorListComponent getSelectorNEList() {
        return this.selectorNEList;
    }

    public JPanel getPnlTopologyCriteria() {
        return this.pnlTopologyCriteria;
    }
}

