/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.filters;

import com.bwanms.client.gui.fault.filters.EvtFilterTopologyCriteriaPanel;
import com.bwanms.client.gui.selectors.EventNameSelectorConfig;
import com.bwanms.client.gui.selectors.MOTypeSelectorConfig;
import com.bwanms.client.gui.selectors.NETypeSelectorConfig;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.selectors.MultipleEnumSelectorView;
import com.bwanms.gui.selectors.SelectorListComponent;
import com.bwanms.model.fault.constants.EventFilterConstantsProvider;
import com.bwanms.ui.components.ListItem;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EvtFilterNETypeCriteriaPanel
extends JPanel {
    static final Internationalizer i18n = Internationalizer.getInternationalizer(EvtFilterNETypeCriteriaPanel.class);
    static final Internationalizer faulti18n = Internationalizer.getInternationalizer("com.bwanms.faultConstants");
    private EvtFilterTopologyCriteriaPanel topologyPanel;
    private List<EventFilterConstantsProvider> constProviders;
    private Map<Object, String> moInstMap = new HashMap<Object, String>();
    private JPanel pnlNETypeCriteria;
    private SelectorListComponent selectorResultNEType;
    private SelectorListComponent selectorResultMOType;
    private JLabel label18;
    private JTextField txtMOInstance;
    private JLabel label1;
    private JTextField txtMOAlias;
    private SelectorListComponent selectorResultTrapName;

    public EvtFilterNETypeCriteriaPanel() {
        this.initComponents();
        this.constProviders = SelectorUtil.loadConstantsProviders();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.txtMOInstance.setEnabled(false);
        this.selectorResultNEType.setSelectorName("NetworkElementType");
        this.addEnumToView(new MultipleEnumSelectorView(new NETypeSelectorConfig(new Enum[0])), this.selectorResultNEType);
        this.selectorResultNEType.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                EvtFilterNETypeCriteriaPanel.this.neTypeSelectorValueChanged(evt);
            }
        });
        this.selectorResultMOType.setSelectorName("ManagedObjectType");
        this.selectorResultMOType.selectorEnabled(false);
        this.selectorResultMOType.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                EvtFilterNETypeCriteriaPanel.this.moTypeSelectorValueChanged(evt);
            }
        });
        this.selectorResultTrapName.setSelectorName("EventName");
        this.addEnumToView(new MultipleEnumSelectorView(new EventNameSelectorConfig(new Enum[0])), this.selectorResultTrapName);
    }

    private void initComponents() {
        this.pnlNETypeCriteria = new JPanel();
        this.selectorResultNEType = new SelectorListComponent(){

            public void setValue(Object value) {
                List listNEType = (List)value;
                this.listModel.clear();
                if (value != null) {
                    for (Enum neType : listNEType) {
                        try {
                            String name = new String(faulti18n.translateString(neType.toString()));
                            this.listModel.add(this.listModel.size(), new ListItem(neType, name));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                super.setValue(value);
            }
        };
        this.selectorResultMOType = new SelectorListComponent(){

            public void setValue(Object value) {
                List listMOType = (List)value;
                this.listModel.clear();
                if (value != null) {
                    for (Enum moType : listMOType) {
                        try {
                            StringBuilder name = new StringBuilder(faulti18n.translateString(moType.toString()));
                            this.listModel.add(this.listModel.size(), new ListItem(moType, name.toString()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                super.setValue(value);
            }
        };
        this.label18 = new JLabel();
        this.txtMOInstance = new JTextField();
        this.label1 = new JLabel();
        this.txtMOAlias = new JTextField();
        this.selectorResultTrapName = new SelectorListComponent(){

            public void setValue(Object value) {
                List listOID = (List)value;
                this.listModel.clear();
                if (value != null) {
                    for (Enum oid : listOID) {
                        try {
                            Method m = oid.getClass().getMethod("oid", new Class[0]);
                            String oidValue = (String)m.invoke((Object)oid, new Object[0]);
                            StringBuilder name = new StringBuilder(faulti18n.translateString(oid.toString())).append(" (").append(oidValue).append(")");
                            this.listModel.add(this.listModel.size(), new ListItem(oid, name.toString()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                super.setValue(value);
            }
        };
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout("default:grow", "default"));
        this.pnlNETypeCriteria.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.dluX((int)125), 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.dluX((int)125), 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec((Size)Sizes.dluY((int)100)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.selectorResultNEType.setNullable(true);
        this.pnlNETypeCriteria.add((Component)this.selectorResultNEType, cc.xywh(3, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.selectorResultMOType.setNullable(true);
        this.pnlNETypeCriteria.add((Component)this.selectorResultMOType, cc.xywh(5, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.label18.setText("ManagedObjectInstance");
        this.pnlNETypeCriteria.add((Component)this.label18, cc.xy(3, 5));
        this.pnlNETypeCriteria.add((Component)this.txtMOInstance, cc.xy(5, 5));
        this.label1.setText("ManagedObjectAlias");
        this.pnlNETypeCriteria.add((Component)this.label1, cc.xy(3, 7));
        this.pnlNETypeCriteria.add((Component)this.txtMOAlias, cc.xy(5, 7));
        this.selectorResultTrapName.setNullable(true);
        this.pnlNETypeCriteria.add((Component)this.selectorResultTrapName, cc.xywh(3, 9, 3, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.add((Component)this.pnlNETypeCriteria, cc.xy(1, 1));
    }

    private void moTypeSelectorValueChanged(PropertyChangeEvent e) {
        List selectedNETypes = (List)this.selectorResultNEType.getValue();
        LinkedList selectedMOTypes = (LinkedList)this.selectorResultMOType.getValue();
        List selectedTrapTypes = (List)this.selectorResultTrapName.getValue();
        LinkedHashSet<Enum> newSetTrapTypes = new LinkedHashSet<Enum>();
        List singleSelection = (List)this.selectorResultMOType.getValue();
        if (singleSelection != null && singleSelection.size() == 1) {
            this.txtMOInstance.setEnabled(true);
        } else {
            this.txtMOInstance.setText(null);
            this.txtMOInstance.setEnabled(false);
        }
        List newConstList = (List)e.getNewValue();
        List oldConstList = (List)e.getOldValue();
        try {
            if (newConstList != null && oldConstList != null) {
                if (newConstList.size() > 0) {
                    for (Enum newConst : newConstList) {
                        for (EventFilterConstantsProvider constProvider : this.constProviders) {
                            if (!constProvider.accept(newConst)) continue;
                            Method m = constProvider.getClass().getMethod("getTrapTypes", Enum.class);
                            Enum[] trapTypes = (Enum[])m.invoke((Object)constProvider, newConst);
                            if (this.selectorResultTrapName.getValue() == null) continue;
                            for (Enum trapType : (List)this.selectorResultTrapName.getValue()) {
                                for (Enum trap : trapTypes) {
                                    if (!trapType.equals(trap)) continue;
                                    newSetTrapTypes.add(trapType);
                                }
                            }
                        }
                    }
                    this.selectorResultTrapName.setValue(new ArrayList(newSetTrapTypes));
                } else {
                    newSetTrapTypes.clear();
                    this.selectorResultTrapName.setValue(new ArrayList(newSetTrapTypes));
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (selectedNETypes == null || selectedNETypes.isEmpty()) {
            if (selectedMOTypes == null || selectedMOTypes.isEmpty()) {
                selectedMOTypes = new LinkedList();
                for (EventFilterConstantsProvider constProvider : this.constProviders) {
                    for (Enum<?> moType : constProvider.getMOTypes()) {
                        selectedMOTypes.add(moType);
                    }
                }
            }
        } else if (selectedMOTypes == null || selectedMOTypes.isEmpty()) {
            selectedMOTypes = new LinkedList();
            for (Enum neType : selectedNETypes) {
                for (EventFilterConstantsProvider constProvider : this.constProviders) {
                    if (!constProvider.accept(neType)) continue;
                    for (Enum<?> moType : constProvider.getMOTypes()) {
                        selectedMOTypes.add(moType);
                    }
                }
            }
        }
        if (selectedMOTypes != null) {
            Enum[] selectedMOTypesEnums = new Enum[selectedMOTypes.size()];
            if (selectedMOTypes.size() > 0) {
                this.addEnumToView(new MultipleEnumSelectorView(new EventNameSelectorConfig(selectedMOTypes.toArray(selectedMOTypesEnums))), this.selectorResultTrapName);
            } else {
                this.selectorResultTrapName.selectorEnabled(true);
            }
        }
    }

    private void neTypeSelectorValueChanged(PropertyChangeEvent e) {
        LinkedList selectedNETypes = (LinkedList)this.selectorResultNEType.getValue();
        LinkedList selectedMOTypes = (LinkedList)this.selectorResultMOType.getValue();
        List selectedTrapTypes = (List)this.selectorResultTrapName.getValue();
        LinkedHashSet<Enum> newSetMOTypes = new LinkedHashSet<Enum>();
        LinkedHashSet<Enum> newSetTrapTypes = new LinkedHashSet<Enum>();
        List newConstList = (List)e.getNewValue();
        List oldConstList = (List)e.getOldValue();
        if (oldConstList != null && newConstList != null) {
            for (Enum enum_ : newConstList) {
                for (EventFilterConstantsProvider constProvider : this.constProviders) {
                    if (!constProvider.accept(enum_)) continue;
                    try {
                        Method m = constProvider.getClass().getMethod("getMOTypes", Enum.class);
                        Enum[] moTypesStr = (Enum[])m.invoke((Object)constProvider, enum_);
                        if (this.selectorResultMOType.getValue() == null) continue;
                        for (Enum enum_2 : (List)this.selectorResultMOType.getValue()) {
                            for (Enum elem : moTypesStr) {
                                if (!enum_2.equals(elem)) continue;
                                newSetMOTypes.add(enum_2);
                            }
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
            for (Enum enum_ : oldConstList) {
                if (newConstList.contains(enum_)) continue;
                for (EventFilterConstantsProvider constProvider : this.constProviders) {
                    if (!constProvider.accept(enum_) || this.selectorResultMOType.getValue() == null) continue;
                    for (Enum moType : (List)this.selectorResultMOType.getValue()) {
                        if (constProvider.accept(moType)) continue;
                        newSetMOTypes.add(moType);
                    }
                }
                this.selectorResultMOType.setValue(new ArrayList(newSetMOTypes));
                break;
            }
        }
        if (oldConstList != null && newConstList != null) {
            for (Enum enum_ : oldConstList) {
                if (newConstList.contains(enum_)) continue;
                for (EventFilterConstantsProvider constProvider : this.constProviders) {
                    if (!constProvider.accept(enum_) || this.selectorResultTrapName.getValue() == null) continue;
                    for (Enum trapType : (List)this.selectorResultTrapName.getValue()) {
                        if (constProvider.accept(trapType)) continue;
                        newSetTrapTypes.add(trapType);
                    }
                }
                this.selectorResultTrapName.setValue(new ArrayList(newSetTrapTypes));
                break;
            }
        }
        try {
            if (oldConstList != null && newConstList != null) {
                List tempListMOTypes = (List)this.selectorResultMOType.getValue();
                if (oldConstList.size() == 0 && newConstList.size() > 0 && tempListMOTypes != null && tempListMOTypes.size() > 0) {
                    for (Enum newConst : newConstList) {
                        for (EventFilterConstantsProvider constProvider : this.constProviders) {
                            if (!constProvider.accept(newConst)) continue;
                            Method m = constProvider.getClass().getMethod("getMOTypes", Enum.class);
                            Enum[] moTypes = (Enum[])m.invoke((Object)constProvider, newConst);
                            for (Enum moType : selectedMOTypes) {
                                for (Enum tempMoType : moTypes) {
                                    if (!moType.equals(tempMoType)) continue;
                                    newSetMOTypes.add(moType);
                                }
                            }
                        }
                    }
                    this.selectorResultMOType.setValue(new ArrayList(newSetMOTypes));
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (oldConstList != null && newConstList != null) {
            List tempListTrapTypes = (List)this.selectorResultTrapName.getValue();
            if (oldConstList.size() == 0 && newConstList.size() > 0 && tempListTrapTypes != null && tempListTrapTypes.size() > 0) {
                for (Enum trapType : selectedTrapTypes) {
                    for (EventFilterConstantsProvider constProvider : this.constProviders) {
                        if (!constProvider.accept(trapType)) continue;
                        boolean isAccepted = false;
                        for (Enum enum_ : selectedNETypes) {
                            if (!constProvider.accept(enum_)) continue;
                            isAccepted = true;
                        }
                        if (!isAccepted) continue;
                        newSetTrapTypes.add(trapType);
                    }
                }
                this.selectorResultTrapName.setValue(new ArrayList(newSetTrapTypes));
            }
        }
        if (selectedNETypes == null || selectedNETypes.isEmpty()) {
            selectedNETypes = new LinkedList();
            selectedMOTypes = new LinkedList();
            for (EventFilterConstantsProvider eventFilterConstantsProvider : this.constProviders) {
                for (Enum<?> moType : eventFilterConstantsProvider.getMOTypes()) {
                    selectedMOTypes.add(moType);
                }
                for (Enum<?> neType : eventFilterConstantsProvider.getNETypes()) {
                    selectedNETypes.add(neType);
                }
            }
        } else if (selectedMOTypes == null || selectedMOTypes.isEmpty()) {
            selectedMOTypes = new LinkedList();
            for (Enum enum_ : selectedNETypes) {
                for (EventFilterConstantsProvider constProvider : this.constProviders) {
                    if (!constProvider.accept(enum_)) continue;
                    for (Enum<?> enum_3 : constProvider.getMOTypes()) {
                        selectedMOTypes.add(enum_3);
                    }
                }
            }
        }
        Enum[] selectedNETypesEnums = new Enum[selectedNETypes.size()];
        if (selectedNETypes.size() > 0) {
            this.addEnumToView(new MultipleEnumSelectorView(new MOTypeSelectorConfig(selectedNETypes.toArray(selectedNETypesEnums))), this.selectorResultMOType);
        } else {
            this.selectorResultMOType.selectorEnabled(false);
        }
        Enum[] enumArray = new Enum[selectedMOTypes.size()];
        if (selectedMOTypes.size() > 0) {
            this.addEnumToView(new MultipleEnumSelectorView(new EventNameSelectorConfig(selectedMOTypes.toArray(enumArray))), this.selectorResultTrapName);
        }
    }

    private void addEnumToView(SelectorView selView, SelectorListComponent selectorResult) {
        if (selView != null) {
            selectorResult.setSelectorView(selView);
            selectorResult.selectorEnabled(true);
        } else {
            selectorResult.selectorEnabled(false);
        }
    }

    public void setAliasVisible(boolean value) {
        this.label1.setVisible(value);
        this.txtMOAlias.setVisible(value);
    }

    public JTextField getTxtMOAlias() {
        return this.txtMOAlias;
    }

    public SelectorListComponent getSelectorResultTrapName() {
        return this.selectorResultTrapName;
    }

    public SelectorListComponent getSelectorResultMOType() {
        return this.selectorResultMOType;
    }

    public SelectorListComponent getSelectorResultNEType() {
        return this.selectorResultNEType;
    }

    public JTextField getTxtMOInstance() {
        return this.txtMOInstance;
    }

    public void setTxtMOInstance(JTextField txtMOInstance) {
        this.txtMOInstance = txtMOInstance;
    }

    public EvtFilterTopologyCriteriaPanel getTopologyPanel() {
        return this.topologyPanel;
    }

    public void setTopologyPanel(EvtFilterTopologyCriteriaPanel topologyPanel) {
        this.topologyPanel = topologyPanel;
    }

    public JPanel getPnlNETypeCriteria() {
        return this.pnlNETypeCriteria;
    }
}

