/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.filters;

import com.bwanms.client.gui.selectors.EventCategorySelectorConfig;
import com.bwanms.client.gui.selectors.EventTypeSelectorConfig;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.selectors.MultipleEnumSelectorView;
import com.bwanms.gui.selectors.SelectorListComponent;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.model.fault.constants.UserClassifier;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.ListItem;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvtFilterEventCriteriaPanel
extends JPanel {
    static final Internationalizer faulti18n = Internationalizer.getInternationalizer("com.bwanms.faultConstants");
    private JPanel pnlEventCriteria;
    private SelectorListComponent selectorEventCategory;
    private SelectorListComponent selectorEventType;
    private JPanel pnlEventSeverity;
    private JCheckBox chkCritical;
    private JCheckBox chkMajor;
    private JCheckBox chkMinor;
    private JCheckBox chkWarning;
    private JCheckBox chkIndeterminate;
    private JCheckBox chkCleared;
    private JPanel pnlEventStatus;
    private JCheckBox chkStatusAcked;
    private JCheckBox chkStatusCleared;
    private JLabel lblUserClassifier;
    private JComboBox cmbUserClassifier;

    public EvtFilterEventCriteriaPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        for (int i = 0; i < UserClassifier.values().length - 1; ++i) {
            this.cmbUserClassifier.addItem(new ComboItem(UserClassifier.values()[i].name(), faulti18n.translateString(UserClassifier.values()[i].toString())));
        }
        this.selectorEventCategory.setSelectorName("EventCategory");
        EvtFilterEventCriteriaPanel.addEnumToView(new MultipleEnumSelectorView(new EventCategorySelectorConfig()), this.selectorEventCategory);
        this.selectorEventCategory.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                EvtFilterEventCriteriaPanel.this.eventCategorySelectionChanged(evt);
            }
        });
        this.selectorEventType.setSelectorName("EventType");
        this.selectorEventType.selectorEnabled(false);
        this.selectorEventType.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                EvtFilterEventCriteriaPanel.this.eventTypeSelectionChanged(evt);
            }
        });
    }

    private void initComponents() {
        this.pnlEventCriteria = new JPanel();
        this.selectorEventCategory = new SelectorListComponent(){

            public void setValue(Object value) {
                List listNEType = (List)value;
                this.listModel.clear();
                if (value != null) {
                    for (Enum neType : listNEType) {
                        try {
                            String name = new String(faulti18n.translateString(neType.toString()));
                            this.listModel.add(this.listModel.size(), new ListItem(neType, name));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                super.setValue(value);
            }
        };
        this.selectorEventType = new SelectorListComponent(){

            public void setValue(Object value) {
                List listNEType = (List)value;
                this.listModel.clear();
                if (value != null) {
                    for (Enum neType : listNEType) {
                        try {
                            String name = new String(faulti18n.translateString(neType.toString()));
                            this.listModel.add(this.listModel.size(), new ListItem(neType, name));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                super.setValue(value);
            }
        };
        this.pnlEventSeverity = new JPanel();
        this.chkCritical = new JCheckBox();
        this.chkMajor = new JCheckBox();
        this.chkMinor = new JCheckBox();
        this.chkWarning = new JCheckBox();
        this.chkIndeterminate = new JCheckBox();
        this.chkCleared = new JCheckBox();
        this.pnlEventStatus = new JPanel();
        this.chkStatusAcked = new JCheckBox();
        this.chkStatusCleared = new JCheckBox();
        this.lblUserClassifier = new JLabel();
        this.cmbUserClassifier = new JComboBox();
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout("default:grow", "default"));
        this.pnlEventCriteria.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.dluX((int)100), 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.dluX((int)100), 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.selectorEventCategory.setNullable(true);
        this.pnlEventCriteria.add((Component)this.selectorEventCategory, cc.xywh(3, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.selectorEventType.setNullable(true);
        this.pnlEventCriteria.add((Component)this.selectorEventType, cc.xywh(5, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.pnlEventSeverity.setBorder(new TitledBorder("EventSeverity"));
        this.pnlEventSeverity.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        this.chkCritical.setText("Critical");
        this.pnlEventSeverity.add((Component)this.chkCritical, cc.xy(3, 1));
        this.chkMajor.setText("Major");
        this.pnlEventSeverity.add((Component)this.chkMajor, cc.xy(7, 1));
        this.chkMinor.setText("Minor");
        this.pnlEventSeverity.add((Component)this.chkMinor, cc.xy(11, 1));
        this.chkWarning.setText("Warning");
        this.pnlEventSeverity.add((Component)this.chkWarning, cc.xy(3, 3));
        this.chkIndeterminate.setText("Indeterminate");
        this.pnlEventSeverity.add((Component)this.chkIndeterminate, cc.xy(7, 3));
        this.chkCleared.setText("Cleared");
        this.pnlEventSeverity.add((Component)this.chkCleared, cc.xy(11, 3));
        this.pnlEventCriteria.add((Component)this.pnlEventSeverity, cc.xywh(3, 5, 3, 1));
        this.pnlEventStatus.setBorder(new TitledBorder("EventStatus"));
        this.pnlEventStatus.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.chkStatusAcked.setText("Acknowledged");
        this.pnlEventStatus.add((Component)this.chkStatusAcked, cc.xy(1, 1));
        this.chkStatusCleared.setText("Cleared");
        this.pnlEventStatus.add((Component)this.chkStatusCleared, cc.xy(3, 1));
        this.pnlEventCriteria.add((Component)this.pnlEventStatus, cc.xywh(3, 7, 3, 1));
        this.lblUserClassifier.setText("UserClassifier");
        this.pnlEventCriteria.add((Component)this.lblUserClassifier, cc.xy(3, 9));
        this.pnlEventCriteria.add((Component)this.cmbUserClassifier, cc.xy(5, 9));
        this.add((Component)this.pnlEventCriteria, cc.xy(1, 1));
    }

    private void eventCategorySelectionChanged(PropertyChangeEvent e) {
        List listEventCategory = (List)this.selectorEventCategory.getValue();
        List newConstList = (List)e.getNewValue();
        List oldConstList = (List)e.getOldValue();
        if (listEventCategory == null) {
            return;
        }
        Enum[] selectedEventCatEnums = new Enum[listEventCategory.size()];
        this.selectorEventType.setValue(null);
        if (listEventCategory.size() > 0) {
            EvtFilterEventCriteriaPanel.addEnumToView(new MultipleEnumSelectorView(new EventTypeSelectorConfig(listEventCategory.toArray(selectedEventCatEnums))), this.selectorEventType);
        } else {
            this.selectorEventType.selectorEnabled(false);
        }
        if (oldConstList == null) {
            this.enableEventSeverity(false);
            this.selectEventSeverity(false);
        }
        if ((oldConstList == null || oldConstList.size() == 0) && newConstList != null && newConstList.size() > 0 && newConstList.contains((Object)EventCategory.Alarm)) {
            this.enableEventSeverity(true);
            this.selectEventSeverity(true);
        }
        if (oldConstList != null && oldConstList.size() > 0 && newConstList != null) {
            if (!newConstList.contains((Object)EventCategory.Alarm) && oldConstList.contains((Object)EventCategory.Alarm)) {
                this.selectEventSeverity(false);
                this.enableEventSeverity(false);
            }
            if (newConstList.contains((Object)EventCategory.Alarm) && !oldConstList.contains((Object)EventCategory.Alarm)) {
                this.selectEventSeverity(true);
                this.enableEventSeverity(true);
            }
        }
    }

    private void eventTypeSelectionChanged(PropertyChangeEvent e) {
        List listEventTypes = (List)this.selectorEventType.getValue();
        if (listEventTypes == null) {
            return;
        }
    }

    private static void addEnumToView(SelectorView selView, SelectorListComponent selector) {
        if (selView != null) {
            selector.setSelectorView(selView);
            selector.selectorEnabled(true);
        } else {
            selector.selectorEnabled(false);
        }
    }

    public SelectorListComponent getSelectorEventCategory() {
        return this.selectorEventCategory;
    }

    public SelectorListComponent getSelectorEventType() {
        return this.selectorEventType;
    }

    private void enableEventSeverity(boolean enabled) {
        this.chkCritical.setEnabled(enabled);
        this.chkMajor.setEnabled(enabled);
        this.chkMinor.setEnabled(enabled);
        this.chkWarning.setEnabled(enabled);
        this.chkIndeterminate.setEnabled(enabled);
        this.chkCleared.setEnabled(enabled);
        if (!enabled) {
            this.chkCritical.setSelected(enabled);
            this.chkMajor.setSelected(enabled);
            this.chkMinor.setSelected(enabled);
            this.chkWarning.setSelected(enabled);
            this.chkIndeterminate.setSelected(enabled);
            this.chkCleared.setSelected(enabled);
        }
    }

    private void selectEventSeverity(boolean selected) {
        this.chkCritical.setSelected(selected);
        this.chkMajor.setSelected(selected);
        this.chkMinor.setSelected(selected);
        this.chkWarning.setSelected(selected);
        this.chkIndeterminate.setSelected(selected);
        this.chkCleared.setSelected(selected);
    }

    public List<Integer> getSelectedSeverities() {
        ArrayList<Integer> selectedSelections = new ArrayList<Integer>();
        if (this.chkCritical.isSelected()) {
            selectedSelections.add(Severity.Critical.value());
        }
        if (this.chkMajor.isSelected()) {
            selectedSelections.add(Severity.Major.value());
        }
        if (this.chkMinor.isSelected()) {
            selectedSelections.add(Severity.Minor.value());
        }
        if (this.chkWarning.isSelected()) {
            selectedSelections.add(Severity.Warning.value());
        }
        if (this.chkIndeterminate.isSelected()) {
            selectedSelections.add(Severity.Indeterminate.value());
        }
        if (this.chkCleared.isSelected()) {
            selectedSelections.add(Severity.Cleared.value());
        }
        return selectedSelections;
    }

    public void setSelectedSeverities(List<Integer> severityValues) {
        this.chkCritical.setSelected(severityValues.contains(Severity.Critical.value()));
        this.chkMajor.setSelected(severityValues.contains(Severity.Major.value()));
        this.chkMinor.setSelected(severityValues.contains(Severity.Minor.value()));
        this.chkWarning.setSelected(severityValues.contains(Severity.Warning.value()));
        this.chkIndeterminate.setSelected(severityValues.contains(Severity.Indeterminate.value()));
        this.chkCleared.setSelected(severityValues.contains(Severity.Cleared.value()));
    }

    public boolean getEventStatusAcknowledged() {
        return this.chkStatusAcked.isSelected();
    }

    public boolean getEventStatusCleared() {
        return this.chkStatusCleared.isSelected();
    }

    public void setEventStatus(boolean acknowledged, boolean cleared) {
        this.chkStatusAcked.setSelected(acknowledged);
        this.chkStatusCleared.setSelected(cleared);
    }

    public void disableUserClassifier() {
        this.lblUserClassifier.setVisible(false);
        this.cmbUserClassifier.setVisible(false);
    }

    public void disableEventStatus() {
        this.pnlEventStatus.setVisible(false);
    }

    public JPanel getPnlEventCriteria() {
        return this.pnlEventCriteria;
    }

    public JPanel getPnlEventSeverity() {
        return this.pnlEventSeverity;
    }

    public JCheckBox getChkCleared() {
        return this.chkCleared;
    }

    public void setChkCleared(JCheckBox chkCleared) {
        this.chkCleared = chkCleared;
    }

    public JCheckBox getChkCritical() {
        return this.chkCritical;
    }

    public void setChkCritical(JCheckBox chkCritical) {
        this.chkCritical = chkCritical;
    }

    public JCheckBox getChkIndeterminate() {
        return this.chkIndeterminate;
    }

    public void setChkIndeterminate(JCheckBox chkIndeterminate) {
        this.chkIndeterminate = chkIndeterminate;
    }

    public JCheckBox getChkMajor() {
        return this.chkMajor;
    }

    public void setChkMajor(JCheckBox chkMajor) {
        this.chkMajor = chkMajor;
    }

    public JCheckBox getChkMinor() {
        return this.chkMinor;
    }

    public void setChkMinor(JCheckBox chkMinor) {
        this.chkMinor = chkMinor;
    }

    public JCheckBox getChkWarning() {
        return this.chkWarning;
    }

    public void setChkWarning(JCheckBox chkWarning) {
        this.chkWarning = chkWarning;
    }

    public JComboBox getCmbUserClassifier() {
        return this.cmbUserClassifier;
    }
}

