/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.filters;

import com.bwanms.client.gui.fault.events.EventHistoryManagerConfig;
import com.bwanms.client.gui.fault.events.EventMonitorManagerConfig;
import com.bwanms.client.gui.fault.filters.EventFilterEditorContainer;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.gui.manager.DefaultRowCreator;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.model.fault.EventFilter;
import com.bwanms.security.Security;
import com.bwanms.services.EntityManagerService;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ServerValidationException;
import com.bwanms.util.fault.FilterUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventFiltersManagerConfig
extends EntityManagerConfig {
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(EventFiltersManagerConfig.class);
    public static final Internationalizer i18nTask = Internationalizer.getInternationalizer("com.bwanms.tasks");
    private static String[] columnNames = new String[]{"Name", "Description", "Owner", "CreationDate"};
    private static String[] columnAttribNames = new String[]{"name", "description", "owner", "creationDate"};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public EventFiltersManagerConfig() {
        for (int i = 0; i < columnNames.length; ++i) {
            this.columns.add(new EntityManagerColumn(columnNames[i], columnAttribNames[i], i18n.translateString(columnNames[i]), new EntityManagerRowDisplayComparator(i)));
        }
        this.filterCriteria = new Vector();
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("Name"), "name", 1, 1, null, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("Owner"), "owner", 1, 1, null, false));
        this.entityRowProvider = new EventFilterManagerRowProvider(EventFiltersManagerConfig.getColumnAttributeNames(this.columns));
        this.declaredActions = new Vector<ManagerAction>();
        this.declaredActions.add(new EventFilterManagerAction("New", 1));
        this.defaultAction = new EventFilterManagerAction("Edit", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new EventFilterManagerAction("Delete", 1));
    }

    @Override
    protected String getBaseName() {
        return EventFilter.class.getName();
    }

    @Override
    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    @Override
    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    @Override
    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    @Override
    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.fm.event_filter_manager";
    }

    @Override
    public String getTitle() {
        return i18n.translateString("EventFiltersManager");
    }

    public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
        if (this.declaredActions.get(0).getName().equals("New")) {
            this.declaredActions.clear();
        }
        this.defaultAction = new EventFilterManagerAction("Select", 1, selectorListener);
        this.declaredActions.add(this.defaultAction);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventFilterManagerRowProvider
    extends DefaultRowCreator {
        public EventFilterManagerRowProvider(List<String> attributes) {
            super(attributes);
        }

        @Override
        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List<String> ret = super.getDisplayValues(entityRow);
            EventFilter evtFilter = (EventFilter)entityRow.getEntity();
            ret.set(3, FilterUtil.formatCreationDate(evtFilter.getCreationDate()));
            return ret;
        }

        @Override
        public String readEntityId(Serializable entity) {
            return String.valueOf(((EventFilter)entity).getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventFilterManagerAction
    extends ManagerAction {
        private EntitiesSelectedCallback selectorListener;

        public EventFilterManagerAction(String name, int category) {
            this(name, category, null);
        }

        public EventFilterManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.name = name;
            this.category = category;
            this.selectorListener = selectorListener;
        }

        @Override
        public void performAction(final ManagerView manager) {
            final List<Serializable> selection = manager.getSelection();
            if ("New".equals(this.name)) {
                try {
                    EventFilter eventFilter = new EventFilter();
                    long currentTime = System.currentTimeMillis();
                    eventFilter.setCreationDate(currentTime);
                    eventFilter.setOwner(Security.getSecurity().getCurrentUserId());
                    new EventFilterEditorContainer(eventFilter, (EntityChangeListener<Serializable>)((EntityChangeListener)((Object)manager)));
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(manager.getUI(), ex.getMessage());
                }
            } else if ("Edit".equals(this.name) && 1 == selection.size()) {
                EventFilter eventFilter = (EventFilter)selection.get(0);
                if (!FilterUtil.checkOwner(eventFilter)) {
                    MessageBox.Alert.quickShow(manager.getUI(), i18n.translateString("CannotEditFilter", eventFilter.getName()) + "\n" + i18n.translateString("YouAreNotOwner"));
                    return;
                }
                EventFilter eventMonitorFilter = EventMonitorManagerConfig.getHelper().getCurrentFilter();
                EventFilter eventHistoryFilter = EventHistoryManagerConfig.getHelper().getCurrentFilter();
                long eventFilterId = eventFilter.getId();
                if (eventMonitorFilter != null && eventMonitorFilter.getId() == eventFilterId || eventHistoryFilter != null && eventHistoryFilter.getId() == eventFilterId) {
                    MessageBox.Alert.quickShow(manager.getUI(), i18n.translateString("CannotEditFilter", eventFilter.getName()) + "\n" + i18n.translateString("FilterInUse"));
                    return;
                }
                try {
                    new EventFilterEditorContainer(eventFilter, (EntityChangeListener<Serializable>)((EntityChangeListener)((Object)manager)));
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(manager.getUI(), ex.getMessage());
                }
            } else if ("Delete".equals(this.name) && !selection.isEmpty()) {
                if (!MessageBox.WarnConfirm.showResult(manager.getUI(), null, i18n.translateString("DeleteConfirmationTitle"))) {
                    return;
                }
                AbstractLongOperation deleteOperation = new AbstractLongOperation(){

                    public String getTitle() {
                        return i18n.translateString("DeleteTitle");
                    }

                    public boolean isCancelable() {
                        return true;
                    }

                    public long getMaxProgress() {
                        return selection.size();
                    }

                    public void run() {
                        long progress = 0L;
                        EntityManagerService eventFilterService = ServiceRegistry.getEntityManagerService();
                        EntityChangeListener listener = null;
                        if (manager instanceof EntityChangeListener) {
                            listener = (EntityChangeListener)((Object)manager);
                        }
                        EventFilter eventMonitorFilter = EventMonitorManagerConfig.getHelper().getCurrentFilter();
                        EventFilter eventHistoryFilter = EventHistoryManagerConfig.getHelper().getCurrentFilter();
                        for (Serializable row : selection) {
                            if (this.shouldCancel) {
                                this.monitor.logMessage(i18n.translateString("Canceled"));
                                break;
                            }
                            EventFilter eventFilter = (EventFilter)row;
                            long eventFilterId = eventFilter.getId();
                            String eventFilterName = eventFilter.getName();
                            String message = i18n.translateString("DeletingEventFilter", eventFilterName);
                            this.monitor.updateProgress(progress, message);
                            if (!FilterUtil.checkOwner(eventFilter)) {
                                this.monitor.logMessage(i18n.translateString("CannotDeleteNotOwner", eventFilterName));
                                this.monitor.updateProgress(++progress, message);
                                continue;
                            }
                            if (eventMonitorFilter != null && eventMonitorFilter.getId() == eventFilterId || eventHistoryFilter != null && eventHistoryFilter.getId() == eventFilterId) {
                                this.monitor.logMessage(i18n.translateString("CannotDeleteFilterInUse", eventFilterName));
                                this.monitor.updateProgress(++progress, message);
                                continue;
                            }
                            try {
                                eventFilterService.delete(eventFilter);
                                ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "EntityDelete", "EventFilterManager", eventFilterName, eventFilter.getClass().getName());
                                if (listener != null) {
                                    listener.entityRemoved(row);
                                }
                                this.monitor.logMessage(i18n.translateString("SuccesfullyDeleted", eventFilterName));
                            }
                            catch (ServerValidationException e) {
                                this.monitor.logMessage(i18n.translateString("DeletingError", eventFilterName, e.getInvalidValues().get(0).getMessage()));
                            }
                            catch (Exception e) {
                                this.monitor.logMessage(i18n.translateString("DeletingError", eventFilterName, e.getMessage()));
                            }
                            this.monitor.updateProgress(++progress, message);
                        }
                        this.monitor.operationCompleted(false);
                    }
                };
                LongOperationUtil.startDetailLongOperationDialog(manager.getUI(), deleteOperation);
            } else if ("Select".equals(this.name) && 1 == selection.size()) {
                this.selectorListener.entitiesSelected(manager.getSelection());
            }
        }

        @Override
        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (!this.name.equals("New")) {
                if (this.name.equals("Edit")) {
                    return 1 == selectionSize;
                }
                if (this.name.equals("Delete")) {
                    return selectionSize > 0;
                }
                if (this.name.equals("Select")) {
                    return 1 == selectionSize;
                }
            }
            return true;
        }
    }
}

