/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.filters;

import com.bwanms.client.gui.fault.filters.EvtFilterView;
import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.editor.EntityEditorContainer;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.model.fault.EventFilter;
import com.bwanms.model.fault.EventTemplate;
import com.bwanms.security.Security;
import com.bwanms.services.EntityAlreadyExistsException;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.ServerValidationException;
import java.io.Serializable;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventFilterEditorContainer
extends EntityEditorContainer<EventFilter> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(EventFilterEditorContainer.class);

    public EventFilterEditorContainer(EventFilter entity, EntityChangeListener<Serializable> listener) throws ServiceException {
        super(entity, listener);
    }

    @Override
    protected String getEntityClass() {
        return i18n.translateString(EventTemplate.class.getName());
    }

    @Override
    public String getEntityId() {
        return String.valueOf(((EventFilter)this.getEntity()).getId());
    }

    @Override
    protected String getEntityName() {
        return this.getEntity() != null ? ((EventFilter)this.getEntity()).getName() : "null";
    }

    @Override
    public String getTitle() {
        return i18n.translateString("EventFilterEditor");
    }

    @Override
    protected EditorView<EventFilter> initView() {
        return new EvtFilterView();
    }

    @Override
    protected void saveEntity() throws ServiceException {
        try {
            super.saveEntity();
            ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), this.entityIsNew ? "EntityCreate" : "EntityChange", "EventFilterManager", ((EventFilter)this.entity).getName(), ((EventFilter)this.entity).getClass().getName());
        }
        catch (EntityAlreadyExistsException e) {
            this.invalidValues.add(new InvalidValue(i18n.translateString("EventFilterWithTheSameNameIsAlreadyDefined"), EventFilter.class, i18n.translateString("Name"), (Object)e.getMessage(), null));
            throw new ServerValidationException(this.invalidValues);
        }
    }
}

