/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.events;

import com.bwanms.backend.services.EventManagerService;
import com.bwanms.client.gui.fault.events.EventAbstractView;
import com.bwanms.client.gui.fault.events.FaultPanel;
import com.bwanms.client.gui.fault.events.OpenAlarmsManagerConfig;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.manager.generic.EventManagerRowTableModel;
import com.bwanms.model.Equipment;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.EventQueryResult;
import com.bwanms.services.ServiceRegistry;
import java.util.ArrayList;
import javax.swing.JComponent;

public class OpenAlarmsView
extends EventAbstractView {
    private Equipment equipment;
    private String moAlias;

    public OpenAlarmsView(Equipment equipment) {
        super(new OpenAlarmsManagerConfig());
        this.equipment = equipment;
        this.moAlias = equipment.getName();
        this.sqlExpression = "(" + Event.Property.equipmentId.columnName() + " = " + equipment.getId() + " OR " + Event.Property.moAlias.columnName() + " = '" + this.moAlias + "') AND " + Event.Property.eventSeverity.columnName() + " > 1 AND " + Event.Property.clearedBy.columnName() + " IS NULL AND " + Event.Property.deleted.columnName() + " = 0";
        this.counters = new int[]{0, 0, 0, 0, 0, 0, 0};
    }

    public OpenAlarmsView(Equipment equipment, boolean useMOAlias) {
        super(new OpenAlarmsManagerConfig());
        this.equipment = equipment;
        if (useMOAlias) {
            this.moAlias = equipment.getName();
            this.sqlExpression = Event.Property.moAlias.columnName() + " = '" + this.moAlias + "' AND " + Event.Property.eventSeverity.columnName() + " > 1 AND " + Event.Property.clearedBy.columnName() + " IS NULL AND " + Event.Property.deleted.columnName() + " = 0";
        } else {
            this.sqlExpression = Event.Property.equipmentId.columnName() + " = " + equipment.getId() + " AND " + Event.Property.eventSeverity.columnName() + " > 1 AND " + Event.Property.clearedBy.columnName() + " IS NULL AND " + Event.Property.deleted.columnName() + " = 0";
        }
        this.counters = new int[]{0, 0, 0, 0, 0, 0, 0};
    }

    public OpenAlarmsView(Equipment equipment, String managedObjectId) {
        super(new OpenAlarmsManagerConfig());
        this.equipment = equipment;
        this.moAlias = managedObjectId;
        this.sqlExpression = Event.Property.equipmentId.columnName() + " = " + equipment.getId() + " AND " + Event.Property.managedObject.columnName() + " = '" + managedObjectId + "' AND " + Event.Property.eventSeverity.columnName() + " > 1 AND " + Event.Property.clearedBy.columnName() + " IS NULL AND " + Event.Property.deleted.columnName() + " = 0";
        this.counters = new int[]{0, 0, 0, 0, 0, 0, 0};
    }

    public void initUI() {
        JComponent navigatorForm = this.navigatorView != null ? this.navigatorView.getUI() : null;
        JComponent filterForm = this.filterView != null ? this.filterView.getUI() : null;
        this.form = new FaultPanel(i18n, filterForm, this.resultView.getUI(), navigatorForm);
        this.form.getPnlFilterView().setVisible(false);
        this.form.getPnlCountersView().setVisible(false);
        this.performQuery();
    }

    public String getTitle() {
        if (null != this.moAlias) {
            if (this.moAlias.compareTo(this.equipment.getName()) == 0) {
                return "Open Alarms for " + this.equipment.getName();
            }
            return "Open Alarms for " + this.equipment.getName() + " " + this.moAlias;
        }
        return "Open Alarms for " + this.equipment.getName();
    }

    public JComponent getUI() {
        if (this.form == null) {
            this.initUI();
        }
        return this.form;
    }

    public void performQuery() {
        EventQueryResult eventResult;
        EntityManagerRowProvider rowCreator = this.config.getEntityRowProvider();
        EventManagerService service = ServiceRegistry.getEventManagerService();
        try {
            eventResult = service.getEvents(this.sqlExpression, 0L);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        ArrayList<EntityManagerRow> result = new ArrayList<EntityManagerRow>();
        for (Event event : eventResult.getEvents()) {
            result.add(rowCreator.createRow(event));
            this.updateCounters(event, 1);
        }
        ((EventManagerRowTableModel)this.resultView.getTableModel()).replaceData(result);
        this.form.setCounters(this.counters, eventResult.getCounters());
    }

    protected void loadSettings() {
    }

    protected void saveSettings() {
    }
}

