/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.events;

import com.bwanms.client.gui.fault.ColorSchema;
import com.bwanms.client.gui.fault.filters.EvtFilterTimeCriteriaPanel;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.selectors.SelectorListOneElementComponent;
import com.bwanms.gui.selectors.SelectorListViewValueDisplay;
import com.bwanms.model.fault.EventFilter;
import com.bwanms.model.fault.EvtFilterSeverity;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.ui.components.ListItem;
import com.bwanms.util.FormUtil;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.toedter.calendar.JDateChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultPanel
extends JPanel {
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(FaultPanel.class);
    private static final long dateOffsetDays = 864000000L;
    private JPanel pnlFilterView;
    private JLabel lblCustomFilter;
    private SelectorListOneElementComponent selectorFilters;
    private JButton btnSeverities;
    private EvtFilterTimeCriteriaPanel pnlTimeCriteriaPanel;
    private JCheckBox chkNow;
    private JToggleButton tglFreeze;
    private JButton btnRefresh;
    private JButton btnHelp;
    private JPanel pnlTableView;
    private JPanel pnlNavigatorView;
    private JPanel pnlCountersView;
    private JLabel lblCriticalColor;
    private JLabel lblCriticalCounters;
    private JLabel label1;
    private JLabel lblMajorColor;
    private JLabel lblMajorCounters;
    private JLabel label2;
    private JLabel lblMinorColor;
    private JLabel lblMinorCounters;
    private JLabel label3;
    private JLabel lblWarningColor;
    private JLabel lblWarningCounters;
    private JLabel label4;
    private JLabel lblIndeterminateColor;
    private JLabel lblClearedColor;
    private JLabel lblClearedCounters;
    private JLabel lblIndeterminateCounters;
    private JLabel label5;
    private JLabel label6;
    private JLabel lblOtherColor;
    private JLabel lblOtherCounters;
    private JLabel label7;
    private JPopupMenu popupSeverities;
    private JCheckBoxMenuItem chkCritical;
    private JCheckBoxMenuItem chkMajor;
    private JCheckBoxMenuItem chkMinor;
    private JCheckBoxMenuItem chkWarning;
    private JCheckBoxMenuItem chkIndeterminate;
    private JCheckBoxMenuItem chkCleared;
    private JCheckBoxMenuItem chkOther;

    public FaultPanel(Internationalizer i18n, JComponent filterComponent, JComponent resultComponent, JComponent navigatorComponent) {
        this.initComponents();
        this.postInitComponents(i18n, filterComponent, resultComponent, navigatorComponent);
    }

    private void postInitComponents(Internationalizer i18n, JComponent filterComponent, JComponent resultComponent, JComponent navigatorComponent) {
        i18n.getSwingInternationalizer().translateComponent(this);
        this.pnlTimeCriteriaPanel.setPnlBackgroundColor(Color.WHITE);
        this.pnlTimeCriteriaPanel.getDateChooserFrom().getSpinner().setModel(this.pnlTimeCriteriaPanel.getDateChooserFrom().getSpinner().getModel());
        this.pnlTableView.add(resultComponent);
        if (navigatorComponent != null) {
            this.pnlNavigatorView.add(navigatorComponent);
        }
        this.selectorFilters.setJListEnabled(false);
        this.selectorFilters.setDisplay(new SelectorListViewValueDisplay(){

            @Override
            public List<ListItem> toDisplayString(Object value) {
                ArrayList<ListItem> listItem = new ArrayList<ListItem>();
                List eventFilter = (List)value;
                listItem.add(new ListItem(eventFilter, ((EventFilter)eventFilter.get(0)).getName()));
                return listItem;
            }
        });
        this.selectorFilters.setSelectorView(Selectors.getSelectorView(EventFilter.class, ""));
        Font font = this.selectorFilters.getListSelectedValues().getFont();
        float a = 30.0f;
        this.selectorFilters.getListSelectedValues().setFont(font.deriveFont(a));
        this.selectorFilters.getScrollPane1().setHorizontalScrollBarPolicy(31);
        this.timePanelConfigure();
        this.setColorSchema();
    }

    private void timePanelConfigure() {
        FaultPanel.setDateForNow(this.pnlTimeCriteriaPanel.getDateChooserFrom(), this.pnlTimeCriteriaPanel.getDateChooserTo(), true);
        this.chkNow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean isNow = FaultPanel.this.chkNow.isSelected();
                if (isNow) {
                    FaultPanel.setDateForNow(FaultPanel.this.pnlTimeCriteriaPanel.getDateChooserFrom(), FaultPanel.this.pnlTimeCriteriaPanel.getDateChooserTo(), false);
                }
                FormUtil.setEnabled((Container)FaultPanel.this.pnlTimeCriteriaPanel.getDateChooserTo(), !isNow);
            }
        });
    }

    public static void setDateForNow(JDateChooser fromDateChooser, JDateChooser toDateChooser, boolean setFrom) {
        long currentTime = System.currentTimeMillis();
        toDateChooser.setDate(new Date(currentTime));
        if (setFrom) {
            fromDateChooser.setDate(new Date(currentTime - 864000000L));
        }
    }

    public void setCounters(int[] counters, int[] countersTotal) {
        if (this.btnRefresh.isVisible()) {
            this.lblCriticalCounters.setText(String.valueOf(counters[6]) + "/" + String.valueOf(countersTotal[6]));
            this.lblMajorCounters.setText(String.valueOf(counters[5]) + "/" + String.valueOf(countersTotal[5]));
            this.lblMinorCounters.setText(String.valueOf(counters[4]) + "/" + String.valueOf(countersTotal[4]));
            this.lblWarningCounters.setText(String.valueOf(counters[3]) + "/" + String.valueOf(countersTotal[3]));
            this.lblIndeterminateCounters.setText(String.valueOf(counters[2]) + "/" + String.valueOf(countersTotal[2]));
            this.lblClearedCounters.setText(String.valueOf(counters[1]) + "/" + String.valueOf(countersTotal[1]));
            this.lblOtherCounters.setText(String.valueOf(counters[0]) + "/" + String.valueOf(countersTotal[0]));
        } else {
            this.lblCriticalCounters.setText((this.chkCritical.isSelected() ? String.valueOf(counters[6]) : Integer.valueOf(0)) + "/" + String.valueOf(countersTotal[6]));
            this.lblMajorCounters.setText((this.chkMajor.isSelected() ? String.valueOf(counters[5]) : Integer.valueOf(0)) + "/" + String.valueOf(countersTotal[5]));
            this.lblMinorCounters.setText((this.chkMinor.isSelected() ? String.valueOf(counters[4]) : Integer.valueOf(0)) + "/" + String.valueOf(countersTotal[4]));
            this.lblWarningCounters.setText((this.chkWarning.isSelected() ? String.valueOf(counters[3]) : Integer.valueOf(0)) + "/" + String.valueOf(countersTotal[3]));
            this.lblIndeterminateCounters.setText((this.chkIndeterminate.isSelected() ? String.valueOf(counters[2]) : Integer.valueOf(0)) + "/" + String.valueOf(countersTotal[2]));
            this.lblClearedCounters.setText((this.chkCleared.isSelected() ? String.valueOf(counters[1]) : Integer.valueOf(0)) + "/" + String.valueOf(countersTotal[1]));
            this.lblOtherCounters.setText((this.chkOther.isSelected() ? String.valueOf(counters[0]) : Integer.valueOf(0)) + "/" + String.valueOf(countersTotal[0]));
        }
    }

    public void setCountersChkBoxes(int[] counters, JCheckBoxMenuItem chkBox) {
        if (chkBox == this.chkCritical) {
            this.replaceText(this.chkCritical.isSelected(), this.lblCriticalCounters, counters[6]);
        }
        if (chkBox == this.chkMajor) {
            this.replaceText(this.chkMajor.isSelected(), this.lblMajorCounters, counters[5]);
        }
        if (chkBox == this.chkMinor) {
            this.replaceText(this.chkMinor.isSelected(), this.lblMinorCounters, counters[4]);
        }
        if (chkBox == this.chkWarning) {
            this.replaceText(this.chkWarning.isSelected(), this.lblWarningCounters, counters[3]);
        }
        if (chkBox == this.chkIndeterminate) {
            this.replaceText(this.chkIndeterminate.isSelected(), this.lblIndeterminateCounters, counters[2]);
        }
        if (chkBox == this.chkCleared) {
            this.replaceText(this.chkCleared.isSelected(), this.lblClearedCounters, counters[1]);
        }
        if (chkBox == this.chkOther) {
            this.replaceText(this.chkOther.isSelected(), this.lblOtherCounters, counters[0]);
        }
    }

    private void replaceText(boolean isSelected, JLabel lblCounters, int value) {
        String oldValue = lblCounters.getText();
        String a = oldValue.split("/")[0];
        String b = oldValue.replaceFirst(a, isSelected ? String.valueOf(value) : "0");
        lblCounters.setText(b);
    }

    private void setColorSchema() {
        ColorSchema colorSchema = ColorSchema.getActiveSchema();
        this.lblCriticalColor.setBackground(colorSchema.critical());
        this.lblMajorColor.setBackground(colorSchema.major());
        this.lblMinorColor.setBackground(colorSchema.minor());
        this.lblWarningColor.setBackground(colorSchema.warning());
        this.lblIndeterminateColor.setBackground(colorSchema.indeterminate());
        this.lblClearedColor.setBackground(colorSchema.cleared());
        this.lblOtherColor.setBackground(colorSchema.other());
    }

    private void initComponents() {
        this.pnlFilterView = new JPanel();
        this.lblCustomFilter = new JLabel();
        this.selectorFilters = new SelectorListOneElementComponent(){

            public void setValue(Object value) {
                EventFilter eventFilter;
                this.listModel.clear();
                if (value != null && (eventFilter = (EventFilter)((List)value).get(0)) != null) {
                    this.listModel.add(this.listModel.size(), new ListItem(eventFilter, eventFilter.getName()));
                }
                super.setValue(value);
            }
        };
        this.btnSeverities = new JButton();
        this.pnlTimeCriteriaPanel = new EvtFilterTimeCriteriaPanel();
        this.chkNow = new JCheckBox();
        this.tglFreeze = new JToggleButton();
        this.btnRefresh = new JButton();
        this.btnHelp = new JButton();
        this.pnlTableView = new JPanel();
        this.pnlNavigatorView = new JPanel();
        this.pnlCountersView = new JPanel();
        this.lblCriticalColor = new JLabel();
        this.lblCriticalCounters = new JLabel();
        this.label1 = new JLabel();
        this.lblMajorColor = new JLabel();
        this.lblMajorCounters = new JLabel();
        this.label2 = new JLabel();
        this.lblMinorColor = new JLabel();
        this.lblMinorCounters = new JLabel();
        this.label3 = new JLabel();
        this.lblWarningColor = new JLabel();
        this.lblWarningCounters = new JLabel();
        this.label4 = new JLabel();
        this.lblIndeterminateColor = new JLabel();
        this.lblClearedColor = new JLabel();
        this.lblClearedCounters = new JLabel();
        this.lblIndeterminateCounters = new JLabel();
        this.label5 = new JLabel();
        this.label6 = new JLabel();
        this.lblOtherColor = new JLabel();
        this.lblOtherCounters = new JLabel();
        this.label7 = new JLabel();
        this.popupSeverities = new JPopupMenu();
        this.chkCritical = new JCheckBoxMenuItem();
        this.chkMajor = new JCheckBoxMenuItem();
        this.chkMinor = new JCheckBoxMenuItem();
        this.chkWarning = new JCheckBoxMenuItem();
        this.chkIndeterminate = new JCheckBoxMenuItem();
        this.chkCleared = new JCheckBoxMenuItem();
        this.chkOther = new JCheckBoxMenuItem();
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.MINIMUM, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.pnlFilterView.setBackground(Color.white);
        this.pnlFilterView.setBorder(new EtchedBorder());
        this.pnlFilterView.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)110)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.CENTER, (Size)Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.CENTER, (Size)Sizes.PREFERRED, 0.0), FormFactory.PREF_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)20)), FormFactory.UNRELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.UNRELATED_GAP_ROWSPEC, new RowSpec((Size)Sizes.dluY((int)15)), FormFactory.UNRELATED_GAP_ROWSPEC}));
        this.lblCustomFilter.setText("CustomFilter");
        this.pnlFilterView.add((Component)this.lblCustomFilter, cc.xy(2, 2));
        this.selectorFilters.setNullable(true);
        this.pnlFilterView.add((Component)this.selectorFilters, cc.xy(4, 2));
        this.btnSeverities.setText("Severities");
        this.btnSeverities.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FaultPanel.this.btnSeveritiesActionPerformed(e);
            }
        });
        this.pnlFilterView.add((Component)this.btnSeverities, cc.xywh(6, 2, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.pnlTimeCriteriaPanel.setBackground(Color.white);
        this.pnlFilterView.add((Component)this.pnlTimeCriteriaPanel, cc.xywh(8, 1, 1, 3, CellConstraints.FILL, CellConstraints.CENTER));
        this.chkNow.setText("Now");
        this.chkNow.setBackground(Color.white);
        this.chkNow.setSelected(true);
        this.pnlFilterView.add((Component)this.chkNow, cc.xywh(10, 2, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.tglFreeze.setText("Freeze");
        this.tglFreeze.setRolloverEnabled(true);
        this.tglFreeze.setMaximumSize(new Dimension(80, 22));
        this.tglFreeze.setMinimumSize(new Dimension(80, 22));
        this.tglFreeze.setPreferredSize(new Dimension(80, 22));
        this.tglFreeze.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FaultPanel.this.tglFreezeActionPerformed(e);
            }
        });
        this.pnlFilterView.add((Component)this.tglFreeze, cc.xywh(12, 2, 1, 1, CellConstraints.FILL, CellConstraints.FILL));
        this.btnRefresh.setText("Refresh");
        this.pnlFilterView.add((Component)this.btnRefresh, cc.xywh(13, 2, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.pnlFilterView.add((Component)this.btnHelp, cc.xywh(15, 2, 1, 1, CellConstraints.CENTER, CellConstraints.FILL));
        this.add((Component)this.pnlFilterView, cc.xy(2, 1));
        this.pnlTableView.setLayout(new BorderLayout());
        this.add((Component)this.pnlTableView, cc.xywh(2, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.pnlNavigatorView.setLayout(new BorderLayout());
        this.add((Component)this.pnlNavigatorView, cc.xy(2, 7));
        this.pnlCountersView.setBorder(new TitledBorder("Show"));
        this.pnlCountersView.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.DLUX9), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.DLUX9), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.DLUX9), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.DLUX9), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.DLUX9), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.DLUX9), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.DLUX9), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.MIN_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{new RowSpec((Size)Sizes.DLUY9), FormFactory.LINE_GAP_ROWSPEC}));
        this.lblCriticalColor.setBackground(new Color(255, 51, 51));
        this.lblCriticalColor.setOpaque(true);
        this.lblCriticalColor.setBorder(new MatteBorder(1, 1, 1, 1, Color.black));
        this.pnlCountersView.add((Component)this.lblCriticalColor, cc.xywh(2, 1, 1, 1, CellConstraints.FILL, CellConstraints.FILL));
        this.pnlCountersView.add((Component)this.lblCriticalCounters, cc.xywh(4, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.label1.setText("Critical");
        this.pnlCountersView.add((Component)this.label1, cc.xy(6, 1));
        this.lblMajorColor.setBackground(new Color(255, 153, 0));
        this.lblMajorColor.setOpaque(true);
        this.lblMajorColor.setBorder(new MatteBorder(1, 1, 1, 1, Color.black));
        this.pnlCountersView.add((Component)this.lblMajorColor, cc.xywh(8, 1, 1, 1, CellConstraints.FILL, CellConstraints.FILL));
        this.pnlCountersView.add((Component)this.lblMajorCounters, cc.xywh(10, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.label2.setText("Major");
        this.pnlCountersView.add((Component)this.label2, cc.xy(12, 1));
        this.lblMinorColor.setBackground(Color.yellow);
        this.lblMinorColor.setOpaque(true);
        this.lblMinorColor.setBorder(new MatteBorder(1, 1, 1, 1, Color.black));
        this.pnlCountersView.add((Component)this.lblMinorColor, cc.xywh(14, 1, 1, 1, CellConstraints.FILL, CellConstraints.FILL));
        this.pnlCountersView.add((Component)this.lblMinorCounters, cc.xywh(16, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.label3.setText("Minor");
        this.pnlCountersView.add((Component)this.label3, cc.xy(18, 1));
        this.lblWarningColor.setBackground(new Color(51, 255, 255));
        this.lblWarningColor.setOpaque(true);
        this.lblWarningColor.setBorder(new MatteBorder(1, 1, 1, 1, Color.black));
        this.pnlCountersView.add((Component)this.lblWarningColor, cc.xywh(20, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.pnlCountersView.add((Component)this.lblWarningCounters, cc.xywh(22, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.label4.setText("Warning");
        this.pnlCountersView.add((Component)this.label4, cc.xy(24, 1));
        this.lblIndeterminateColor.setBackground(Color.magenta);
        this.lblIndeterminateColor.setOpaque(true);
        this.lblIndeterminateColor.setBorder(new MatteBorder(1, 1, 1, 1, Color.black));
        this.pnlCountersView.add((Component)this.lblIndeterminateColor, cc.xywh(26, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.lblClearedColor.setBackground(new Color(51, 255, 0));
        this.lblClearedColor.setOpaque(true);
        this.lblClearedColor.setBorder(new MatteBorder(1, 1, 1, 1, Color.black));
        this.pnlCountersView.add((Component)this.lblClearedColor, cc.xywh(32, 1, 1, 1, CellConstraints.FILL, CellConstraints.FILL));
        this.pnlCountersView.add((Component)this.lblClearedCounters, cc.xywh(34, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.pnlCountersView.add((Component)this.lblIndeterminateCounters, cc.xywh(28, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.label5.setText("Indeterminate");
        this.pnlCountersView.add((Component)this.label5, cc.xy(30, 1));
        this.label6.setText("Cleared");
        this.pnlCountersView.add((Component)this.label6, cc.xy(36, 1));
        this.lblOtherColor.setBackground(Color.white);
        this.lblOtherColor.setOpaque(true);
        this.lblOtherColor.setBorder(new MatteBorder(1, 1, 1, 1, Color.black));
        this.pnlCountersView.add((Component)this.lblOtherColor, cc.xywh(38, 1, 1, 1, CellConstraints.FILL, CellConstraints.FILL));
        this.pnlCountersView.add((Component)this.lblOtherCounters, cc.xywh(40, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.label7.setText("Other");
        this.pnlCountersView.add((Component)this.label7, cc.xy(42, 1));
        this.add((Component)this.pnlCountersView, cc.xy(2, 9));
        this.popupSeverities.setPreferredSize(new Dimension(120, 146));
        this.chkCritical.setText("Critical");
        this.chkCritical.setSelected(true);
        this.chkCritical.setBackground(Color.white);
        this.popupSeverities.add(this.chkCritical);
        this.chkMajor.setText("Major");
        this.chkMajor.setSelected(true);
        this.chkMajor.setBackground(Color.white);
        this.popupSeverities.add(this.chkMajor);
        this.chkMinor.setText("Minor");
        this.chkMinor.setSelected(true);
        this.chkMinor.setBackground(Color.white);
        this.popupSeverities.add(this.chkMinor);
        this.chkWarning.setText("Warning");
        this.chkWarning.setSelected(true);
        this.chkWarning.setBackground(Color.white);
        this.popupSeverities.add(this.chkWarning);
        this.chkIndeterminate.setText("Indeterminate");
        this.chkIndeterminate.setSelected(true);
        this.chkIndeterminate.setBackground(Color.white);
        this.popupSeverities.add(this.chkIndeterminate);
        this.chkCleared.setText("Cleared");
        this.chkCleared.setSelected(true);
        this.chkCleared.setBackground(Color.white);
        this.popupSeverities.add(this.chkCleared);
        this.chkOther.setText("Other");
        this.chkOther.setSelected(true);
        this.chkOther.setBackground(Color.white);
        this.popupSeverities.add(this.chkOther);
    }

    public JButton getBtnRefresh() {
        return this.btnRefresh;
    }

    public JButton getBtnHelp() {
        return this.btnHelp;
    }

    public SelectorListOneElementComponent getSelectorFilters() {
        return this.selectorFilters;
    }

    public JToggleButton getTglFreeze() {
        return this.tglFreeze;
    }

    private void tglFreezeActionPerformed(ActionEvent e) {
        this.tglFreeze.setText(i18n.translateString(this.tglFreeze.isSelected() ? "Unfreeze" : "Freeze"));
    }

    public JCheckBoxMenuItem getChkCritical() {
        return this.chkCritical;
    }

    public JCheckBoxMenuItem getChkMajor() {
        return this.chkMajor;
    }

    public JCheckBoxMenuItem getChkMinor() {
        return this.chkMinor;
    }

    public JCheckBoxMenuItem getChkWarning() {
        return this.chkWarning;
    }

    public JCheckBoxMenuItem getChkIndeterminate() {
        return this.chkIndeterminate;
    }

    public JCheckBoxMenuItem getChkCleared() {
        return this.chkCleared;
    }

    public JCheckBoxMenuItem getChkOther() {
        return this.chkOther;
    }

    private void btnSeveritiesActionPerformed(ActionEvent e) {
        this.popupSeverities.show(this.btnSeverities, 0, this.btnSeverities.getHeight());
    }

    public JPanel getPnlCountersView() {
        return this.pnlCountersView;
    }

    public JButton getBtnSeverities() {
        return this.btnSeverities;
    }

    public EvtFilterTimeCriteriaPanel getPnlTimeCriteriaPanel() {
        return this.pnlTimeCriteriaPanel;
    }

    public JCheckBox getChkNow() {
        return this.chkNow;
    }

    public void enableSeverities(Iterator<EvtFilterSeverity> evtSeverities) {
        this.enableSeverities(false);
        while (evtSeverities.hasNext()) {
            int severity = new Byte(evtSeverities.next().getSeverity()).intValue();
            switch (Severity.fromValue(severity)) {
                case Critical: {
                    this.chkCritical.setEnabled(true);
                    this.chkCritical.setSelected(true);
                    break;
                }
                case Major: {
                    this.chkMajor.setEnabled(true);
                    this.chkMajor.setSelected(true);
                    break;
                }
                case Minor: {
                    this.chkMinor.setEnabled(true);
                    this.chkMinor.setSelected(true);
                    break;
                }
                case Warning: {
                    this.chkWarning.setEnabled(true);
                    this.chkWarning.setSelected(true);
                    break;
                }
                case Indeterminate: {
                    this.chkIndeterminate.setEnabled(true);
                    this.chkIndeterminate.setSelected(true);
                    break;
                }
                case Cleared: {
                    this.chkCleared.setEnabled(true);
                    this.chkCleared.setSelected(true);
                    break;
                }
                case Other: {
                    this.chkOther.setEnabled(true);
                    this.chkOther.setSelected(true);
                }
            }
        }
    }

    public void enableSeverities(boolean enable) {
        this.chkCritical.setEnabled(enable);
        this.chkCritical.setSelected(enable);
        this.chkMajor.setEnabled(enable);
        this.chkMajor.setSelected(enable);
        this.chkMinor.setEnabled(enable);
        this.chkMinor.setSelected(enable);
        this.chkWarning.setEnabled(enable);
        this.chkWarning.setSelected(enable);
        this.chkIndeterminate.setEnabled(enable);
        this.chkIndeterminate.setSelected(enable);
        this.chkCleared.setEnabled(enable);
        this.chkCleared.setSelected(enable);
        this.chkOther.setEnabled(enable);
        this.chkOther.setSelected(enable);
    }

    public JPanel getPnlFilterView() {
        return this.pnlFilterView;
    }
}

